/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.util.Map;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GitIndex;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.Tree;
import org.eclipse.jgit.lib.TreeEntry;
import org.eclipse.jgit.lib.WorkDirCheckout;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepositoryAccess {
    private static final Object NULL_STRING = "null";
    private final boolean autoFetch;
    private final String component;
    private final File localRepo;
    private final String remoteName;
    private Repository repository;
    private RevWalk revWalk;
    private final URIish repoURI;

    private static void appendObjectSummary(StringBuilder sb, String type, PersonIdent author, String message) {
        sb.append(String.valueOf(type) + " by ");
        sb.append(author.getName());
        sb.append("\n");
        sb.append(author.getWhen());
        sb.append("\n\n");
        int newLine = message.indexOf(10);
        int last = newLine != -1 ? newLine : message.length();
        sb.append(message.substring(0, last));
    }

    RepositoryAccess(String fmt, Map<String, String> properties) throws CoreException {
        int comma = fmt.lastIndexOf(44);
        if (comma >= 0) {
            this.component = fmt.substring(comma + 1);
            fmt = fmt.substring(0, comma);
        } else {
            this.component = null;
        }
        this.localRepo = new File(fmt, ".git");
        if (!this.localRepo.isAbsolute()) {
            throw BuckminsterException.fromMessage((String)"Git repository path \"%s\" is not absolute", (Object[])new Object[]{fmt});
        }
        String remoteURIStr = properties.get("git.remote.uri");
        if (remoteURIStr != null) {
            try {
                URIish uri;
                String username;
                if (remoteURIStr.startsWith("file:/") && remoteURIStr.length() > 6 && remoteURIStr.charAt(6) != '/') {
                    remoteURIStr = "file:///" + remoteURIStr.substring(6);
                }
                if ((username = (uri = new URIish(remoteURIStr)).getUser()) != null) {
                    String password;
                    if (NULL_STRING.equals(username)) {
                        uri = uri.setUser(null);
                    }
                    if ((password = uri.getPass()) != null && NULL_STRING.equals(password)) {
                        uri = uri.setPass(null);
                    }
                }
                this.repoURI = uri;
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        } else {
            this.repoURI = null;
        }
        fmt = this.localRepo.getAbsolutePath();
        if (!this.localRepo.exists() && this.repoURI == null) {
            throw BuckminsterException.fromMessage((String)"Git repository path \"%s\" does not exist and value is provided for the \"%s\" property", (Object[])new Object[]{fmt, "git.remote.uri"});
        }
        this.autoFetch = Boolean.parseBoolean(properties.get("git.auto.fetch"));
        String tmp = properties.get("git.remote.name");
        if (tmp == null) {
            tmp = "origin";
        }
        this.remoteName = tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkout(VersionMatch versionMatch, File destination, IProgressMonitor monitor) throws CoreException {
        try {
            Repository local = this.getRepository(monitor);
            String string = this.localRepo.getAbsolutePath().intern();
            synchronized (string) {
                GitIndex index = new GitIndex(local);
                WorkDirCheckout co = new WorkDirCheckout(local, local.getWorkTree(), index, this.getComponentTree(versionMatch, monitor));
                co.checkout();
                index.write();
            }
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    synchronized void close() {
        if (this.revWalk != null) {
            this.revWalk.dispose();
            this.revWalk = null;
        }
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
    }

    RevCommit getCommit(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        try {
            ObjectId objId = null;
            Repository repo = this.getRepository(monitor);
            String revstr = this.getGitTag(versionMatch);
            if (revstr != null) {
                objId = repo.resolve(revstr);
                if (objId == null) {
                    throw BuckminsterException.fromMessage((String)"Unable to obtain ObjectID for tag %s", (Object[])new Object[]{revstr});
                }
            } else {
                revstr = this.getGitBranch(versionMatch);
                objId = repo.resolve(revstr);
                if (objId == null) {
                    String remoteBranch = this.getGitRemoteBranch(versionMatch);
                    objId = repo.resolve(remoteBranch);
                    if (objId == null) {
                        throw BuckminsterException.fromMessage((String)"Unable to obtain ObjectID for branch %s", (Object[])new Object[]{revstr});
                    }
                    this.fetch(versionMatch, monitor);
                    objId = repo.resolve(revstr);
                    if (objId == null) {
                        throw BuckminsterException.fromMessage((String)"Unable to obtain cloned local Ref for branch %s", (Object[])new Object[]{remoteBranch});
                    }
                }
            }
            return this.revWalk.parseCommit((AnyObjectId)objId);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    String getComponent() {
        return this.component;
    }

    Tree getComponentTree(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        try {
            RevCommit c = this.getCommit(versionMatch, monitor);
            if (this.component == null) {
                return this.repository.mapTree((ObjectId)c.getTree());
            }
            return (Tree)this.repository.mapTree((ObjectId)c.getTree()).findTreeMember(this.component);
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    synchronized Repository getRepository(IProgressMonitor monitor) throws CoreException {
        if (this.repository != null) {
            return this.repository;
        }
        boolean infant = !this.localRepo.exists();
        try {
            this.repository = new FileRepository(this.localRepo);
            if (infant) {
                this.repository.create();
                this.fetch(null, monitor);
            }
            this.revWalk = new RevWalk(this.repository);
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        return this.repository;
    }

    void inspectObj(Object obj) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.inspectObj(sb, obj);
        System.out.println(sb);
        System.out.println();
    }

    void inspectObj(StringBuilder sb, Object obj) throws IOException {
        if (obj instanceof RevCommit) {
            RevCommit c = (RevCommit)obj;
            RepositoryAccess.appendObjectSummary(sb, "commit", c.getAuthorIdent(), c.getShortMessage());
            TreeEntry[] treeEntryArray = this.repository.mapTree((ObjectId)c.getTree()).members();
            int n = treeEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeEntry te = treeEntryArray[n2];
                sb.append("  ");
                sb.append(te.getFullName());
                sb.append("\n");
                ++n2;
            }
        } else if (obj instanceof RevTag) {
            RevTag t = (RevTag)obj;
            RepositoryAccess.appendObjectSummary(sb, "tag", t.getTaggerIdent(), t.getShortMessage());
        } else if (obj instanceof Tree) {
            sb.append("tree");
            TreeEntry[] treeEntryArray = ((Tree)obj).members();
            int n = treeEntryArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeEntry te = treeEntryArray[n3];
                sb.append("  ");
                sb.append(te.getFullName());
                sb.append("\n");
                ++n3;
            }
        } else if (obj instanceof Blob) {
            sb.append("blob");
        } else {
            sb.append("locally unknown object");
        }
    }

    void inspectRef(Ref ref) throws IOException {
        StringBuilder sb = new StringBuilder();
        this.inspectRef(sb, ref);
        System.out.println(sb);
        System.out.println();
    }

    void inspectRef(StringBuilder sb, Ref ref) throws IOException {
        sb.append(ref.getName());
        sb.append('\n');
        sb.append(ref.getObjectId().abbreviate(8).name());
        sb.append(" - ");
        this.inspectObj(sb, ref.getObjectId());
    }

    boolean isAutoFetch() {
        return this.autoFetch;
    }

    private void fetch(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException, IOException {
        if (this.repoURI == null) {
            return;
        }
        monitor.setTaskName("Initializing local repository");
        Transport tn = null;
        try {
            try {
                String gitBranch = this.getGitBranch(versionMatch);
                RefUpdate head = this.repository.updateRef("HEAD");
                head.disableRefLog();
                head.link(gitBranch);
                StoredConfig localConfig = this.repository.getConfig();
                RemoteConfig remoteConfig = new RemoteConfig((Config)localConfig, this.remoteName);
                remoteConfig.addURI(this.repoURI);
                String dst = "refs/remotes/" + remoteConfig.getName();
                RefSpec wcrs = new RefSpec();
                wcrs = wcrs.setForceUpdate(true);
                wcrs = wcrs.setSourceDestination("refs/heads/*", String.valueOf(dst) + "/*");
                remoteConfig.addFetchRefSpec(wcrs);
                localConfig.setBoolean("core", null, "bare", false);
                remoteConfig.update((Config)localConfig);
                String branchName = gitBranch.substring("refs/heads/".length());
                localConfig.setString("branch", branchName, "remote", this.remoteName);
                localConfig.setString("branch", branchName, "merge", gitBranch);
                localConfig.save();
                tn = Transport.open((Repository)this.repository, (RemoteConfig)remoteConfig);
                FetchResult result = tn.fetch((ProgressMonitor)new EclipseGitProgressTransformer(monitor), null);
                Ref advHead = result.getAdvertisedRef(gitBranch);
                if (advHead == null || advHead.getObjectId() == null) {
                    throw BuckminsterException.fromMessage((String)"Unable to find branch %s in remote repository %s", (Object[])new Object[]{gitBranch, this.repoURI});
                }
                if (!"HEAD".equals(advHead.getName())) {
                    RefUpdate u = this.repository.updateRef("HEAD");
                    u.disableRefLog();
                    u.link(advHead.getName());
                }
                RevCommit c = this.parseCommit(advHead);
                RefUpdate u = this.repository.updateRef("HEAD");
                u.setNewObjectId((AnyObjectId)c.getId());
                u.forceUpdate();
            }
            catch (URISyntaxException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        finally {
            if (tn != null) {
                tn.close();
            }
            monitor.done();
        }
    }

    private RevCommit parseCommit(Ref branch) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        RevCommit commit;
        RevWalk rw = new RevWalk(this.repository);
        try {
            commit = rw.parseCommit((AnyObjectId)branch.getObjectId());
        }
        finally {
            rw.release();
        }
        return commit;
    }

    private String getBranchName(VersionMatch versionMatch) {
        VersionSelector vs;
        if (versionMatch != null && (vs = versionMatch.getBranchOrTag()) != null && vs.getType() == 0 && !vs.isDefault()) {
            return vs.getName();
        }
        return null;
    }

    private String getGitBranch(VersionMatch versionMatch) {
        String branchName = this.getBranchName(versionMatch);
        if (branchName == null) {
            return "refs/heads/master";
        }
        return "refs/heads/" + branchName;
    }

    private String getGitRemoteBranch(VersionMatch versionMatch) {
        String branchName = this.getBranchName(versionMatch);
        String remoteBase = "refs/remotes/" + this.remoteName + '/';
        if (branchName == null) {
            return String.valueOf(remoteBase) + "master";
        }
        return String.valueOf(remoteBase) + branchName;
    }

    private String getGitTag(VersionMatch versionMatch) {
        if (versionMatch == null) {
            return null;
        }
        VersionSelector vs = versionMatch.getBranchOrTag();
        if (vs == null || vs.getType() != 1) {
            return null;
        }
        return "refs/tags/" + vs.getName();
    }

    RevWalk getRevWalk() {
        return this.revWalk;
    }
}

