/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.git.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractSCCSVersionFinder;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.git.internal.RepositoryAccess;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionFinder
extends AbstractSCCSVersionFinder {
    private RepositoryAccess repoAccess;

    public VersionFinder(Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        Map props = provider.getProperties(query.getProperties());
        this.repoAccess = new RepositoryAccess(this.getProvider().getURI(props), props);
    }

    public synchronized void close() {
        if (this.repoAccess != null) {
            this.repoAccess.close();
            this.repoAccess = null;
        }
    }

    protected boolean checkComponentExistence(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        return this.repoAccess.getComponentTree(versionMatch, monitor) != null;
    }

    protected List<AbstractSCCSVersionFinder.RevisionEntry> getBranchesOrTags(boolean branches, IProgressMonitor monitor) throws CoreException {
        try {
            ArrayList<AbstractSCCSVersionFinder.RevisionEntry> branchesOrTags = new ArrayList<AbstractSCCSVersionFinder.RevisionEntry>();
            Repository repo = this.repoAccess.getRepository(monitor);
            String component = this.repoAccess.getComponent();
            System.out.println(repo.getBranch());
            for (Ref ref : repo.getAllRefs().values()) {
                String name = ref.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash < 0) continue;
                RevObject obj = this.repoAccess.getRevWalk().parseAny((AnyObjectId)ref.getObjectId());
                if (branches) {
                    String branch;
                    if (!(obj instanceof RevCommit) || "master".equals(branch = name.substring(lastSlash + 1))) continue;
                    RevCommit c = (RevCommit)obj;
                    if (component != null && TreeWalk.forPath((Repository)repo, (String)component, (RevTree)c.getTree()) == null) continue;
                    branchesOrTags.add(new AbstractSCCSVersionFinder.RevisionEntry(branch, c.getAuthorIdent().getWhen(), 0L));
                    continue;
                }
                if (!(obj instanceof RevTag)) continue;
                RevTag tag = (RevTag)obj;
                if (component != null) {
                    while ((obj = ((RevTag)obj).getObject()) instanceof RevTag) {
                    }
                    if (!(obj instanceof RevCommit) || TreeWalk.forPath((Repository)repo, (String)component, (RevTree)((RevCommit)obj).getTree()) == null) continue;
                }
                branchesOrTags.add(new AbstractSCCSVersionFinder.RevisionEntry(tag.getTagName(), tag.getTaggerIdent().getWhen(), 0L));
            }
            return branchesOrTags;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    protected AbstractSCCSVersionFinder.RevisionEntry getTrunk(IProgressMonitor monitor) throws CoreException {
        try {
            Repository repo = this.repoAccess.getRepository(monitor);
            String component = this.repoAccess.getComponent();
            System.out.println(repo.getBranch());
            for (Ref ref : repo.getAllRefs().values()) {
                String branch;
                RevObject obj;
                String name = ref.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash < 0 || !((obj = this.repoAccess.getRevWalk().parseAny((AnyObjectId)ref.getObjectId())) instanceof RevCommit) || !"master".equals(branch = name.substring(lastSlash + 1))) continue;
                RevCommit c = (RevCommit)obj;
                if (component != null && TreeWalk.forPath((Repository)repo, (String)component, (RevTree)c.getTree()) == null) continue;
                return new AbstractSCCSVersionFinder.RevisionEntry(component, c.getAuthorIdent().getWhen(), 0L);
            }
            return null;
        }
        catch (Exception e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    String getGitBranch(String branchName) {
        if (branchName == null) {
            return "refs/heads/master";
        }
        return "refs/heads/" + branchName;
    }
}

