/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.jarprocessor;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarFile;
import java.util.jar.Pack200;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.buckminster.core.helpers.FileUtils;
import org.eclipse.buckminster.jarprocessor.JarInfo;
import org.eclipse.buckminster.jarprocessor.RecursivePack200;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.core.runtime.CoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecursivePacker
extends RecursivePack200 {
    private final boolean useRedunantGZipping;

    public RecursivePacker(File tempDir, List<String> defaultArgs, boolean useRedundantGZipping) {
        super(tempDir, defaultArgs);
        this.useRedunantGZipping = useRedundantGZipping;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean pack(File jarFile, File destFolder, boolean retainUnpacked) throws CoreException {
        Closeable closeable;
        BufferedOutputStream output;
        block19: {
            boolean sharedFolder;
            Logger log = Buckminster.getLogger();
            String fileName = jarFile.getAbsolutePath();
            Object var6_6 = null;
            output = null;
            if (destFolder == null) {
                sharedFolder = true;
                destFolder = jarFile.getParentFile();
            } else {
                sharedFolder = destFolder.equals(jarFile.getParentFile());
            }
            try {
                JarInfo jarInfo;
                block23: {
                    Closeable closeable2;
                    block21: {
                        block22: {
                            block20: {
                                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(jarFile));
                                jarInfo = JarInfo.getJarInfo(null, fileName, zipInputStream);
                                IOUtils.close((Closeable)zipInputStream);
                                closeable2 = null;
                                if (jarInfo.hasClasses() || jarInfo.isNested() && !jarInfo.isExcludeChildrenPack()) break block20;
                                log.debug("Packer: Skipping %s since it contains no classes and no nested jars to pack", new Object[]{fileName});
                                if (!sharedFolder) {
                                    FileUtils.copyFile((File)jarFile, (File)destFolder, (String)jarFile.getName(), null);
                                }
                                break block21;
                            }
                            if (!jarInfo.isExcludePack()) break block22;
                            log.debug("Packer: Skipping %s since is excluded", new Object[]{fileName});
                            if (!sharedFolder) {
                                FileUtils.copyFile((File)jarFile, (File)destFolder, (String)jarFile.getName(), null);
                            }
                            break block21;
                        }
                        if (!jarInfo.isSigned() || jarInfo.isConditioned()) break block23;
                        log.debug("Packer: Skipping %s since is signed but not conditioned", new Object[]{fileName});
                        if (!sharedFolder) {
                            FileUtils.copyFile((File)jarFile, (File)destFolder, (String)jarFile.getName(), null);
                        }
                    }
                    IOUtils.close(closeable2);
                    IOUtils.close(output);
                    return false;
                }
                File packedFile = new File(destFolder, String.valueOf(jarFile.getName()) + ".pack.gz");
                FileInputStream fileInputStream = new FileInputStream(jarFile);
                output = new BufferedOutputStream(new FileOutputStream(packedFile));
                output = new BufferedOutputStream(new GZIPOutputStream(output));
                if (jarInfo.isNested()) {
                    this.nestedPack(fileInputStream, jarInfo, output);
                } else {
                    this.pack(jarInfo, fileInputStream, output);
                }
                IOUtils.close((Closeable)fileInputStream);
                closeable = null;
                if (sharedFolder) {
                    if (!retainUnpacked) {
                        jarFile.delete();
                    }
                    break block19;
                }
                if (!retainUnpacked) break block19;
                FileUtils.copyFile((File)jarFile, (File)destFolder, (String)jarFile.getName(), null);
            }
            catch (IOException e) {
                try {
                    throw BuckminsterException.fromMessage((Throwable)e, (String)"Unable to pack %s", (Object[])new Object[]{fileName});
                }
                catch (Throwable throwable) {
                    void var6_11;
                    IOUtils.close((Closeable)var6_11);
                    IOUtils.close(output);
                    throw throwable;
                }
            }
        }
        IOUtils.close(closeable);
        IOUtils.close((Closeable)output);
        return true;
    }

    protected void nestedPack(InputStream input, JarInfo jarInfo, OutputStream packedOut) throws IOException, CoreException {
        File packInputFile = null;
        try {
            this.tempDir.mkdirs();
            packInputFile = File.createTempFile("conditioned_", ".jar", this.tempDir);
            BufferedOutputStream tempOut = null;
            try {
                tempOut = new BufferedOutputStream(new FileOutputStream(packInputFile));
                this.processNestedJars(new ZipInputStream(input), jarInfo, tempOut);
            }
            catch (Throwable throwable) {
                IOUtils.close(tempOut);
                throw throwable;
            }
            IOUtils.close((Closeable)tempOut);
            Pack200.Packer packer = this.getPacker(jarInfo);
            packer.pack(new JarFile(packInputFile), packedOut);
        }
        finally {
            if (packInputFile != null) {
                packInputFile.delete();
            }
        }
    }

    private void processNestedJars(ZipInputStream jarIn, JarInfo jarInfo, OutputStream output) throws IOException, CoreException {
        ZipEntry entry;
        Logger log = Buckminster.getLogger();
        ZipOutputStream jarOut = new ZipOutputStream(output);
        boolean packChildren = !jarInfo.isExcludeChildrenPack();
        while ((entry = jarIn.getNextEntry()) != null) {
            JarInfo nested;
            String name = entry.getName();
            if (name.endsWith(".jar") && (nested = jarInfo.getNestedInfo(name)) != null) {
                if (!packChildren) {
                    log.debug("Packer: Skipping recursive pack of %s since parent has children pack disabled", new Object[]{name});
                } else if (nested.isSigned() && !nested.isConditioned()) {
                    log.debug("Packer: Skipping recursive pack of %s since it is signed but not conditioned", new Object[]{name});
                } else if (jarInfo.hasClasses() && jarInfo.isSigned()) {
                    log.debug("Packer: Skipping recursive pack of %s since parent is signed and has classes", new Object[]{name});
                } else {
                    if (this.useRedunantGZipping) {
                        jarOut.putNextEntry(RecursivePacker.createEntry(entry, String.valueOf(name) + ".pack.gz"));
                        GZIPOutputStream gzipOut = new GZIPOutputStream(jarOut);
                        log.debug("Packer: Recursive gzipped pack of %s", new Object[]{name});
                        this.nestedPack(jarIn, nested, gzipOut);
                        gzipOut.finish();
                        continue;
                    }
                    log.debug("Packer: Recursive pack of %s", new Object[]{name});
                    jarOut.putNextEntry(RecursivePacker.createEntry(entry, String.valueOf(name) + ".pack"));
                    this.nestedPack(jarIn, nested, jarOut);
                    continue;
                }
            }
            jarOut.putNextEntry(RecursivePacker.createEntry(entry));
            if (entry.isDirectory()) continue;
            IOUtils.copy((InputStream)jarIn, (OutputStream)jarOut, null);
        }
        jarOut.finish();
    }
}

