/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.junit.internal;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.junit.internal.Messages;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.jdt.junit.TestRunListener;
import org.eclipse.jdt.junit.model.ITestCaseElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.osgi.util.NLS;

public class TestListener
extends TestRunListener {
    private static final Logger logger = CorePlugin.getLogger();
    private final boolean quiet;
    private int successCount;
    private int failCount;
    private int errorCount;
    private int ignoreCount;
    private int overallCount;
    private ITestRunSession session;

    public TestListener(boolean quiet) {
        this.quiet = quiet;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFailureCount() {
        return this.failCount;
    }

    public int getIgnoreCount() {
        return this.ignoreCount;
    }

    public int getOverallCount() {
        return this.overallCount;
    }

    public ITestRunSession getTestRunSession() {
        return this.session;
    }

    public void sessionFinished(ITestRunSession testSession) {
        this.session = testSession;
        if (!this.quiet) {
            logger.info(Messages.TestListener_Tests_finished, new Object[0]);
            logger.info(MessageFormat.format((String)Messages.TestListener_Elapsed_time, (Object[])new Object[]{this.session.getElapsedTimeInSeconds()}), new Object[0]);
            logger.info(NLS.bind((String)Messages.TestListener_Total_number_of_tests, (Object)this.overallCount), new Object[0]);
            logger.info(NLS.bind((String)Messages.TestListener_Successful_tests, (Object)this.successCount), new Object[0]);
            logger.info(NLS.bind((String)Messages.TestListener_Failed_tests, (Object)this.failCount), new Object[0]);
            logger.info(NLS.bind((String)Messages.TestListener_Errors, (Object)this.errorCount), new Object[0]);
            logger.info(NLS.bind((String)Messages.TestListener_Ignored_tests, (Object)this.ignoreCount), new Object[0]);
            logger.info(NLS.bind((String)Messages.TestListener_Overall_status, (Object)this.session.getTestResult(true)), new Object[0]);
            this.logFailureTrace(this.session.getFailureTrace());
        }
    }

    public void sessionStarted(ITestRunSession testSession) {
        if (!this.quiet) {
            logger.info(NLS.bind((String)Messages.TestListener_Starting_test_session, (Object)testSession.getTestRunName()), new Object[0]);
        }
    }

    public void testCaseFinished(ITestCaseElement testCaseElement) {
        ++this.overallCount;
        ITestElement.Result result = testCaseElement.getTestResult(false);
        if (result == ITestElement.Result.ERROR) {
            ++this.errorCount;
        }
        if (result == ITestElement.Result.FAILURE) {
            ++this.failCount;
        }
        if (result == ITestElement.Result.IGNORED) {
            ++this.ignoreCount;
        }
        if (result == ITestElement.Result.OK) {
            ++this.successCount;
        }
        if (!this.quiet) {
            logger.info("  ..." + testCaseElement.getTestResult(false) + MessageFormat.format((String)" [{0,number,###.###}s]", (Object[])new Object[]{testCaseElement.getElapsedTimeInSeconds()}), new Object[0]);
            this.logFailureTrace(testCaseElement.getFailureTrace());
        }
    }

    public void testCaseStarted(ITestCaseElement testCaseElement) {
        if (!this.quiet) {
            logger.info(String.valueOf(Messages.TestListener_Running_test) + testCaseElement.getTestClassName() + "." + testCaseElement.getTestMethodName() + "...", new Object[0]);
        }
    }

    private void logFailureTrace(ITestElement.FailureTrace failure) {
        if (failure == null) {
            return;
        }
        if (failure.getActual() != null) {
            logger.warning(NLS.bind((String)Messages.TestListener_Actual, (Object)failure.getActual()), new Object[0]);
        }
        if (failure.getExpected() != null) {
            logger.warning(NLS.bind((String)Messages.TestListener_Expected, (Object)failure.getExpected()), new Object[0]);
        }
        if (failure.getTrace() != null) {
            logger.warning(failure.getTrace(), new Object[0]);
        }
    }
}

