/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.maven.MavenPlugin;
import org.eclipse.buckminster.maven.Messages;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.osgi.util.NLS;

public class LocalCache {
    public static final int MAX_FAILURES = 2;
    private static final String SHA1_SUFFIX = ".sha1";
    private static final int SHA1_LEN = 20;
    private static final String MD5_SUFFIX = ".md5";
    private static final int MD5_LEN = 16;
    private final IPath localCacheRoot;

    private static int hexDigit(byte c) {
        int v = 0;
        if (c >= 48 && c <= 57) {
            v = c - 48;
        } else if (c >= 97 && c <= 102) {
            v = c - 97 + 10;
        } else if (c >= 65 && c <= 70) {
            v = c - 65 + 10;
        }
        return v;
    }

    private static byte[] readHex(String name, InputStream stream, int size) throws CoreException, IOException {
        int bytesRead;
        byte[] buffer = new byte[size * 2];
        int remain = buffer.length;
        int totRead = 0;
        while (remain > 0 && (bytesRead = stream.read(buffer, totRead, remain)) > 0) {
            totRead += bytesRead;
            remain -= bytesRead;
        }
        if (totRead != buffer.length) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.unable_to_read_the_0_character_hexadecimal_form_of_the_digest_for_1, (Object)size, (Object)name), (Object[])new Object[0]);
        }
        byte[] result = new byte[size];
        int idx = 0;
        while (idx < size) {
            int cidx = idx << 1;
            int b = LocalCache.hexDigit(buffer[cidx]) << 4 | LocalCache.hexDigit(buffer[cidx + 1]);
            result[idx] = (byte)(b & 0xFF);
            ++idx;
        }
        return result;
    }

    /*
     * Loose catch block
     */
    private static byte[] readRemoteDigest(StringBuilder urlBld, IConnectContext cctx, String suffix, int nBytes) throws CoreException {
        byte[] byArray;
        int len = urlBld.length();
        urlBld.append(suffix);
        String urlStr = urlBld.toString();
        urlBld.setLength(len);
        InputStream input = null;
        try {
            input = DownloadManager.read((URL)new URL(urlStr), (IConnectContext)cctx);
            byArray = LocalCache.readHex(urlStr, input, nBytes);
        }
        catch (IOException e) {
            IOUtils.close(input);
            return null;
            catch (Throwable throwable) {
                IOUtils.close(input);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)input);
        return byArray;
    }

    private static void writeHex(byte[] bytes, OutputStream stream) throws IOException {
        int idx = 0;
        while (idx < bytes.length) {
            byte b = bytes[idx];
            int x = (b & 0xF0) >> 4;
            stream.write(x >= 10 ? x + 87 : x + 48);
            x = b & 0xF;
            stream.write(x >= 10 ? x + 87 : x + 48);
            ++idx;
        }
    }

    public LocalCache(IPath localCacheRoot) {
        this.localCacheRoot = localCacheRoot;
    }

    public IPath getRootPath() {
        return this.localCacheRoot;
    }

    public InputStream openFile(URL repository, IConnectContext cctx, IPath path, IProgressMonitor monitor) throws CoreException, IOException {
        IProgressMonitor subMonitor = monitor;
        int failureCounter = 0;
        while (true) {
            try {
                File localFile = this.obtainLocalFile(repository, cctx, path, failureCounter, subMonitor);
                monitor.subTask(Messages.verifying_digest_with_dots);
                return new FileInputStream(localFile);
            }
            catch (CoreException e) {
                throw e;
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                monitor.subTask(String.valueOf(Messages.digest_verification_failed) + (failureCounter < 2 ? Messages.trying_again_with_dots : ""));
                if (++failureCounter != 2) continue;
                throw e;
            }
            break;
        }
    }

    /*
     * Loose catch block
     */
    private synchronized File obtainLocalFile(URL repository, IConnectContext cctx, IPath path, int failureCounter, IProgressMonitor monitor) throws IOException, CoreException {
        boolean matchingDigest;
        MessageDigest md;
        File localDigestFile;
        byte[] remoteDigest;
        byte[] remoteSha1;
        IPath containingFolder;
        URL remoteURL;
        File file;
        block27: {
            int digestSize;
            IPath fullPath = this.localCacheRoot.append(path);
            file = fullPath.toFile();
            StringBuilder urlBld = new StringBuilder(repository.toExternalForm());
            if (urlBld.charAt(urlBld.length() - 1) != '/') {
                urlBld.append('/');
            }
            urlBld.append(path.toPortableString());
            remoteURL = new URL(urlBld.toString());
            containingFolder = fullPath.removeLastSegments(1);
            IPath md5Path = containingFolder.append(String.valueOf(path.lastSegment()) + MD5_SUFFIX);
            File md5File = md5Path.toFile();
            remoteSha1 = null;
            byte[] remoteMd5 = null;
            if ((failureCounter & 1) == 0) {
                remoteMd5 = LocalCache.readRemoteDigest(urlBld, cctx, MD5_SUFFIX, 16);
                if (remoteMd5 == null) {
                    remoteSha1 = LocalCache.readRemoteDigest(urlBld, cctx, SHA1_SUFFIX, 20);
                }
            } else {
                remoteSha1 = LocalCache.readRemoteDigest(urlBld, cctx, SHA1_SUFFIX, 20);
                if (remoteSha1 == null) {
                    remoteMd5 = LocalCache.readRemoteDigest(urlBld, cctx, MD5_SUFFIX, 16);
                }
            }
            if (remoteMd5 == null) {
                remoteDigest = remoteSha1;
                localDigestFile = containingFolder.append(String.valueOf(path.lastSegment()) + SHA1_SUFFIX).toFile();
                digestSize = 20;
            } else {
                remoteDigest = remoteMd5;
                localDigestFile = md5File;
                digestSize = 16;
            }
            if (remoteDigest != null) {
                FileInputStream input;
                block26: {
                    File file2;
                    input = null;
                    try {
                        input = new FileInputStream(localDigestFile);
                        byte[] localDigest2222222 = LocalCache.readHex(localDigestFile.toString(), input, digestSize);
                        if (!Arrays.equals(remoteDigest, localDigest2222222) || !file.exists() || file.length() <= 0L) break block26;
                        file2 = file;
                    }
                    catch (FileNotFoundException localDigest2222222) {
                        IOUtils.close((Closeable)input);
                        break block27;
                    }
                    catch (CoreException localDigest2222222) {
                        IOUtils.close((Closeable)input);
                        break block27;
                        {
                            catch (Throwable throwable) {
                                IOUtils.close(input);
                                throw throwable;
                            }
                        }
                    }
                    IOUtils.close((Closeable)input);
                    return file2;
                }
                IOUtils.close((Closeable)input);
            }
        }
        try {
            md = MessageDigest.getInstance(remoteSha1 == null ? "MD5" : "SHA1");
            md.reset();
        }
        catch (NoSuchAlgorithmException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        OutputStream output = null;
        try {
            File outputDir = containingFolder.toFile();
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IOException(NLS.bind((String)Messages.unable_to_create_directory_0, (Object)outputDir));
            }
            output = new DigestOutputStream(new FileOutputStream(file), md);
            DownloadManager.readInto((URL)remoteURL, (IConnectContext)cctx, (OutputStream)output, (IProgressMonitor)monitor);
        }
        catch (Throwable throwable) {
            IOUtils.close(output);
            throw throwable;
        }
        IOUtils.close((Closeable)output);
        byte[] localDigest = md.digest();
        if (remoteDigest == null) {
            MavenPlugin.getLogger().warning(NLS.bind((String)Messages.unable_to_find_digest_for_0, (Object)remoteURL), new Object[0]);
            matchingDigest = false;
        } else {
            matchingDigest = Arrays.equals(remoteDigest, localDigest);
        }
        if (matchingDigest || remoteDigest == null || failureCounter == 1) {
            if (remoteDigest != null && !matchingDigest && failureCounter == 1) {
                MavenPlugin.getLogger().warning(NLS.bind((String)Messages.digest_for_0_still_doesnt_match_after_1_download_attempts_corrupt_repo, (Object)remoteURL, (Object)new Integer(2)), new Object[0]);
            }
            try {
                output = new FileOutputStream(localDigestFile);
                LocalCache.writeHex(localDigest, output);
            }
            finally {
                IOUtils.close((Closeable)output);
            }
            return file;
        }
        localDigestFile.delete();
        file.delete();
        throw new IOException(NLS.bind((String)Messages.digest_mismatch_after_download_for_0, (Object)remoteURL));
    }
}

