/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.buckminster.core.parser.ExtensionAwareHandler;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.rmap.parser.BidirectionalTransformerHandler;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.MapEntryHandler;
import org.eclipse.buckminster.sax.AbstractHandler;
import org.eclipse.buckminster.sax.ChildHandler;
import org.eclipse.buckminster.sax.ChildPoppedListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappingsHandler
extends ExtensionAwareHandler
implements ChildPoppedListener {
    private BidirectionalTransformerHandler transformerHandler;
    private MapEntryHandler mapEntryHandler;
    private TreeMap<String, MapEntry> entries;
    private List<BidirectionalTransformer> rules;

    public MappingsHandler(AbstractHandler parent) {
        super(parent);
    }

    public void childPopped(ChildHandler child) {
        if (child instanceof MapEntryHandler) {
            if (this.entries == null) {
                this.entries = new TreeMap();
            }
            MapEntry entry = (MapEntry)((MapEntryHandler)child).createEntry();
            this.entries.put(entry.getName(), entry);
        } else if (child instanceof BidirectionalTransformerHandler) {
            if (this.rules == null) {
                this.rules = new ArrayList<BidirectionalTransformer>();
            }
            this.rules.add(((BidirectionalTransformerHandler)child).getTransformer());
        }
    }

    public ChildHandler createHandler(String uri, String localName, Attributes attrs) throws SAXException {
        MapEntryHandler ch;
        if (localName.equals("entry")) {
            if (this.mapEntryHandler == null) {
                this.mapEntryHandler = new MapEntryHandler((AbstractHandler)this);
            }
            ch = this.mapEntryHandler;
        } else if (localName.equals("rule")) {
            if (this.transformerHandler == null) {
                this.transformerHandler = new BidirectionalTransformerHandler((AbstractHandler)this);
            }
            ch = this.transformerHandler;
        } else {
            ch = super.createHandler(uri, localName, attrs);
        }
        return ch;
    }

    public Map<String, MapEntry> getEntriesAndClear() {
        TreeMap<String, MapEntry> entryMap = this.entries;
        this.entries = null;
        return entryMap == null ? Collections.emptyMap() : entryMap;
    }

    public List<BidirectionalTransformer> getRuleAndClear() {
        List<BidirectionalTransformer> ruleList = this.rules;
        this.rules = null;
        return ruleList == null ? Collections.emptyList() : ruleList;
    }
}

