/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.maven.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.common.model.Format;
import org.eclipse.buckminster.core.rmap.model.BidirectionalTransformer;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.rmap.model.SearchPath;
import org.eclipse.buckminster.core.rmap.model.VersionConverterDesc;
import org.eclipse.buckminster.core.version.IVersionConverter;
import org.eclipse.buckminster.maven.Messages;
import org.eclipse.buckminster.maven.internal.GroupAndArtifact;
import org.eclipse.buckminster.maven.internal.IMapEntry;
import org.eclipse.buckminster.maven.internal.MapEntry;
import org.eclipse.buckminster.maven.internal.Scope;
import org.eclipse.buckminster.maven.internal.SourceMapEntry;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.sax.ISaxableElement;
import org.eclipse.buckminster.sax.Utils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenProvider
extends Provider {
    public static final String BM_MAVEN_PROVIDER_NS = "http://www.eclipse.org/buckminster/MavenProvider-1.0";
    public static final String BM_MAVEN_PROVIDER_PREFIX = "mp";
    public static final String ELEM_MAPPINGS = "mappings";
    public static final String ELEM_RULE = "rule";
    public static final String ELEM_SCOPES = "scopes";
    public static final String ATTR_TRANSITIVE = "transitive";
    private final Map<String, MapEntry> mappings;
    private final List<BidirectionalTransformer> rules;
    private final Map<String, Scope> scopes;
    private final boolean transitive;

    public static IMapEntry getDefaultGroupAndArtifact(String name) {
        int dotIdx = name.lastIndexOf(47);
        return dotIdx > 0 ? new MapEntry(name, name.substring(0, dotIdx), name.substring(dotIdx + 1), null) : new MapEntry(name, name, name, null);
    }

    public static boolean getDefaultIsScopeExcluded() {
        return false;
    }

    public static String getDefaultName(String groupId, String artifactId) {
        if (groupId.equals(artifactId)) {
            int colonIdx = artifactId.indexOf(58);
            if (colonIdx < 0) {
                return artifactId;
            }
            groupId = artifactId.substring(0, colonIdx);
            artifactId = artifactId.substring(colonIdx + 1);
        }
        return String.valueOf(groupId) + '/' + artifactId;
    }

    public static boolean getDefaultTransitive() {
        return true;
    }

    public MavenProvider(SearchPath searchPath, String remoteReaderType, String[] componentTypes, VersionConverterDesc versionConverterDesc, Format uri, Filter resolutionFilter, Map<String, String> properties, Documentation documentation, Map<String, MapEntry> mappings, List<BidirectionalTransformer> rules) {
        this(searchPath, remoteReaderType, componentTypes, versionConverterDesc, uri, resolutionFilter, properties, documentation, mappings, rules, Collections.emptyMap(), true);
    }

    public MavenProvider(SearchPath searchPath, String remoteReaderType, String[] componentTypes, VersionConverterDesc versionConverterDesc, Format uri, Filter resolutionFilter, Map<String, String> properties, Documentation documentation, Map<String, MapEntry> mappings, List<BidirectionalTransformer> rules, Map<String, Scope> scopes, boolean transitive) {
        super(searchPath, remoteReaderType, componentTypes, versionConverterDesc, uri, null, null, resolutionFilter, properties, null, documentation);
        if (mappings == null) {
            mappings = Collections.emptyMap();
        }
        if (rules == null) {
            rules = Collections.emptyList();
        }
        if (scopes == null) {
            scopes = Collections.emptyMap();
        }
        this.mappings = mappings;
        this.rules = rules;
        this.scopes = scopes;
        this.transitive = transitive;
    }

    public void addPrefixMappings(HashMap<String, String> prefixMappings) {
        super.addPrefixMappings(prefixMappings);
        prefixMappings.put(BM_MAVEN_PROVIDER_PREFIX, BM_MAVEN_PROVIDER_NS);
    }

    public IVersionConverter getVersionConverter() throws CoreException {
        return CorePlugin.getDefault().getVersionConverter("tag");
    }

    protected void addAttributes(AttributesImpl attrs) throws SAXException {
        super.addAttributes(attrs);
        attrs.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi:type", "CDATA", "mp:MavenProvider");
    }

    protected void emitElements(ContentHandler handler, String namespace, String prefix) throws SAXException {
        super.emitElements(handler, namespace, prefix);
        if (this.mappings.size() == 0 && this.rules.size() == 0 && this.scopes.size() == 0) {
            return;
        }
        String qName = Utils.makeQualifiedName((String)BM_MAVEN_PROVIDER_PREFIX, (String)ELEM_MAPPINGS);
        handler.startElement(BM_MAVEN_PROVIDER_NS, ELEM_MAPPINGS, qName, ISaxableElement.EMPTY_ATTRIBUTES);
        for (MapEntry mapping : this.mappings.values()) {
            mapping.toSax(handler, BM_MAVEN_PROVIDER_NS, BM_MAVEN_PROVIDER_PREFIX, mapping.getDefaultTag());
        }
        for (BidirectionalTransformer rule : this.rules) {
            rule.toSax(handler, BM_MAVEN_PROVIDER_NS, BM_MAVEN_PROVIDER_PREFIX, ELEM_RULE);
        }
        handler.endElement(BM_MAVEN_PROVIDER_NS, ELEM_MAPPINGS, qName);
        String sqName = Utils.makeQualifiedName((String)BM_MAVEN_PROVIDER_PREFIX, (String)ELEM_SCOPES);
        handler.startElement(BM_MAVEN_PROVIDER_NS, ELEM_SCOPES, sqName, ISaxableElement.EMPTY_ATTRIBUTES);
        for (Scope scope : this.scopes.values()) {
            scope.toSax(handler, BM_MAVEN_PROVIDER_NS, BM_MAVEN_PROVIDER_PREFIX, scope.getDefaultTag());
        }
        handler.endElement(BM_MAVEN_PROVIDER_NS, ELEM_SCOPES, sqName);
    }

    String getComponentName(String groupId, String artifactId) throws CoreException {
        for (IMapEntry iMapEntry : this.mappings.values()) {
            if (iMapEntry.isMatchFor(groupId, artifactId)) {
                return iMapEntry.getName();
            }
            List<GroupAndArtifact> aliases = iMapEntry.getAliases();
            int idx = aliases.size();
            while (--idx >= 0) {
                GroupAndArtifact alias = aliases.get(idx);
                if (!alias.isMatchFor(groupId, artifactId)) continue;
                return iMapEntry.getName();
            }
        }
        if (this.rules.size() > 0) {
            String string = String.valueOf(groupId) + '/' + artifactId;
            for (BidirectionalTransformer rule : this.rules) {
                String transformed = rule.transformTo(string);
                if (transformed == null) continue;
                return transformed;
            }
        }
        return MavenProvider.getDefaultName(groupId, artifactId);
    }

    IMapEntry getGroupAndArtifact(String name) throws CoreException {
        if (name.endsWith(".source")) {
            return new SourceMapEntry(this.getGroupAndArtifact(name.substring(0, name.length() - 7)));
        }
        IMapEntry entry = this.mappings.get(name);
        if (entry != null) {
            return entry;
        }
        String transformed = null;
        for (BidirectionalTransformer rule : this.rules) {
            transformed = rule.transformFrom(name);
            if (transformed != null) break;
        }
        if (transformed == null) {
            return MavenProvider.getDefaultGroupAndArtifact(name);
        }
        int slashPos = transformed.indexOf(47);
        if (slashPos < 0) {
            throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.the_result_of_applying_a_match_rule_had_no_separator_slash_0, (Object)transformed), (Object[])new Object[0]);
        }
        return new MapEntry(name, transformed.substring(0, slashPos), transformed.substring(slashPos + 1), null);
    }

    boolean isScopeExcluded(String name) {
        if (name == null) {
            return MavenProvider.getDefaultIsScopeExcluded();
        }
        if (this.scopes.size() == 0) {
            return MavenProvider.getDefaultIsScopeExcluded();
        }
        Scope scope = this.scopes.get(name);
        if (scope == null) {
            return true;
        }
        return scope.isExcluded();
    }

    boolean isTransitive() {
        return this.transitive;
    }
}

