/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.Map;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.ComponentIdentifier;
import org.eclipse.buckminster.model.common.ComponentName;
import org.eclipse.buckminster.model.common.ComponentRequest;
import org.eclipse.buckminster.model.common.impl.ComponentNameImpl;
import org.eclipse.buckminster.model.common.util.ComponentRequestConflictException;
import org.eclipse.buckminster.model.common.util.VersionHelper;
import org.eclipse.buckminster.osgi.filter.Filter;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.equinox.p2.metadata.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRequestImpl
extends ComponentNameImpl
implements ComponentRequest {
    protected static final VersionRange RANGE_EDEFAULT = null;
    protected VersionRange range = RANGE_EDEFAULT;
    protected static final Filter FILTER_EDEFAULT = null;
    protected Filter filter = FILTER_EDEFAULT;

    protected ComponentRequestImpl() {
    }

    @Override
    public void appendViewName(StringBuilder result) {
        result.append(this.getId());
        String componentType = this.getType();
        if (componentType != null) {
            result.append(':');
            result.append(componentType);
        }
        if (this.filter != null) {
            result.append(this.filter);
        }
    }

    @Override
    public int compareTo(ComponentName o) {
        if (this == o) {
            return 0;
        }
        int cmp = super.compareTo(o);
        if (cmp != 0) {
            return cmp;
        }
        if (o instanceof ComponentRequest) {
            ComponentRequest cr = (ComponentRequest)o;
            if (this.getRange() == null) {
                if (cr.getRange() != null) {
                    return -1;
                }
            } else {
                if (cr.getRange() == null) {
                    return 1;
                }
                cmp = this.getRange().getMinimum().compareTo((Object)cr.getRange().getMinimum());
                if (cmp != 0) {
                    return cmp;
                }
                if (this.getRange().getIncludeMinimum()) {
                    if (!cr.getRange().getIncludeMinimum()) {
                        return -1;
                    }
                } else if (cr.getRange().getIncludeMinimum()) {
                    return 1;
                }
                if ((cmp = this.getRange().getMaximum().compareTo((Object)cr.getRange().getMaximum())) != 0) {
                    return cmp;
                }
                if (this.getRange().getIncludeMaximum()) {
                    if (!cr.getRange().getIncludeMaximum()) {
                        return 1;
                    }
                } else if (cr.getRange().getIncludeMaximum()) {
                    return -1;
                }
            }
            if (this.getFilter() == null) {
                if (cr.getFilter() != null) {
                    return -1;
                }
            } else {
                if (cr.getFilter() == null) {
                    return 1;
                }
                cmp = this.getFilter().toString().compareTo(cr.getFilter().toString());
                if (cmp != 0) {
                    return cmp;
                }
            }
        } else if (this.getRange() != null || this.getFilter() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean designates(ComponentIdentifier cid) {
        return !(!Trivial.equalsAllowNull((Object)this.getId(), (Object)cid.getId()) || this.getType() != null && !this.getType().equals(cid.getType()) || this.getRange() != null && !this.getRange().isIncluded(cid.getVersion()));
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return this.getRange();
            }
            case 3: {
                return this.getFilter();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return RANGE_EDEFAULT == null ? this.range != null : !RANGE_EDEFAULT.equals((Object)this.range);
            }
            case 3: {
                return FILTER_EDEFAULT == null ? this.filter != null : !FILTER_EDEFAULT.equals((Object)this.filter);
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentRequest cr = (ComponentRequest)o;
        return Trivial.equalsAllowNull((Object)this.getRange(), (Object)cr.getRange()) && Trivial.equalsAllowNull((Object)this.getFilter(), (Object)cr.getFilter());
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setRange((VersionRange)newValue);
                return;
            }
            case 3: {
                this.setFilter((Filter)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.setRange(RANGE_EDEFAULT);
                return;
            }
            case 3: {
                this.setFilter(FILTER_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> p = super.getProperties();
        if (this.getRange() != null) {
            p.put("buckminster.version.designator", this.getRange().toString());
        }
        return p;
    }

    @Override
    public VersionRange getRange() {
        return this.range;
    }

    @Override
    public String getViewName() {
        StringBuilder bld = new StringBuilder();
        this.appendViewName(bld);
        return bld.toString();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.getRange() == null ? 0 : this.getRange().hashCode());
        return 31 * hash + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
    }

    @Override
    public boolean isEnabled(Map<String, ? extends Object> properties) {
        return this.filter == null || this.filter.matchCase(properties);
    }

    @Override
    public boolean isOptional() {
        return this.filter != null && this.filter.toString().contains("(!(eclipse.p2.optional=false))");
    }

    @Override
    public ComponentRequest merge(ComponentRequest request) {
        if (!Trivial.equalsAllowNull((Object)this.getId(), (Object)request.getId())) {
            throw new ComponentRequestConflictException(this, request);
        }
        int cmp = 0;
        VersionRange thisVD = this.getRange();
        VersionRange thatVD = request.getRange();
        VersionRange mergedVD = null;
        if (thisVD == null) {
            if (thatVD != null) {
                cmp = 1;
                mergedVD = thatVD;
            }
        } else if (thatVD == null) {
            cmp = -1;
            mergedVD = thisVD;
        } else {
            mergedVD = thisVD.intersect(thatVD);
            if (mergedVD == null) {
                throw new ComponentRequestConflictException(this, request);
            }
            if (mergedVD.equals((Object)thisVD)) {
                if (!mergedVD.equals((Object)thatVD)) {
                    cmp = -1;
                }
            } else {
                cmp = mergedVD.equals((Object)thatVD) ? 1 : 2;
            }
        }
        String thisCType = this.getType();
        String thatCType = request.getType();
        String mergedCType = null;
        if (thisCType == null) {
            if (thatCType != null) {
                if (cmp == 0) {
                    cmp = 1;
                }
                mergedCType = thatCType;
            }
        } else {
            if (thatCType != null) {
                if (!thisCType.equals(thatCType)) {
                    throw new ComponentRequestConflictException(this, request);
                }
            } else if (cmp == 0) {
                cmp = -1;
            }
            mergedCType = thisCType;
        }
        Filter thisFilter = this.getFilter();
        Filter thatFilter = request.getFilter();
        boolean thisOptional = this.isOptional();
        boolean thatOptional = request.isOptional();
        Filter mergedFilter = null;
        if (!Trivial.equalsAllowNull((Object)thisFilter, (Object)thatFilter)) {
            if (thisOptional != thatOptional) {
                throw new ComponentRequestConflictException(this, request);
            }
            if (thisFilter != null && thatFilter != null) {
                mergedFilter = thisFilter.addFilterWithOr(thatFilter);
            }
        } else {
            mergedFilter = thisFilter;
        }
        if (thisOptional) {
            if (!thatOptional) {
                if (cmp == -1 || cmp == 2) {
                    throw new ComponentRequestConflictException(this, request);
                }
                return request;
            }
        } else if (thatOptional) {
            if (cmp > 0) {
                throw new ComponentRequestConflictException(this, request);
            }
            return this;
        }
        if (Trivial.equalsAllowNull((Object)mergedVD, (Object)thisVD) && Trivial.equalsAllowNull((Object)mergedCType, (Object)thisCType) && Trivial.equalsAllowNull((Object)thisFilter, (Object)mergedFilter)) {
            return this;
        }
        if (Trivial.equalsAllowNull((Object)mergedVD, (Object)thatVD) && Trivial.equalsAllowNull((Object)mergedCType, (Object)thatCType) && Trivial.equalsAllowNull((Object)thatFilter, (Object)mergedFilter)) {
            return request;
        }
        ComponentRequestImpl result = new ComponentRequestImpl();
        result.setId(this.id);
        result.setType(mergedCType);
        result.setRange(mergedVD);
        result.setFilter(mergedFilter);
        return result;
    }

    @Override
    public void setFilter(Filter newFilter) {
        Filter oldFilter = this.filter;
        this.filter = newFilter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldFilter, (Object)this.filter));
        }
    }

    @Override
    public void setRange(VersionRange newRange) {
        VersionRange oldRange = this.range;
        this.range = newRange;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldRange, (Object)this.range));
        }
    }

    @Override
    public ComponentName toPureComponentName() {
        ComponentNameImpl cn = new ComponentNameImpl();
        cn.setId(this.getId());
        cn.setType(this.getType());
        return cn;
    }

    @Override
    public void toString(StringBuilder bld) {
        super.toString(bld);
        bld.append('/');
        if (this.getRange() != null) {
            bld.append(VersionHelper.getHumanReadable(this.getRange()));
        }
        if (this.getFilter() != null) {
            bld.append(this.getFilter());
        }
    }

    public String toStringGen() {
        return null;
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.COMPONENT_REQUEST;
    }
}

