/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.model.common.CommonPackage;
import org.eclipse.buckminster.model.common.Value;
import org.eclipse.buckminster.model.common.ValueFilter;
import org.eclipse.buckminster.model.common.impl.ValueImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueFilterImpl
extends ValueImpl
implements ValueFilter {
    protected FeatureMap multiValueGroup;

    protected ValueFilterImpl() {
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                if (coreType) {
                    return this.getMultiValueGroup();
                }
                return ((FeatureMap.Internal)this.getMultiValueGroup()).getWrapper();
            }
            case 2: {
                return this.getValues();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getMultiValueGroup()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getValues()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.multiValueGroup != null && !this.multiValueGroup.isEmpty();
            }
            case 2: {
                return !this.getValues().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                ((FeatureMap.Internal)this.getMultiValueGroup()).set(newValue);
                return;
            }
            case 2: {
                this.getValues().clear();
                this.getValues().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getMultiValueGroup().clear();
                return;
            }
            case 2: {
                this.getValues().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public FeatureMap getMultiValueGroup() {
        if (this.multiValueGroup == null) {
            this.multiValueGroup = new BasicFeatureMap((InternalEObject)this, 1);
        }
        return this.multiValueGroup;
    }

    @Override
    public EList<Value> getValues() {
        return this.getMultiValueGroup().list((EStructuralFeature)CommonPackage.Literals.VALUE_FILTER__VALUES);
    }

    @Override
    public List<String> getValues(Map<String, String> properties) {
        return this.checkedGetValues(properties, 0);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (multiValueGroup: ");
        result.append(this.multiValueGroup);
        result.append(')');
        return result.toString();
    }

    @Override
    protected EClass eStaticClass() {
        return CommonPackage.Literals.VALUE_FILTER;
    }

    String checkedGetSourceValue(Map<String, String> properties, int recursionGuard) {
        EList<Value> values = this.getValues();
        int top = values.size();
        if (top == 0) {
            return "";
        }
        if (top == 1) {
            return ((ValueImpl)values.get(0)).checkedGetValue(properties, recursionGuard);
        }
        StringBuilder bld = new StringBuilder();
        int idx = 0;
        while (idx < top) {
            ValueImpl valueHolder = (ValueImpl)values.get(idx);
            if (valueHolder.isMultiValued()) {
                List<String> vs = valueHolder.checkedGetValues(properties, recursionGuard);
                int vidx = 0;
                while (vidx < vs.size()) {
                    bld.append((Object)vs.get(vidx));
                    ++vidx;
                }
            } else {
                bld.append(valueHolder.checkedGetValue(properties, recursionGuard));
            }
            ++idx;
        }
        return bld.toString();
    }

    List<String> checkedGetSourceValues(Map<String, String> properties, int recursionGuard) {
        EList<Value> values = this.getValues();
        int top = values.size();
        if (top == 0) {
            return Collections.emptyList();
        }
        if (top == 1) {
            return ((ValueImpl)values.get(0)).checkedGetValues(properties, recursionGuard);
        }
        ArrayList<String> parameters = new ArrayList<String>(top);
        int idx = 0;
        while (idx < top) {
            ValueImpl valueHolder = (ValueImpl)values.get(idx);
            if (valueHolder.isMultiValued()) {
                List<String> vs = valueHolder.checkedGetValues(properties, recursionGuard);
                int vidx = 0;
                while (vidx < vs.size()) {
                    parameters.add(vs.get(vidx));
                    ++vidx;
                }
            } else {
                parameters.add(valueHolder.checkedGetValue(properties, recursionGuard));
            }
            ++idx;
        }
        return parameters;
    }
}

