/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.model.common.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapUnion<K, V>
extends AbstractMap<K, V> {
    private final HashMap<K, K> antiMap;
    private final Map<K, V> immutable;
    private final Map<K, V> overlay;

    public MapUnion(Map<? extends K, ? extends V> mutable, Map<? extends K, ? extends V> immutable) {
        this.overlay = mutable;
        this.immutable = immutable;
        this.antiMap = new HashMap();
    }

    private MapUnion(Map<K, V> mutable, Map<K, V> immutable, HashMap<K, K> antiMap) {
        this.overlay = mutable;
        this.immutable = immutable;
        int shadowCount = 0;
        for (K key : this.overlay.keySet()) {
            if (!immutable.containsKey(key)) continue;
            ++shadowCount;
        }
        this.antiMap = antiMap;
    }

    @Override
    public void clear() {
        this.overlay.clear();
        this.antiMap.clear();
        for (K key : this.immutable.keySet()) {
            this.antiMap.put(key, key);
        }
    }

    @Override
    public Object clone() {
        HashMap<K, V> mt = new HashMap<K, V>();
        mt.putAll(this.overlay);
        HashMap<K, K> am = new HashMap<K, K>();
        am.putAll(this.antiMap);
        return new MapUnion(mt, this.immutable, am);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.overlay.containsKey(key) || this.immutable.containsKey(key) && !this.antiMap.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return MapUnion.this.size();
            }
        };
    }

    @Override
    public V get(Object key) {
        V value = this.overlay.get(key);
        if (value == null && !this.overlay.containsKey(key) && (value = this.immutable.get(key)) != null && this.antiMap.containsKey(key)) {
            value = null;
        }
        return value;
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return MapUnion.this.size();
            }
        };
    }

    public Set<K> overlayKeySet() {
        return this.overlay.keySet();
    }

    @Override
    public V put(K key, V value) {
        this.antiMap.remove(key);
        return this.overlay.put(key, value);
    }

    @Override
    public V remove(Object key) {
        V value = null;
        if (this.overlay.containsKey(key)) {
            if (this.immutable.containsKey(key)) {
                this.antiMap.put(key, key);
            }
            value = this.overlay.remove(key);
        } else if (this.immutable.containsKey(key) && !this.antiMap.containsKey(key)) {
            value = this.immutable.get(key);
            this.antiMap.put(key, key);
        }
        return value;
    }

    @Override
    public int size() {
        int immutableVisibleCount = 0;
        for (K key : this.immutable.keySet()) {
            if (this.overlay.containsKey(key) || this.antiMap.containsKey(key)) continue;
            ++immutableVisibleCount;
        }
        return this.overlay.size() + immutableVisibleCount;
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return MapUnion.this.size();
            }
        };
    }

    static /* synthetic */ Map access$1(MapUnion mapUnion) {
        return mapUnion.immutable;
    }

    static /* synthetic */ HashMap access$2(MapUnion mapUnion) {
        return mapUnion.antiMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class AbstractIterator<X>
    implements Iterator<X> {
        private Iterator<K> currentIterator;
        private K currentKey;
        private boolean phase1;

        AbstractIterator() {
            this.currentIterator = MapUnion.this.overlay.keySet().iterator();
            this.currentKey = null;
            this.phase1 = true;
        }

        @Override
        public boolean hasNext() {
            this.currentKey = this.getValidKey(this.currentKey);
            return this.currentKey != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        K nextKey() {
            Object key = this.getValidKey(this.currentKey);
            if (key == null) {
                throw new NoSuchElementException();
            }
            this.currentKey = null;
            return key;
        }

        /*
         * Unable to fully structure code
         */
        private K getValidKey(K key) {
            if (this.phase1) {
                if (key != null) {
                    return key;
                }
                if (this.currentIterator.hasNext()) {
                    return this.currentIterator.next();
                }
                this.currentIterator = MapUnion.access$1(MapUnion.this).keySet().iterator();
                this.phase1 = false;
            }
            if (key == null || MapUnion.access$0(MapUnion.this).containsKey(key) || MapUnion.access$2(MapUnion.this).containsKey(key)) ** GOTO lbl13
            return key;
lbl-1000:
            // 1 sources

            {
                key = this.currentIterator.next();
                if (MapUnion.access$0(MapUnion.this).containsKey(key) || MapUnion.access$2(MapUnion.this).containsKey(key)) continue;
                return key;
lbl13:
                // 2 sources

                ** while (this.currentIterator.hasNext())
            }
lbl14:
            // 1 sources

            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EntryIterator
    extends AbstractIterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return new UnionEntry(this.nextKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KeyIterator
    extends AbstractIterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UnionEntry
    implements Map.Entry<K, V> {
        private final K key;

        public UnionEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return MapUnion.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return MapUnion.this.put(this.key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueIterator
    extends AbstractIterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return MapUnion.this.get(this.nextKey());
        }
    }
}

