/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.pde.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.ComponentIdentifier;
import org.eclipse.buckminster.model.common.Format;
import org.eclipse.buckminster.model.common.PropertyRef;
import org.eclipse.buckminster.model.common.Value;
import org.eclipse.buckminster.rmap.Locator;
import org.eclipse.buckminster.rmap.Matcher;
import org.eclipse.buckminster.rmap.Provider;
import org.eclipse.buckminster.rmap.ResourceMap;
import org.eclipse.buckminster.rmap.RmapFactory;
import org.eclipse.buckminster.rmap.RmapPackage;
import org.eclipse.buckminster.rmap.SearchPath;
import org.eclipse.buckminster.rmap.VersionConverter;
import org.eclipse.buckminster.rmap.impl.ProviderImpl;
import org.eclipse.buckminster.rmap.pde.PDEMapProvider;
import org.eclipse.buckminster.rmap.pde.PdePackage;
import org.eclipse.buckminster.rmap.pde.util.MapFile;
import org.eclipse.buckminster.rmap.pde.util.MapFileEntry;
import org.eclipse.buckminster.rmap.util.ICatalogReader;
import org.eclipse.buckminster.rmap.util.IComponentReader;
import org.eclipse.buckminster.rmap.util.RmapResourceFactoryImpl;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.runtime.MonitorUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.p2.metadata.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDEMapProviderImpl
extends ProviderImpl
implements PDEMapProvider {
    private static void collectEntries(File mapFile, Map<String, String> properties, Map<ComponentIdentifier, MapFileEntry> map) throws CoreException {
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(mapFile);
                ArrayList<MapFileEntry> list = new ArrayList<MapFileEntry>();
                MapFile.parse(input, mapFile.getCanonicalPath(), properties, list);
                for (MapFileEntry entry : list) {
                    map.put(entry.getComponentIdentifier(), entry);
                }
            }
            catch (IOException e) {
                throw BuckminsterException.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.close(input);
            throw throwable;
        }
        IOUtils.close((Closeable)input);
    }

    private static Format convertFetchFactoryLocator(String readerType, Map<String, String> fetchFactoryLocator, ComponentIdentifier componentName) throws CoreException {
        Format uri;
        if ("cvs".equals(readerType)) {
            uri = PDEMapProviderImpl.convertFetchFactoryLocator_cvs(fetchFactoryLocator, componentName);
        } else if ("url".equals(readerType)) {
            uri = PDEMapProviderImpl.convertFetchFactoryLocator_url(fetchFactoryLocator, componentName);
        } else if ("p2".equals(readerType)) {
            uri = PDEMapProviderImpl.convertFetchFactoryLocator_p2(fetchFactoryLocator, componentName);
        } else {
            throw BuckminsterException.fromMessage((String)"Reader %s cannot handle fetchFactory data", (Object[])new Object[]{readerType});
        }
        if (uri == null) {
            throw BuckminsterException.fromMessage((String)"Illegal fetch factory locator for reader %s", (Object[])new Object[]{readerType});
        }
        return uri;
    }

    private static Format convertFetchFactoryLocator_cvs(Map<String, String> fetchFactoryLocator, ComponentIdentifier componentName) throws CoreException {
        String cvsRoot = fetchFactoryLocator.get("cvsRoot");
        if (cvsRoot == null) {
            return null;
        }
        PropertyRef cnameRef = null;
        StringBuilder locator = new StringBuilder(cvsRoot);
        String pathStr = fetchFactoryLocator.get("path");
        locator.append(',');
        if (pathStr != null) {
            String id;
            IPath path = Path.fromPortableString((String)pathStr);
            String last = path.lastSegment();
            if (last.startsWith(id = componentName.getId())) {
                if (path.segmentCount() > 1) {
                    locator.append(path.removeLastSegments(1).toPortableString());
                    locator.append('/');
                }
                locator.append("{0}");
                if (last.length() > id.length()) {
                    locator.append(last.substring(id.length()));
                }
                cnameRef = CommonFactory.eINSTANCE.createPropertyRef();
            } else {
                locator.append(pathStr);
            }
        } else {
            locator.append("{0}");
            cnameRef = CommonFactory.eINSTANCE.createPropertyRef();
        }
        Format fmt = CommonFactory.eINSTANCE.createFormat();
        fmt.setFormat(locator.toString());
        if (cnameRef != null) {
            cnameRef.setKey("buckminster.component");
            fmt.getValues().add((Object)cnameRef);
        }
        return fmt;
    }

    private static Format convertFetchFactoryLocator_p2(Map<String, String> fetchFactoryLocator, ComponentIdentifier componentName) throws CoreException {
        String repoURI = fetchFactoryLocator.get("repository");
        if (repoURI == null) {
            return null;
        }
        Format fmt = CommonFactory.eINSTANCE.createFormat();
        fmt.setFormat(repoURI);
        return fmt;
    }

    private static Format convertFetchFactoryLocator_url(Map<String, String> fetchFactoryLocator, ComponentIdentifier componentName) throws CoreException {
        String repoURI = fetchFactoryLocator.get("src");
        if (repoURI == null) {
            return null;
        }
        Format fmt = CommonFactory.eINSTANCE.createFormat();
        fmt.setFormat(repoURI);
        return fmt;
    }

    private static Pattern createUniquePattern(String id, Map<String, Integer> idRefCounts) {
        StringBuilder bld = new StringBuilder();
        bld.append('^');
        int top = id.length();
        int idx = 0;
        while (idx < top) {
            char c = id.charAt(idx);
            switch (c) {
                case '.': {
                    bld.append('\\');
                }
            }
            bld.append(c);
            ++idx;
        }
        bld.append('$');
        String patternString = bld.toString();
        Integer refCount = idRefCounts.get(patternString);
        refCount = refCount == null ? Integer.valueOf(1) : Integer.valueOf(refCount + 1);
        idRefCounts.put(patternString, refCount);
        return Pattern.compile(patternString);
    }

    protected PDEMapProviderImpl() {
    }

    public ResourceMap getDelegationMap(IComponentReader reader, IStatus problemCollector, Map<ComponentIdentifier, Map<String, String>> queryHints, IProgressMonitor monitor) throws CoreException {
        Map<ComponentIdentifier, MapFileEntry> map = this.getMap(reader, problemCollector, monitor);
        if (map.isEmpty()) {
            return null;
        }
        int spIndex = 0;
        ResourceMap rmap = RmapFactory.eINSTANCE.createResourceMap();
        HashMap providersPerReader = new HashMap();
        HashMap<String, ArrayList<ComponentIdentifier>> idsPerSearchPath = new HashMap<String, ArrayList<ComponentIdentifier>>();
        for (MapFileEntry entry : map.values()) {
            SearchPath searchPath;
            ComponentIdentifier ci = entry.getComponentIdentifier();
            Map<String, String> properties = entry.getProperties();
            boolean source = true;
            Version v = null;
            String vs = null;
            String rt = entry.getReaderType();
            boolean isP2 = "p2".equals(rt);
            if (isP2) {
                String vstr = properties.get("version");
                if (vstr != null) {
                    v = Version.parseVersion((String)vstr);
                    this.addQueryHint(queryHints, ci, "version", v.toString());
                }
                source = false;
            } else {
                VersionConverter vc;
                String tag = properties.get("tag");
                if (tag != null) {
                    vs = tag;
                }
                if ((vc = this.getVersionConverter()) != null) {
                    v = vc.createVersion(vs);
                    this.addQueryHint(queryHints, ci, "version", v.toString());
                } else {
                    this.addQueryHint(queryHints, ci, "tag", tag);
                }
                if ("url".equals(rt)) {
                    source = false;
                }
            }
            ArrayList<Provider> providers = (ArrayList<Provider>)providersPerReader.get(rt);
            if (providers == null) {
                providers = new ArrayList<Provider>();
                providersPerReader.put(rt, providers);
            }
            Provider provider = null;
            Format providerURI = PDEMapProviderImpl.convertFetchFactoryLocator(rt, properties, ci);
            for (Provider candidate : providers) {
                if (!((String)candidate.getComponentTypes().get(0)).equals(ci.getType()) || !EcoreUtil.equals((EObject)candidate.getURI(), (EObject)providerURI)) continue;
                provider = candidate;
                break;
            }
            if (provider == null) {
                provider = RmapFactory.eINSTANCE.createProvider();
                provider.setURI(providerURI);
                provider.setReaderType(rt);
                provider.getComponentTypes().add((Object)ci.getType());
                provider.setSource(source);
                providers.add(provider);
                searchPath = RmapFactory.eINSTANCE.createSearchPath();
                searchPath.setName("sp" + spIndex++);
                searchPath.getProviders().add((Object)provider);
                rmap.getSearchPaths().add((Object)searchPath);
            } else {
                searchPath = (SearchPath)provider.eContainer();
            }
            ArrayList<ComponentIdentifier> ids = (ArrayList<ComponentIdentifier>)idsPerSearchPath.get(searchPath.getName());
            if (ids == null) {
                ids = new ArrayList<ComponentIdentifier>();
                idsPerSearchPath.put(searchPath.getName(), ids);
            }
            ids.add(ci);
        }
        HashMap<String, Integer> idRefCounts = new HashMap<String, Integer>();
        ArrayList<Provider> singletonProviders = new ArrayList<Provider>();
        Iterator spIterator = rmap.getSearchPaths().iterator();
        while (spIterator.hasNext()) {
            SearchPath sp = (SearchPath)spIterator.next();
            List ids = (List)idsPerSearchPath.get(sp.getName());
            if (ids.size() == 1) {
                Value v;
                ComponentIdentifier ci = (ComponentIdentifier)ids.get(0);
                Provider p = (Provider)sp.getProviders().get(0);
                p.setPattern(PDEMapProviderImpl.createUniquePattern(ci.getId(), idRefCounts));
                sp.getProviders().clear();
                spIterator.remove();
                Format fmt = p.getURI();
                if (fmt.getValues().size() == 1 && (v = (Value)fmt.getValues().get(0)) instanceof PropertyRef && "buckminster.component".equals(((PropertyRef)v).getKey())) {
                    fmt.setFormat(fmt.getValue(Collections.singletonMap("buckminster.component", ci.getId())));
                    fmt.getValues().clear();
                }
                singletonProviders.add(p);
                continue;
            }
            for (ComponentIdentifier ci : ids) {
                Locator locator = RmapFactory.eINSTANCE.createLocator();
                locator.setPattern(PDEMapProviderImpl.createUniquePattern(ci.getId(), idRefCounts));
                locator.getComponentTypes().add((Object)ci.getType());
                locator.setSearchPath(sp);
                rmap.getMatchers().add((Object)locator);
            }
        }
        for (Provider p : singletonProviders) {
            rmap.getMatchers().add((Object)p);
        }
        for (Matcher m : rmap.getMatchers()) {
            if (!(m instanceof Locator) || (Integer)idRefCounts.get(m.getPattern().toString()) != 1) continue;
            m.getComponentTypes().clear();
        }
        spIndex = 0;
        for (SearchPath sp : rmap.getSearchPaths()) {
            sp.setName("sp" + spIndex++);
        }
        try {
            ResourceSetImpl rs = new ResourceSetImpl();
            rs.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rmap", new RmapResourceFactoryImpl());
            rs.getPackageRegistry().put((Object)"http://www.eclipse.org/buckminster/RMap-1.0", (Object)RmapPackage.eINSTANCE);
            Resource resource = rs.createResource(URI.createURI((String)"http:///My.rmap"));
            resource.getContents().add((Object)rmap);
            resource.save((OutputStream)System.out, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rmap;
    }

    public Map<ComponentIdentifier, MapFileEntry> getMap(IComponentReader reader, IStatus problemCollector, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 700);
        File tempFolder = null;
        try {
            Map properties = reader.getProperties();
            tempFolder = IOUtils.createTempFolder((String)"bucky", (String)".tmp", (File)IOUtils.getTempRoot((Map)properties));
            this.materializeMaps(tempFolder, reader, MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)500));
            String[] mapFiles = tempFolder.list();
            if (mapFiles == null || mapFiles.length == 0) {
                Map<ComponentIdentifier, MapFileEntry> map = Collections.emptyMap();
                return map;
            }
            MonitorUtils.worked((IProgressMonitor)monitor, (int)50);
            HashMap<ComponentIdentifier, MapFileEntry> map = new HashMap();
            int amountPerFile = 100 / mapFiles.length;
            String[] stringArray = mapFiles;
            int n = mapFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                if (file.endsWith(".map")) {
                    PDEMapProviderImpl.collectEntries(new File(tempFolder, file), properties, map);
                }
                MonitorUtils.worked((IProgressMonitor)monitor, (int)amountPerFile);
                ++n2;
            }
            HashMap<ComponentIdentifier, MapFileEntry> hashMap = map = Collections.unmodifiableMap(map);
            return hashMap;
        }
        catch (IOException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
        finally {
            if (tempFolder != null) {
                try {
                    IOUtils.deleteRecursive((File)tempFolder, (IProgressMonitor)MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)50));
                }
                catch (IOException e) {
                    Buckminster.getLogger().warning((Throwable)e, e.getMessage(), new Object[0]);
                }
            }
            monitor.done();
        }
    }

    public boolean hasDelegationMap() {
        return true;
    }

    protected EClass eStaticClass() {
        return PdePackage.Literals.PDE_MAP_PROVIDER;
    }

    private void addQueryHint(Map<ComponentIdentifier, Map<String, String>> queryHints, ComponentIdentifier ci, String key, String value) {
        Map<String, String> hints = queryHints.get(ci);
        if (hints == null) {
            hints = new HashMap<String, String>();
            queryHints.put(ci, hints);
        }
        hints.put(key, value);
    }

    private void materializeMaps(File tempFolder, IComponentReader reader, IProgressMonitor monitor) throws CoreException {
        MonitorUtils.begin((IProgressMonitor)monitor, (int)500);
        try {
            ((ICatalogReader)reader).materialize((IPath)new Path(tempFolder.toString()), MonitorUtils.subMonitor((IProgressMonitor)monitor, (int)400));
        }
        finally {
            IOUtils.close((Closeable)reader);
            MonitorUtils.done((IProgressMonitor)monitor);
        }
    }
}

