/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.pde.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.model.common.CommonFactory;
import org.eclipse.buckminster.model.common.ComponentIdentifier;
import org.eclipse.buckminster.rmap.pde.Messages;
import org.eclipse.buckminster.rmap.pde.util.MapFileEntry;
import org.eclipse.buckminster.runtime.Buckminster;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.FetchTaskFactoriesRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapFile {
    private static final Pattern pattern = Pattern.compile("^\\s*([^@=,\\s]+)\\s*@\\s*([^@,=\\s]+)\\s*(?:,\\s*([^@,=\\s]+)\\s*)?=(?:\\s*([A-Za-z_][A-Za-z0-9_-]*)\\s*,)?\\s*\\s*([^\\s]+)\\s*$");
    private static FetchTaskFactoriesRegistry fetchTaskFactories;

    public static void parse(InputStream inputStream, String streamName, Map<String, String> properties, List<MapFileEntry> receivingList) throws IOException {
        String line;
        Logger logger = Buckminster.getLogger();
        if (fetchTaskFactories == null) {
            fetchTaskFactories = new FetchTaskFactoriesRegistry();
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
        block6: while ((line = input.readLine()) != null) {
            String readerTypeID;
            HashMap<String, String> props;
            String identifier;
            Version version;
            String ctypeId;
            String fetchType;
            block27: {
                String type;
                Matcher m;
                int len = line.length();
                int idx = 0;
                while (idx < len) {
                    char c = line.charAt(idx);
                    if (!Character.isWhitespace(c)) {
                        if (c != '!' && c != '#') break;
                        continue block6;
                    }
                    ++idx;
                }
                if (idx == len || !(m = pattern.matcher(line)).matches()) continue;
                fetchType = m.group(4);
                String fetchTypeSpecific = m.group(5);
                if (fetchType == null) {
                    fetchType = "CVS";
                } else if (fetchType.equals("COPY")) {
                    logger.warning(NLS.bind((String)Messages.fetch_type_COPY_not_supported_map_0, (Object)streamName), new Object[0]);
                    continue;
                }
                IFetchFactory ff = fetchTaskFactories.getFactory(fetchType);
                if (ff == null) {
                    fetchTypeSpecific = String.valueOf(fetchType) + ',' + fetchTypeSpecific;
                    fetchType = "CVS";
                    ff = fetchTaskFactories.getFactory(fetchType);
                    if (ff == null) {
                        logger.warning(NLS.bind((String)Messages.no_factory_found_for_0_in_PDEmap_1, (Object)fetchType, (Object)streamName), new Object[0]);
                        continue;
                    }
                }
                if ("plugin".equals(type = m.group(1)) || "bundle".equals(type) || "fragment".equals(type)) {
                    ctypeId = "osgi.bundle";
                } else if ("feature".equals(type)) {
                    ctypeId = "eclipse.feature";
                } else {
                    logger.warning(NLS.bind((String)Messages.unrecognized_component_type_0_in_PDEmap_1, (Object)type, (Object)streamName), new Object[0]);
                    continue;
                }
                String vstr = m.group(3);
                try {
                    version = vstr == null ? null : Version.parseVersion((String)vstr);
                }
                catch (IllegalArgumentException e) {
                    logger.warning(NLS.bind((String)Messages.badly_formatted_version_0_in_PDEmap_1, (Object)vstr, (Object)streamName), new Object[0]);
                    continue;
                }
                identifier = m.group(2);
                props = new HashMap<String, String>();
                try {
                    ff.parseMapFileEntry(fetchTypeSpecific, null, props);
                    String tag = (String)props.get("tag");
                    if (tag == null || tag.length() <= 2 || tag.charAt(0) != '@' || tag.charAt(tag.length() - 1) != '@') break block27;
                    String tagKey = tag.substring(1, tag.length() - 1);
                    if ((tag = properties.get(tagKey)) == null) {
                        props.remove("tag");
                    } else {
                        props.put("tag", tag);
                    }
                }
                catch (Exception e) {
                    logger.warning(NLS.bind((String)Messages.fetch_factory_0_unable_to_parse_1_in_PDEmap_2, (Object[])new Object[]{fetchType, fetchTypeSpecific, streamName}), new Object[0]);
                    continue;
                }
            }
            if ("get".equals(readerTypeID = fetchType.toLowerCase())) {
                readerTypeID = "url";
                String src = (String)props.get("src");
                if (src.endsWith(".jar") || src.endsWith(".zip")) {
                    String vcName;
                    int lastSlash = src.lastIndexOf(47);
                    if (lastSlash < 0) {
                        lastSlash = 0;
                    }
                    if ((vcName = src.substring(lastSlash + 1, src.length() - 4)).startsWith(String.valueOf(identifier) + '_')) {
                        try {
                            version = Version.parseVersion((String)vcName.substring(identifier.length() + 1));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            } else if (readerTypeID.equals("p2iu")) {
                readerTypeID = "p2";
            }
            ComponentIdentifier cid = CommonFactory.eINSTANCE.createComponentIdentifier();
            cid.setId(identifier);
            cid.setType(ctypeId);
            cid.setVersion(version);
            receivingList.add(new MapFileEntry(cid, readerTypeID, props));
        }
    }
}

