/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buckminster.rmap.RmapPackage;
import org.eclipse.buckminster.rmap.Transform;
import org.eclipse.buckminster.rmap.util.TransformMismatchException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class TransformImpl
extends EObjectImpl
implements Transform {
    protected static final Pattern FROM_PATTERN_EDEFAULT = null;
    protected Pattern fromPattern = FROM_PATTERN_EDEFAULT;
    protected static final String FROM_REPLACEMENT_EDEFAULT = null;
    protected String fromReplacement = FROM_REPLACEMENT_EDEFAULT;
    protected static final Pattern TO_PATTERN_EDEFAULT = null;
    protected Pattern toPattern = TO_PATTERN_EDEFAULT;
    protected static final String TO_REPLACEMENT_EDEFAULT = null;
    protected String toReplacement = TO_REPLACEMENT_EDEFAULT;

    private static String replace(String source, Pattern pattern, String replacement) {
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                matcher.appendReplacement(sb, replacement);
            } while (matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    protected TransformImpl() {
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFromPattern();
            }
            case 1: {
                return this.getFromReplacement();
            }
            case 2: {
                return this.getToPattern();
            }
            case 3: {
                return this.getToReplacement();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return FROM_PATTERN_EDEFAULT == null ? this.fromPattern != null : !FROM_PATTERN_EDEFAULT.equals(this.fromPattern);
            }
            case 1: {
                return FROM_REPLACEMENT_EDEFAULT == null ? this.fromReplacement != null : !FROM_REPLACEMENT_EDEFAULT.equals(this.fromReplacement);
            }
            case 2: {
                return TO_PATTERN_EDEFAULT == null ? this.toPattern != null : !TO_PATTERN_EDEFAULT.equals(this.toPattern);
            }
            case 3: {
                return TO_REPLACEMENT_EDEFAULT == null ? this.toReplacement != null : !TO_REPLACEMENT_EDEFAULT.equals(this.toReplacement);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFromPattern((Pattern)newValue);
                return;
            }
            case 1: {
                this.setFromReplacement((String)newValue);
                return;
            }
            case 2: {
                this.setToPattern((Pattern)newValue);
                return;
            }
            case 3: {
                this.setToReplacement((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFromPattern(FROM_PATTERN_EDEFAULT);
                return;
            }
            case 1: {
                this.setFromReplacement(FROM_REPLACEMENT_EDEFAULT);
                return;
            }
            case 2: {
                this.setToPattern(TO_PATTERN_EDEFAULT);
                return;
            }
            case 3: {
                this.setToReplacement(TO_REPLACEMENT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public Pattern getFromPattern() {
        return this.fromPattern;
    }

    public String getFromReplacement() {
        return this.fromReplacement;
    }

    public Pattern getToPattern() {
        return this.toPattern;
    }

    public String getToReplacement() {
        return this.toReplacement;
    }

    public void setFromPattern(Pattern newFromPattern) {
        Pattern oldFromPattern = this.fromPattern;
        this.fromPattern = newFromPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFromPattern, (Object)this.fromPattern));
        }
    }

    public void setFromReplacement(String newFromReplacement) {
        String oldFromReplacement = this.fromReplacement;
        this.fromReplacement = newFromReplacement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldFromReplacement, (Object)this.fromReplacement));
        }
    }

    public void setToPattern(Pattern newToPattern) {
        Pattern oldToPattern = this.toPattern;
        this.toPattern = newToPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldToPattern, (Object)this.toPattern));
        }
    }

    public void setToReplacement(String newToReplacement) {
        String oldToReplacement = this.toReplacement;
        this.toReplacement = newToReplacement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldToReplacement, (Object)this.toReplacement));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fromPattern: ");
        result.append(this.fromPattern);
        result.append(", fromReplacement: ");
        result.append(this.fromReplacement);
        result.append(", toPattern: ");
        result.append(this.toPattern);
        result.append(", toReplacement: ");
        result.append(this.toReplacement);
        result.append(')');
        return result.toString();
    }

    public String transformFrom(String source) throws TransformMismatchException {
        return this.transform(source, this.fromPattern, this.fromReplacement, this.toPattern, this.toReplacement);
    }

    public String transformTo(String source) throws TransformMismatchException {
        return this.transform(source, this.toPattern, this.toReplacement, this.fromPattern, this.fromReplacement);
    }

    protected EClass eStaticClass() {
        return RmapPackage.Literals.TRANSFORM;
    }

    private String transform(String source, Pattern pattern, String replacement, Pattern reversePattern, String reverseReplacement) throws TransformMismatchException {
        String result = TransformImpl.replace(source, pattern, replacement);
        if (result == null) {
            return null;
        }
        String reverse = TransformImpl.replace(result, reversePattern, reverseReplacement);
        if (reverse == null) {
            return null;
        }
        if (source.equals(reverse)) {
            return result;
        }
        throw new TransformMismatchException(this);
    }
}

