/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.rmap.impl;

import java.util.Collection;
import org.eclipse.buckminster.model.common.util.VersionHelper;
import org.eclipse.buckminster.rmap.RmapPackage;
import org.eclipse.buckminster.rmap.Transform;
import org.eclipse.buckminster.rmap.VersionConverter;
import org.eclipse.buckminster.rmap.VersionSelectorType;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.equinox.p2.metadata.IVersionFormat;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionConverterImpl
extends EObjectImpl
implements VersionConverter {
    protected static final VersionSelectorType TYPE_EDEFAULT = VersionSelectorType.BRANCH;
    protected VersionSelectorType type = TYPE_EDEFAULT;
    protected EList<Transform> transformers;
    protected static final IVersionFormat VERSION_FORMAT_EDEFAULT = null;
    protected IVersionFormat versionFormat = VERSION_FORMAT_EDEFAULT;
    protected static final String VERSION_TYPE_EDEFAULT = "OSGi";
    protected String versionType = "OSGi";

    protected VersionConverterImpl() {
    }

    @Override
    public String createIdentifier(Version version) {
        if (version == null) {
            return null;
        }
        String result = VersionHelper.getOriginal((Version)version);
        EList<Transform> trs = this.getTransformers();
        if (trs.size() > 0) {
            boolean matchFound = false;
            for (Transform transformer : trs) {
                String transformed = transformer.transformFrom(result);
                if (transformed == null) continue;
                matchFound = true;
                result = transformed;
            }
            if (!matchFound) {
                return null;
            }
        }
        return result;
    }

    @Override
    public Version createVersion(String identifier) {
        if (identifier == null) {
            return null;
        }
        EList<Transform> trs = this.getTransformers();
        if (trs.size() > 0) {
            boolean matchFound = false;
            for (Transform transformer : trs) {
                String transformed = transformer.transformTo(identifier);
                if (transformed == null) continue;
                matchFound = true;
                identifier = transformed;
            }
            if (!matchFound) {
                return null;
            }
        }
        if (this.versionFormat == null) {
            String vtype = this.getVersionType();
            if (vtype == null) {
                if (this.getType() == VersionSelectorType.BRANCH) {
                    try {
                        this.setVersionFormat(Version.compile((String)"S"));
                    }
                    catch (VersionFormatException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    this.setVersionFormat(VersionHelper.getOSGiFormat());
                }
            } else {
                this.setVersionFormat(VersionHelper.getVersionType((String)vtype).getFormat());
            }
        }
        return this.versionFormat.parse(identifier);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getType();
            }
            case 1: {
                return this.getTransformers();
            }
            case 2: {
                return this.getVersionFormat();
            }
            case 3: {
                return this.getVersionType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getTransformers()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.type != TYPE_EDEFAULT;
            }
            case 1: {
                return this.transformers != null && !this.transformers.isEmpty();
            }
            case 2: {
                return VERSION_FORMAT_EDEFAULT == null ? this.versionFormat != null : !VERSION_FORMAT_EDEFAULT.equals(this.versionFormat);
            }
            case 3: {
                return VERSION_TYPE_EDEFAULT == null ? this.versionType != null : !VERSION_TYPE_EDEFAULT.equals(this.versionType);
            }
        }
        return super.eIsSet(featureID);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setType((VersionSelectorType)((Object)newValue));
                return;
            }
            case 1: {
                this.getTransformers().clear();
                this.getTransformers().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setVersionFormat((IVersionFormat)newValue);
                return;
            }
            case 3: {
                this.setVersionType((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 1: {
                this.getTransformers().clear();
                return;
            }
            case 2: {
                this.setVersionFormat(VERSION_FORMAT_EDEFAULT);
                return;
            }
            case 3: {
                this.setVersionType(VERSION_TYPE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public EList<Transform> getTransformers() {
        if (this.transformers == null) {
            this.transformers = new EObjectContainmentEList(Transform.class, (InternalEObject)this, 1);
        }
        return this.transformers;
    }

    @Override
    public VersionSelectorType getType() {
        return this.type;
    }

    @Override
    public IVersionFormat getVersionFormat() {
        return this.versionFormat;
    }

    @Override
    public String getVersionType() {
        return this.versionType;
    }

    @Override
    public void setType(VersionSelectorType newType) {
        VersionSelectorType oldType = this.type;
        VersionSelectorType versionSelectorType = this.type = newType == null ? TYPE_EDEFAULT : newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public void setVersionFormat(IVersionFormat newVersionFormat) {
        IVersionFormat oldVersionFormat = this.versionFormat;
        this.versionFormat = newVersionFormat;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldVersionFormat, (Object)this.versionFormat));
        }
    }

    @Override
    public void setVersionType(String newVersionType) {
        String oldVersionType = this.versionType;
        this.versionType = newVersionType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldVersionType, (Object)this.versionType));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append((Object)this.type);
        result.append(", versionFormat: ");
        result.append(this.versionFormat);
        result.append(", versionType: ");
        result.append(this.versionType);
        result.append(')');
        return result.toString();
    }

    protected EClass eStaticClass() {
        return RmapPackage.Literals.VERSION_CONVERTER;
    }
}

