/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.runtime;

import java.util.IdentityHashMap;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.BuckminsterPreferences;
import org.eclipse.buckminster.runtime.IBuckminsterPreferenceConstants;
import org.eclipse.buckminster.runtime.LogAwarePlugin;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Buckminster
extends LogAwarePlugin
implements IEclipsePreferences.IPreferenceChangeListener,
IBuckminsterPreferenceConstants {
    public static final String NAMESPACE = "org.eclipse.buckminster";
    public static final String PLUGIN_ID = "org.eclipse.buckminster.runtime";
    public static final String ACTION_TEMP_ROOT = "buckminster.temp.root";
    public static final String ACTION_OUTPUT_ROOT = "buckminster.output.root";
    private static Buckminster plugin;
    private static boolean headless;
    private IdentityHashMap<Object, ServiceReference> services;

    static {
        headless = false;
    }

    public static Buckminster getDefault() {
        return plugin;
    }

    public static Logger getLogger() {
        return plugin.getBundleLogger();
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static void setHeadless() {
        headless = true;
    }

    public Buckminster() {
        plugin = this;
    }

    public <T> T getService(Class<T> serviceClass) throws CoreException {
        String serviceName;
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference serviceRef = context.getServiceReference(serviceName = serviceClass.getName());
        if (serviceRef == null) {
            throw BuckminsterException.fromMessage(NLS.bind((String)Messages.Missing_OSGi_Service_0, (Object)serviceName), new Object[0]);
        }
        T service = serviceClass.cast(context.getService(serviceRef));
        if (this.services == null) {
            this.services = new IdentityHashMap();
        }
        this.services.put(service, serviceRef);
        return service;
    }

    public <T> T getService(Class<T> serviceClass, String filter) throws CoreException {
        ServiceReference[] serviceRef;
        BundleContext context = this.getBundle().getBundleContext();
        String serviceName = serviceClass.getName();
        try {
            serviceRef = context.getServiceReferences(serviceName, filter);
        }
        catch (InvalidSyntaxException e) {
            throw BuckminsterException.wrap(e);
        }
        if (serviceRef == null || serviceRef.length == 0) {
            throw BuckminsterException.fromMessage(NLS.bind((String)Messages.Missing_OSGi_Service_0, (Object)serviceName), new Object[0]);
        }
        T service = serviceClass.cast(context.getService(serviceRef[0]));
        if (this.services == null) {
            this.services = new IdentityHashMap();
        }
        this.services.put(service, serviceRef[0]);
        return service;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        Object newVal;
        if ("logLevelConsole".equals(event.getKey())) {
            newVal = event.getNewValue();
            Logger.setConsoleLevelThreshold(newVal == null ? 1 : Integer.parseInt(newVal.toString()));
        }
        if ("logLevelEclipseLogger".equals(event.getKey())) {
            newVal = event.getNewValue();
            Logger.setEclipseLoggerLevelThreshold(newVal == null ? 2 : Integer.parseInt(newVal.toString()));
        } else if ("logEclipseToConsole".equals(event.getKey())) {
            newVal = event.getNewValue();
            Logger.setEclipseLoggerToConsole(newVal == null ? false : Boolean.valueOf(newVal.toString()));
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Logger.setConsoleLevelThreshold(BuckminsterPreferences.getLogLevelConsole());
        Logger.setEclipseLoggerLevelThreshold(BuckminsterPreferences.getLogLevelEclipseLogger());
        Logger.setEclipseLoggerToConsole(BuckminsterPreferences.isEclipseLoggerToConsole());
        Logger.setDefaultLogger(this.getBundle());
        BuckminsterPreferences.addListener(this);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.services != null) {
            for (ServiceReference serviceRef : this.services.values()) {
                context.ungetService(serviceRef);
            }
            this.services = null;
        }
        plugin = null;
        super.stop(context);
    }

    public void ungetService(Object service) {
        ServiceReference serviceRef;
        if (this.services != null && service != null && (serviceRef = this.services.remove(service)) != null) {
            this.getBundle().getBundleContext().ungetService(serviceRef);
        }
    }
}

