/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.buckminster.core.CorePlugin;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.runtime.BuckminsterException;
import org.eclipse.buckminster.runtime.Logger;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.runtime.URLUtils;
import org.eclipse.buckminster.subversion.GenericCache;
import org.eclipse.buckminster.subversion.ISubversionCache;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.buckminster.subversion.Messages;
import org.eclipse.buckminster.subversion.RepositoryAccess;
import org.eclipse.buckminster.subversion.SvnExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericSession<REPO_LOCATION_TYPE, SVN_ENTRY_TYPE, SVN_REVISION_TYPE>
implements ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> {
    protected final VersionSelector branchOrTag;
    protected REPO_LOCATION_TYPE repositoryLocation;
    protected final IPath module;
    protected final boolean moduleAfterBranch;
    protected final boolean moduleAfterTag;
    protected final boolean moduleBeforeBranch;
    protected final boolean moduleBeforeTag;
    protected final boolean trunkStructure;
    protected final String password;
    private final SVN_REVISION_TYPE revision;
    protected final IPath subModule;
    protected final String urlLeadIn;
    protected final String username;
    protected final ISubversionCache<SVN_ENTRY_TYPE> cache;

    private static Collection<RepositoryAccess> getCommonRootsStep(Collection<RepositoryAccess> source) throws CoreException {
        HashSet<RepositoryAccess> commonRoots = null;
        for (RepositoryAccess repoAccess : source) {
            URI url = repoAccess.getSvnURL();
            String[] urlSegs = Path.fromPortableString((String)url.getPath()).segments();
            for (RepositoryAccess repoAccessCmp : source) {
                if (repoAccess == repoAccessCmp) continue;
                URI cmp = repoAccessCmp.getSvnURL();
                if (!Trivial.equalsAllowNull((Object)url.getHost(), (Object)cmp.getHost()) || !Trivial.equalsAllowNull((Object)url.getScheme(), (Object)cmp.getScheme()) || url.getPort() != cmp.getPort()) continue;
                int maxSegs = urlSegs.length;
                String[] cmpSegs = Path.fromPortableString((String)cmp.getPath()).segments();
                if (maxSegs > cmpSegs.length) {
                    maxSegs = cmpSegs.length;
                }
                int idx = 0;
                while (idx < maxSegs) {
                    if (!urlSegs[idx].equals(cmpSegs[idx])) break;
                    ++idx;
                }
                if (idx < 1) continue;
                String user = repoAccess.getUser();
                String cmpUser = repoAccessCmp.getUser();
                if (user == null) {
                    user = cmpUser;
                } else if (cmpUser != null && !user.equals(cmpUser)) continue;
                String password = repoAccess.getPassword();
                String cmpPassword = repoAccessCmp.getPassword();
                if (password == null) {
                    password = cmpPassword;
                } else if (cmpPassword != null && !password.equals(cmpPassword)) continue;
                StringBuilder bld = new StringBuilder();
                bld.append(url.getScheme());
                bld.append("://");
                if (url.getHost() != null) {
                    bld.append(url.getHost());
                    if (url.getPort() != -1) {
                        bld.append(":");
                        bld.append(url.getPort());
                    }
                }
                int pdx = 0;
                while (pdx < idx) {
                    String seg = urlSegs[pdx];
                    bld.append('/');
                    if (idx > 0 && seg.equals("trunk") || seg.equals("tags") || seg.equals("branches")) break;
                    bld.append(seg);
                    ++pdx;
                }
                try {
                    if (commonRoots == null) {
                        commonRoots = new HashSet<RepositoryAccess>();
                    }
                    commonRoots.add(new RepositoryAccess(new URI(bld.toString()), user, password));
                }
                catch (URISyntaxException e) {
                    throw BuckminsterException.wrap((Throwable)e);
                }
            }
        }
        if (commonRoots == null) {
            return source;
        }
        HashSet<RepositoryAccess> rogueRoots = null;
        for (RepositoryAccess repoAccess : source) {
            boolean found = false;
            URI url = repoAccess.getSvnURL();
            String[] urlSegs = Path.fromPortableString((String)url.getPath()).segments();
            for (RepositoryAccess repoAccessCmp : commonRoots) {
                String[] cmpSegs;
                int maxSegs;
                URI cmp = repoAccessCmp.getSvnURL();
                if (!Trivial.equalsAllowNull((Object)url.getHost(), (Object)cmp.getHost()) || !Trivial.equalsAllowNull((Object)url.getScheme(), (Object)cmp.getScheme()) || url.getPort() != cmp.getPort() || (maxSegs = (cmpSegs = Path.fromPortableString((String)cmp.getPath()).segments()).length) > urlSegs.length) continue;
                int idx = 0;
                while (idx < maxSegs) {
                    if (!urlSegs[idx].equals(cmpSegs[idx])) break;
                    ++idx;
                }
                if (idx < maxSegs) continue;
                String user = repoAccess.getUser();
                String cmpUser = repoAccessCmp.getUser();
                if (user != null && cmpUser != null && !user.equals(cmpUser)) continue;
                String password = repoAccess.getPassword();
                String cmpPassword = repoAccessCmp.getPassword();
                if (password != null && cmpPassword != null && !password.equals(cmpPassword)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (rogueRoots == null) {
                rogueRoots = new HashSet<RepositoryAccess>();
            }
            rogueRoots.add(repoAccess);
        }
        if (rogueRoots != null) {
            commonRoots.addAll(rogueRoots);
        }
        return commonRoots;
    }

    private static String getScheme(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(Messages.URI_can_not_be_null_at_this_point);
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            CorePlugin.getLogger().warning(NLS.bind((String)Messages.URI_0_has_no_scheme, (Object)uri), new Object[0]);
            return "file";
        }
        return scheme.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public GenericSession(String repositoryURI, VersionSelector branchOrTag, long revision, Date timestamp, RMContext context) throws CoreException {
        super();
        this.revision = this.getSVNRevision(revision, timestamp);
        this.branchOrTag = branchOrTag;
        userCache = context.getUserCache();
        this.cache = this.getCache(userCache);
        try {
            uri = new URI(repositoryURI);
            fullPath = new Path(uri.getPath());
            pathSegments = fullPath.segments();
            idx = pathSegments.length;
            while (--idx >= 0) {
                if (pathSegments[idx].equals("trunk")) break;
            }
            if (idx >= 0) {
                this.trunkStructure = true;
            } else {
                this.trunkStructure = false;
                idx = pathSegments.length - 1;
            }
            if (branchOrTag != null && !this.trunkStructure) {
                throw BuckminsterException.fromMessage((String)NLS.bind((String)Messages.branch_or_tag_0_not_found, (Object)branchOrTag), (Object[])new Object[0]);
            }
            relPathLen = pathSegments.length - idx;
            bld = new StringBuilder();
            scheme = uri.getScheme();
            if (scheme != null) {
                bld.append(scheme);
                bld.append("://");
            }
            _username = null;
            _password = null;
            authority = uri.getAuthority();
            if (authority != null) {
                atIdx = authority.indexOf(64);
                if (atIdx > 0) {
                    authentication = authority.substring(0, atIdx);
                    authority = authority.substring(atIdx + 1);
                    upSplit = authentication.indexOf(58);
                    if (upSplit > 0) {
                        _username = authentication.substring(0, upSplit);
                        if ("null".equals(_username)) {
                            _username = null;
                        }
                        if ("null".equals(_password = authentication.substring(upSplit + 1))) {
                            _password = null;
                        }
                    }
                }
                bld.append(authority);
            }
            this.username = _username;
            this.password = _password;
            if (fullPath.getDevice() != null) {
                bld.append('/');
            }
            bld.append(fullPath.removeLastSegments(relPathLen));
            _urlLeadIn = bld.toString();
            modulePath = null;
            if (this.trunkStructure) {
                if (relPathLen > 1) {
                    modulePath = fullPath.removeFirstSegments(idx + 1);
                    modulePath = modulePath.setDevice(null);
                }
            } else {
                modulePath = Path.fromPortableString((String)fullPath.lastSegment());
            }
            this.module = modulePath;
            tmp = uri.getFragment();
            _subModule = null;
            if (tmp != null) {
                _subModule = new Path(tmp).makeRelative();
            }
            this.subModule = _subModule;
            _moduleBeforeTag = false;
            _moduleAfterTag = false;
            _moduleBeforeBranch = false;
            _moduleAfterBranch = false;
            if (this.trunkStructure) {
                var29_28 = URLUtils.decodeToQueryPairs((String)uri.getQuery());
                var28_29 = var29_28.length;
                var27_31 = 0;
                while (var27_31 < var28_29) {
                    entry = var29_28[var27_31];
                    if (entry.equalsIgnoreCase("moduleBeforeTag")) {
                        _moduleBeforeTag = true;
                    } else if (entry.equalsIgnoreCase("moduleAfterTag")) {
                        _moduleAfterTag = true;
                    } else if (entry.equalsIgnoreCase("moduleBeforeBranch")) {
                        _moduleBeforeBranch = true;
                    } else if (entry.equalsIgnoreCase("moduleAfterBranch")) {
                        _moduleAfterBranch = true;
                    }
                    ++var27_31;
                }
            }
            this.moduleBeforeTag = _moduleBeforeTag;
            this.moduleAfterTag = _moduleAfterTag;
            this.moduleBeforeBranch = _moduleBeforeBranch;
            this.moduleAfterBranch = _moduleAfterBranch;
            rank = 0;
            ourRoot = new URI(_urlLeadIn);
            ourProto = GenericSession.getScheme(ourRoot);
            bestMatch = null;
            var33_35 = this.getKnownRepositories();
            var32_36 = var33_35.length;
            var31_37 = 0;
            while (var31_37 < var32_36) {
                block37: {
                    block38: {
                        location = var33_35[var31_37];
                        repoRoot = new URI(this.getRootUrl(location));
                        if (!Trivial.equalsAllowNull((Object)repoRoot.getHost(), (Object)ourRoot.getHost())) break block37;
                        repoProto = GenericSession.getScheme(repoRoot);
                        v0 = repoIsSSH = repoProto.equals("svn+ssh") != false || repoProto.equals("https") != false;
                        if (rank > 200 && !repoIsSSH || !repoProto.equals(ourProto) && (!repoProto.equals("svn") || !ourProto.equals("http")) && (!repoProto.equals("http") || !ourProto.equals("svn")) && (!ourProto.equals("svn") && !ourProto.equals("http") || !repoIsSSH)) break block37;
                        ourPath = Path.fromPortableString((String)ourRoot.getPath()).segments();
                        repoPath = Path.fromPortableString((String)repoRoot.getPath()).segments();
                        idx = repoPath.length;
                        if (idx <= (top = ourPath.length)) ** GOTO lbl-1000
                        break block37;
                        while (ourPath[idx].equals(repoPath[idx])) lbl-1000:
                        // 2 sources

                        {
                            if (--idx >= 0) continue;
                        }
                        if (idx >= 0) break block37;
                        _urlLeadIn = repoRoot.toString();
                        diff = top - repoPath.length;
                        if (diff <= 0) break block38;
                        myRank = (repoIsSSH != false ? 400 : 200) - diff;
                        if (rank > myRank) break block37;
                        bld.setLength(0);
                        bld.append(_urlLeadIn);
                        idx = repoPath.length;
                        while (idx < top) {
                            bld.append('/');
                            bld.append(ourPath[idx]);
                            ++idx;
                        }
                        _urlLeadIn = bld.toString();
                    }
                    rank = (repoIsSSH != false ? 400 : 200) - diff;
                    bestMatch = location;
                    if (rank == 400) break;
                }
                ++var31_37;
            }
            this.urlLeadIn = _urlLeadIn;
            this.repositoryLocation = bestMatch;
            var30_38 = userCache;
            synchronized (var30_38) {
                this.initializeSvn(context, ourRoot, bestMatch);
            }
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final void createCommonRoots(RMContext context) throws CoreException {
        List<RepositoryAccess> unknownRoots = this.getUnknownRoots(context.getBindingProperties());
        if (unknownRoots.size() == 0) {
            return;
        }
        Collection<RepositoryAccess> sourceRoots = unknownRoots;
        if (unknownRoots.size() > 1) {
            Collection<RepositoryAccess> commonRoots;
            while ((commonRoots = GenericSession.getCommonRootsStep(sourceRoots)) != sourceRoots) {
                sourceRoots = commonRoots;
            }
        }
        this.createRoots(sourceRoots);
        this.clearUnknownRoots(context.getBindingProperties());
    }

    public final REPO_LOCATION_TYPE getRepositoryLocation() {
        return this.repositoryLocation;
    }

    @Override
    public final SVN_REVISION_TYPE getRevision() {
        return this.revision;
    }

    public abstract SVN_REVISION_TYPE getSVNRevision(long var1, Date var3);

    @Override
    public final URI getSVNRootUrl(boolean branches) throws CoreException {
        StringBuilder bld = new StringBuilder();
        bld.append(this.urlLeadIn);
        if (branches) {
            bld.append("/branches");
            if (this.moduleBeforeBranch && this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
        } else {
            bld.append("/tags");
            if (this.moduleBeforeTag && this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
        }
        try {
            return new URI(bld.toString());
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final URI getSVNUrl() throws CoreException {
        return this.getSVNUrl(null);
    }

    @Override
    public final URI getSVNUrl(String fileName) throws CoreException {
        StringBuilder bld = new StringBuilder();
        bld.append(this.urlLeadIn);
        if (this.branchOrTag == null) {
            if (this.trunkStructure) {
                bld.append("/trunk");
            }
            if (this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
        } else if (this.branchOrTag.getType() == 0) {
            bld.append("/branches");
            if (this.moduleBeforeBranch && this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
            bld.append('/');
            bld.append(this.branchOrTag.getName());
            if (this.moduleAfterBranch && this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
        } else {
            bld.append("/tags");
            if (this.moduleBeforeTag && this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
            bld.append('/');
            bld.append(this.branchOrTag.getName());
            if (this.moduleAfterTag && this.module != null) {
                bld.append('/');
                bld.append(this.module);
            }
        }
        if (this.subModule != null) {
            bld.append('/');
            bld.append(this.subModule);
        }
        if (fileName != null) {
            bld.append('/');
            bld.append(fileName);
        }
        try {
            return new URI(bld.toString());
        }
        catch (URISyntaxException e) {
            throw BuckminsterException.wrap((Throwable)e);
        }
    }

    @Override
    public final boolean hasTrunkStructure() {
        return this.trunkStructure;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final SVN_ENTRY_TYPE[] listFolder(URI url, IProgressMonitor monitor) throws CoreException {
        String key;
        String string = key = GenericCache.cacheKey(url, this.getRevision()).intern();
        synchronized (string) {
            SVN_ENTRY_TYPE[] list = this.cache.get(key);
            if (list != null) {
                return list;
            }
            Logger logger = CorePlugin.getLogger();
            try {
                logger.debug("Listing remote folder %s", new Object[]{key});
                list = this.innerListFolder(url, monitor);
                if (list == null || list.length == 0) {
                    logger.debug("Remote folder had no entries %s", new Object[]{key});
                    list = this.getEmptyEntryList();
                }
                this.cache.put(key, list);
                SVN_ENTRY_TYPE[] SVN_ENTRY_TYPEArray = list;
                return SVN_ENTRY_TYPEArray;
            }
            catch (Exception e) {
                if (SvnExceptionHandler.hasSvnException(e)) {
                    logger.debug(Messages.remote_folder_does_not_exist_0, new Object[]{key});
                    SVN_ENTRY_TYPE[] SVN_ENTRY_TYPEArray2 = this.getEmptyEntryList();
                    return SVN_ENTRY_TYPEArray2;
                }
                throw BuckminsterException.wrap((Throwable)e);
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addUnknownRoot(Map<String, String> properties, RepositoryAccess ra) {
        Map<String, String> map = properties;
        synchronized (map) {
            String unknownRootPrefix = this.getUnknownRootPrefix();
            int maxNum = -1;
            String raStr = ra.toString();
            for (Map.Entry<String, String> entries : properties.entrySet()) {
                block6: {
                    int lastDot;
                    String key = entries.getKey();
                    if (!key.startsWith(unknownRootPrefix) || (lastDot = key.lastIndexOf(46)) < 0) continue;
                    try {
                        int keyNum = Integer.parseInt(key.substring(lastDot + 1));
                        if (maxNum >= keyNum) break block6;
                        maxNum = keyNum;
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                }
                if (!entries.getValue().equals(raStr)) continue;
                return;
            }
            properties.put(String.valueOf(unknownRootPrefix) + (maxNum + 1), raStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clearUnknownRoots(Map<String, String> properties) {
        Map<String, String> map = properties;
        synchronized (map) {
            Iterator<String> keys = properties.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                if (!key.startsWith(this.getUnknownRootPrefix())) continue;
                keys.remove();
            }
        }
    }

    protected abstract void createRoots(Collection<RepositoryAccess> var1) throws CoreException;

    protected abstract ISubversionCache<SVN_ENTRY_TYPE> getCache(Map<UUID, Object> var1);

    protected abstract SVN_ENTRY_TYPE[] getEmptyEntryList();

    protected abstract REPO_LOCATION_TYPE[] getKnownRepositories() throws CoreException;

    protected abstract String getRootUrl(REPO_LOCATION_TYPE var1);

    protected abstract String getUnknownRootPrefix();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<RepositoryAccess> getUnknownRoots(Map<String, String> properties) {
        Map<String, String> map = properties;
        synchronized (map) {
            List<RepositoryAccess> unknownRoots = null;
            for (Map.Entry<String, String> entries : properties.entrySet()) {
                RepositoryAccess ra;
                String key = entries.getKey();
                if (!key.startsWith(this.getUnknownRootPrefix())) continue;
                try {
                    ra = new RepositoryAccess(entries.getValue());
                }
                catch (URISyntaxException e) {
                    continue;
                }
                if (unknownRoots == null) {
                    unknownRoots = new ArrayList<RepositoryAccess>();
                }
                unknownRoots.add(ra);
            }
            if (unknownRoots == null) {
                unknownRoots = Collections.emptyList();
            }
            return unknownRoots;
        }
    }

    protected abstract void initializeSvn(RMContext var1, URI var2, REPO_LOCATION_TYPE var3) throws CoreException;

    protected abstract SVN_ENTRY_TYPE[] innerListFolder(URI var1, IProgressMonitor var2) throws Exception;
}

