/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.buckminster.core.RMContext;
import org.eclipse.buckminster.core.ctype.IComponentType;
import org.eclipse.buckminster.core.resolver.NodeQuery;
import org.eclipse.buckminster.core.rmap.model.Provider;
import org.eclipse.buckminster.core.version.AbstractSCCSVersionFinder;
import org.eclipse.buckminster.core.version.VersionMatch;
import org.eclipse.buckminster.core.version.VersionSelector;
import org.eclipse.buckminster.subversion.ISubversionSession;
import org.eclipse.buckminster.subversion.ISvnEntryHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericVersionFinder<SVN_ENTRY_TYPE, SVN_REVISION_TYPE>
extends AbstractSCCSVersionFinder {
    private final ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> session;
    private final ISvnEntryHelper<SVN_ENTRY_TYPE> helper;

    public GenericVersionFinder(Provider provider, IComponentType ctype, NodeQuery query) throws CoreException {
        super(provider, ctype, query);
        this.session = this.getSession(provider.getURI(query.getProperties()), null, query.getNumericRevision(), query.getTimestamp(), query.getContext());
        this.helper = this.session.getSvnEntryHelper();
    }

    public final void close() {
        this.session.close();
    }

    protected final boolean checkComponentExistence(VersionMatch versionMatch, IProgressMonitor monitor) throws CoreException {
        NodeQuery query = this.getQuery();
        String uri = this.getProvider().getURI(query.getProperties());
        VersionSelector branchOrTag = versionMatch.getBranchOrTag();
        long revision = versionMatch.getNumericRevision();
        Date timestamp = versionMatch.getTimestamp();
        RMContext context = query.getContext();
        ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> checkerSession = this.getSession(uri, branchOrTag, revision, timestamp, context);
        try {
            URI url = checkerSession.getSVNUrl();
            boolean bl = checkerSession.listFolder(url, monitor).length > 0;
            return bl;
        }
        finally {
            checkerSession.close();
        }
    }

    protected final List<AbstractSCCSVersionFinder.RevisionEntry> getBranchesOrTags(boolean branches, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 200);
        try {
            if (!this.session.hasTrunkStructure()) {
                List<AbstractSCCSVersionFinder.RevisionEntry> list = Collections.emptyList();
                return list;
            }
            URI url = this.session.getSVNRootUrl(branches);
            SVN_ENTRY_TYPE[] list = this.session.listFolder(url, monitor);
            if (list.length == 0) {
                List<AbstractSCCSVersionFinder.RevisionEntry> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<AbstractSCCSVersionFinder.RevisionEntry> entries = new ArrayList<AbstractSCCSVersionFinder.RevisionEntry>(list.length);
            SVN_ENTRY_TYPE[] SVN_ENTRY_TYPEArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                SVN_ENTRY_TYPE e = SVN_ENTRY_TYPEArray[n2];
                String path = this.helper.getEntryPath(e);
                long revision = this.helper.getEntryRevisionNumber(e);
                entries.add(new AbstractSCCSVersionFinder.RevisionEntry(path, null, revision));
                ++n2;
            }
            ArrayList<AbstractSCCSVersionFinder.RevisionEntry> arrayList = entries;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract ISubversionSession<SVN_ENTRY_TYPE, SVN_REVISION_TYPE> getSession(String var1, VersionSelector var2, long var3, Date var5, RMContext var6) throws CoreException;

    protected final AbstractSCCSVersionFinder.RevisionEntry getTrunk(IProgressMonitor monitor) throws CoreException {
        SVN_ENTRY_TYPE entry = this.session.getRootEntry(monitor);
        return entry == null ? null : new AbstractSCCSVersionFinder.RevisionEntry(null, null, this.session.getSvnEntryHelper().getEntryRevisionNumber(entry));
    }
}

