/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.subversion;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.buckminster.runtime.Trivial;

public final class RepositoryAccess {
    private final URI svnURL;
    private final String user;
    private final String password;

    public RepositoryAccess(String str) throws URISyntaxException {
        int idx = str.indexOf(94);
        String _user = null;
        String _password = null;
        if (idx >= 0) {
            _user = str.substring(idx + 1);
            str = str.substring(0, idx);
            idx = _user.indexOf(64);
            if (idx >= 0) {
                _password = _user.substring(idx + 1);
                _user = _user.substring(0, idx);
            }
        }
        this.svnURL = new URI(str);
        this.user = _user;
        this.password = _password;
    }

    public RepositoryAccess(URI svnURL, String user, String password) {
        this.svnURL = svnURL;
        this.user = user;
        this.password = password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryAccess)) {
            return false;
        }
        RepositoryAccess that = (RepositoryAccess)o;
        return this.svnURL.equals(that.svnURL) && Trivial.equalsAllowNull((Object)this.user, (Object)that.user) && Trivial.equalsAllowNull((Object)this.password, (Object)that.password);
    }

    public String getPassword() {
        return this.password;
    }

    public URI getSvnURL() {
        return this.svnURL;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        int hash = this.svnURL.hashCode();
        if (this.user != null) {
            hash = hash * 31 + this.user.hashCode();
        }
        if (this.password != null) {
            hash = hash * 31 + this.password.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.user == null) {
            return this.svnURL.toString();
        }
        StringBuilder bld = new StringBuilder();
        bld.append(this.svnURL.toString());
        bld.append('^');
        bld.append(this.user);
        if (this.password != null) {
            bld.append('@');
            bld.append(this.password);
        }
        return bld.toString();
    }
}

