/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dependency.visualizer.controls;

import org.eclipse.buckminster.ui.dependency.visualizer.Messages;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.AbstractViewerSettingControl;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingChangeEvent;
import org.eclipse.buckminster.ui.dependency.visualizer.controls.listener.ViewerSettingType;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.filter.PlatformComponentsFilter;
import org.eclipse.buckminster.ui.dependency.visualizer.viewer.filter.RegExFilter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FilterControl
extends AbstractViewerSettingControl {
    private ViewerFilter platformFilter = new PlatformComponentsFilter();

    public FilterControl(FormToolkit toolkit) {
        super(toolkit);
    }

    public Control createControl(Composite parent) {
        Composite filterComposite = this.getWidgetToolkit().createComposite(parent);
        filterComposite.setLayout((Layout)new GridLayout(2, true));
        final Button filterPlatform = this.getWidgetToolkit().createButton(filterComposite, Messages.FilterTargetPlatform, 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)filterPlatform);
        filterPlatform.setSelection(true);
        filterPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (filterPlatform.getSelection()) {
                    FilterControl.this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent((Object)this, ViewerSettingType.FILTER_ADDED, FilterControl.this.platformFilter, null));
                } else {
                    FilterControl.this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent((Object)this, ViewerSettingType.FILTER_REMOVED, FilterControl.this.platformFilter, null));
                }
            }
        });
        this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent(this, ViewerSettingType.FILTER_ADDED, this.platformFilter, null));
        return filterComposite;
    }

    class RegExText
    implements Runnable,
    ModifyListener {
        private ViewerFilter regexFilter;
        private boolean isProcessing;
        private Text regex;
        private boolean invert;

        public RegExText(boolean invert) {
            this.invert = invert;
        }

        public void createControl(Composite parent) {
            if (this.invert) {
                FilterControl.this.getWidgetToolkit().createLabel(parent, Messages.Blacklist);
            } else {
                FilterControl.this.getWidgetToolkit().createLabel(parent, Messages.Whilelist);
            }
            this.regex = FilterControl.this.getWidgetToolkit().createText(parent, "", 2048);
            this.regex.addModifyListener((ModifyListener)this);
        }

        public void modifyText(ModifyEvent e) {
            if (!this.isProcessing) {
                e.display.timerExec(1000, (Runnable)this);
                this.isProcessing = true;
            }
        }

        public void run() {
            if (this.regexFilter != null) {
                FilterControl.this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent(FilterControl.this, ViewerSettingType.FILTER_REMOVED, this.regexFilter, null));
            }
            if (this.regex.getText() == null || this.regex.getText().length() == 0) {
                return;
            }
            this.regexFilter = new RegExFilter(this.regex.getText(), this.invert);
            FilterControl.this.fireViewerSettingsChangedEvent(new ViewerSettingChangeEvent(FilterControl.this, ViewerSettingType.FILTER_ADDED, this.regexFilter, null));
            this.isProcessing = false;
        }
    }
}

