/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui;

import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.metadata.model.Resolution;
import org.eclipse.buckminster.generic.plugin.PluginClassHandle;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.adapters.CSpecAdapterFactory;
import org.eclipse.buckminster.ui.adapters.CSpecDataNode;
import org.eclipse.buckminster.ui.adapters.ResolutionAdapterFactory;
import org.eclipse.buckminster.ui.adapters.ResolutionDataNode;
import org.eclipse.buckminster.ui.adapters.ResourceAdapterFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.BundleContext;

public class UiPlugin
extends AbstractUIPlugin {
    private static UiPlugin plugin;
    private ScopedPreferenceStore preferenceStore;
    private static ResourceAdapterFactory resourceAdapterFactory;
    private static CSpecAdapterFactory cspecAdapterFactory;
    private static ResolutionAdapterFactory resolutionAdapterFactory;
    private static final String id = "org.eclipse.buckminster.ui";
    public static final String themeId = "org.eclipse.buckminster.ui.theme";
    public static final String BUILDER_EDITORS_POINT = "org.eclipse.buckminster.ui.incrementalBuilderEditors";
    public static final String EPOINT_OPEN_FEED = "org.eclipse.buckminster.ui.OpenFeedAction";
    public static final String ATT_CLASS = "class";
    private static OpenRssFeedActionHandle openRssFeedActionHandle;

    public static UiPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return id;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)id, (String)path);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IStatus toStatus(Throwable t) {
        Object status = null;
        status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, UiPlugin.getID(), -1, t.getMessage(), t);
        return status;
    }

    public UiPlugin() {
        plugin = this;
    }

    public IPreferenceStore getBuckminsterPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.buckminster.runtime");
        }
        return this.preferenceStore;
    }

    public IPreferenceStore getBuckminsterPreferenceStore(String subKey) {
        return new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.buckminster.runtime/" + subKey);
    }

    public IObjectActionDelegate getOpenRssFeedAction() {
        if (openRssFeedActionHandle == null) {
            IExtensionPoint epoint = Platform.getExtensionRegistry().getExtensionPoint(EPOINT_OPEN_FEED);
            IExtension[] extensions = epoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    if (openRssFeedActionHandle != null) {
                        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), NLS.bind((String)Messages.duplicate_0_found_in_plugin_1, (Object)"OpenFeedAction", (Object)configElement.getDeclaringExtension().getNamespaceIdentifier())));
                    }
                    openRssFeedActionHandle = new OpenRssFeedActionHandle(configElement);
                    ++j;
                }
                ++i;
            }
        }
        return openRssFeedActionHandle == null ? null : (IObjectActionDelegate)openRssFeedActionHandle.getHandle();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        cspecAdapterFactory = new CSpecAdapterFactory();
        resolutionAdapterFactory = new ResolutionAdapterFactory();
        resourceAdapterFactory = new ResourceAdapterFactory();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        adapterManager.registerAdapters((IAdapterFactory)cspecAdapterFactory, CSpec.class);
        adapterManager.registerAdapters((IAdapterFactory)cspecAdapterFactory, CSpecDataNode.class);
        adapterManager.registerAdapters((IAdapterFactory)resolutionAdapterFactory, Resolution.class);
        adapterManager.registerAdapters((IAdapterFactory)resolutionAdapterFactory, ResolutionDataNode.class);
        adapterManager.registerAdapters((IAdapterFactory)resourceAdapterFactory, IResource.class);
        adapterManager.registerAdapters((IAdapterFactory)resourceAdapterFactory, IProject.class);
        adapterManager.registerAdapters((IAdapterFactory)resourceAdapterFactory, IFile.class);
    }

    public void stop(BundleContext context) throws Exception {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        adapterManager.unregisterAdapters((IAdapterFactory)cspecAdapterFactory);
        adapterManager.unregisterAdapters((IAdapterFactory)resolutionAdapterFactory);
        adapterManager.unregisterAdapters((IAdapterFactory)resolutionAdapterFactory);
        super.stop(context);
        plugin = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OpenRssFeedActionHandle
    extends PluginClassHandle<IObjectActionDelegate> {
        public OpenRssFeedActionHandle(IConfigurationElement configElement) {
            super((Plugin)plugin, configElement, IObjectActionDelegate.class, UiPlugin.EPOINT_OPEN_FEED);
        }
    }
}

