/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.buckminster.core.common.model.Documentation;
import org.eclipse.buckminster.core.cspec.model.Attribute;
import org.eclipse.buckminster.core.cspec.model.CSpec;
import org.eclipse.buckminster.core.cspec.model.Group;
import org.eclipse.buckminster.runtime.Trivial;
import org.eclipse.buckminster.ui.AbstractCSpecAction;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiPlugin;
import org.eclipse.buckminster.ui.dialogs.FileExtensionFilter;
import org.eclipse.buckminster.ui.dialogs.FileValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeActionDialog
extends FilteredItemsSelectionDialog {
    private boolean forceRebuild;
    public boolean onlyPublic;
    private String propertiesFile;
    private static Comparator<Attribute> attributeComparator = new Comparator<Attribute>(){

        @Override
        public int compare(Attribute o1, Attribute o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final String DIALOG_SETTINGS = "org.eclipse.buckminster.ui.dialogs.InvokeActionDialog";
    private static final String LAST_PROPERTIES = "last.properties";
    private Collection<Attribute> attributes;
    private AbstractCSpecAction cspecAction;

    public InvokeActionDialog(Shell shell, AbstractCSpecAction action) {
        this(shell, "", null);
        this.cspecAction = action;
    }

    public InvokeActionDialog(Shell shell, String title, Collection<Attribute> viableAttributes) {
        super(shell, true);
        this.attributes = viableAttributes;
        this.setListLabelProvider(new LabelProvider(null, null));
        this.setTitle(title);
        this.setMessage(Messages.select_actions_to_perform);
        this.setSeparatorLabel(Messages.available_attributes);
        this.setSelectionHistory(new AttributeSelectionHistory());
        this.setDetailsLabelProvider(new DetailsLabelProvider());
    }

    public String getElementName(Object item) {
        Attribute attribute = (Attribute)item;
        return attribute.getQualifiedName();
    }

    public File getPropertiesFile() {
        if (this.propertiesFile == null || this.propertiesFile.trim().length() == 0) {
            return null;
        }
        return new File(this.propertiesFile);
    }

    public List<Attribute> getSelectedAttributes() {
        Object[] selection = this.getResult();
        if (selection == null) {
            return null;
        }
        ArrayList<Attribute> selectedAttributes = new ArrayList<Attribute>(selection.length);
        int i = 0;
        while (i < selection.length) {
            selectedAttributes.add((Attribute)selection[i]);
            ++i;
        }
        return selectedAttributes;
    }

    public boolean isForceRebuild() {
        return this.forceRebuild;
    }

    protected Control createExtendedContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite, 64);
        label.setText(Messages.properties_file_with_colon);
        final CCombo combo = new CCombo(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)combo);
        String[] lastProperties = this.getDialogSettings().getArray(LAST_PROPERTIES);
        if (lastProperties != null) {
            ArrayList<String> storedPropertyFiles = new ArrayList<String>(Arrays.asList(lastProperties));
            Iterator it = storedPropertyFiles.iterator();
            while (it.hasNext()) {
                String propertyFile = (String)it.next();
                if (propertyFile != null) continue;
                it.remove();
            }
            if (!storedPropertyFiles.contains("")) {
                storedPropertyFiles.add("");
            }
            String[] temp = new String[storedPropertyFiles.size()];
            storedPropertyFiles.toArray(temp);
            lastProperties = temp;
        } else {
            lastProperties = new String[]{};
        }
        combo.setItems(lastProperties);
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InvokeActionDialog.this.propertiesFile = Trivial.trim((String)combo.getText());
            }
        });
        combo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InvokeActionDialog.this.propertiesFile = combo.getText();
                InvokeActionDialog.this.updateStatus(InvokeActionDialog.this.validateItem(InvokeActionDialog.this.propertiesFile));
            }
        });
        if (combo.getItemCount() > 0) {
            combo.select(0);
        }
        Button browse = new Button(composite, 8);
        browse.setText(Messages.filesystem);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(InvokeActionDialog.this.getShell(), 4096);
                String fileName = dialog.open();
                if (fileName == null) {
                    return;
                }
                int index = this.index(fileName);
                if (index < 0) {
                    combo.add(fileName);
                    index = combo.getItemCount() - 1;
                }
                combo.select(index);
            }

            private int index(String fileName) {
                String[] items = combo.getItems();
                int i = 0;
                while (i < items.length) {
                    String item = items[i];
                    if (fileName.equals(item)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
        Button browseWS = new Button(composite, 8);
        browseWS.setText(Messages.workspace);
        browseWS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] files;
                String fileName = null;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(InvokeActionDialog.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setValidator((ISelectionStatusValidator)new FileValidator());
                dialog.setAllowMultiple(true);
                dialog.setTitle(Messages.action_properties_file_selection);
                dialog.setMessage(Messages.select_action_properties_file);
                dialog.addFilter((ViewerFilter)new FileExtensionFilter("properties"));
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.create();
                if (dialog.open() == 0 && (files = dialog.getResult()).length > 0) {
                    fileName = ((IFile)files[0]).getLocation().toOSString();
                }
                if (fileName == null) {
                    return;
                }
                int index = this.index(fileName);
                if (index < 0) {
                    combo.add(fileName);
                    index = combo.getItemCount() - 1;
                }
                combo.select(index);
            }

            private int index(String fileName) {
                String[] items = combo.getItems();
                int i = 0;
                while (i < items.length) {
                    String item = items[i];
                    if (fileName.equals(item)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        });
        return composite;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new AttributeFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        CSpec cspec;
        if (this.attributes == null && (cspec = this.cspecAction.fetchCSpec(progressMonitor)) != null) {
            this.attributes = cspec.getAttributes().values();
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    InvokeActionDialog.this.getShell().setText(String.valueOf(Messages.actions_of) + cspec.getName());
                }
            });
        }
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                if (!itemsFilter.matchItem((Object)attribute)) continue;
                contentProvider.add((Object)attribute, itemsFilter);
            }
        }
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        menuManager.add((IAction)new ShowPrivateAttributesAction());
        menuManager.add((IAction)new ForceRebuildAction());
        super.fillViewMenu(menuManager);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = UiPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = UiPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected Comparator<?> getItemsComparator() {
        return attributeComparator;
    }

    protected void okPressed() {
        this.storeDialogPreferences();
        super.okPressed();
    }

    protected IStatus validateItem(Object item) {
        if (this.propertiesFile == null || this.propertiesFile.trim().length() == 0) {
            return Status.OK_STATUS;
        }
        File file = new File(this.propertiesFile);
        if (!file.exists()) {
            return new Status(4, UiPlugin.getID(), Messages.properties_file_does_not_exist);
        }
        if (!file.isFile()) {
            return new Status(4, UiPlugin.getID(), Messages.not_a_valid_file);
        }
        return Status.OK_STATUS;
    }

    private void storeDialogPreferences() {
        String[] lastProperties = this.getDialogSettings().getArray(LAST_PROPERTIES);
        ArrayList<Object> propertyList = lastProperties != null ? new ArrayList<String>(Arrays.asList(lastProperties)) : new ArrayList();
        if (propertyList.contains(this.propertiesFile)) {
            propertyList.remove(this.propertiesFile);
        }
        if (this.propertiesFile == null) {
            propertyList.remove("");
            propertyList.add(0, "");
        } else {
            propertyList.add(0, this.propertiesFile);
        }
        lastProperties = propertyList.subList(0, Math.min(5, propertyList.size())).toArray(new String[Math.min(5, propertyList.size())]);
        this.getDialogSettings().put(LAST_PROPERTIES, lastProperties);
    }

    private class AttributeFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public final boolean finalOnlyPublic;

        private AttributeFilter() {
            super((FilteredItemsSelectionDialog)InvokeActionDialog.this);
            this.finalOnlyPublic = InvokeActionDialog.this.onlyPublic;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
            AttributeFilter filter = (AttributeFilter)itemsFilter;
            if (this.isOnlyPublic() != filter.isOnlyPublic()) {
                return false;
            }
            return super.equalsFilter((FilteredItemsSelectionDialog.ItemsFilter)filter);
        }

        public String getPattern() {
            return String.valueOf(super.getPattern()) + "*";
        }

        public boolean isConsistentItem(Object item) {
            return InvokeActionDialog.this.attributes.contains(item);
        }

        public boolean isOnlyPublic() {
            return this.finalOnlyPublic;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter itemsFilter) {
            AttributeFilter filter = (AttributeFilter)itemsFilter;
            if (this.isOnlyPublic() != filter.isOnlyPublic()) {
                return false;
            }
            return super.isSubFilter((FilteredItemsSelectionDialog.ItemsFilter)filter);
        }

        public boolean matchItem(Object item) {
            boolean isPrivate;
            Attribute attrib = (Attribute)item;
            boolean bl = isPrivate = !attrib.isPublic();
            if (isPrivate && this.isOnlyPublic()) {
                return false;
            }
            return this.matches(attrib.getName());
        }
    }

    private class AttributeSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private AttributeSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            String attributeName = element.getString("attribute");
            if (attributeName == null || InvokeActionDialog.this.attributes == null) {
                return null;
            }
            for (Attribute attribute : InvokeActionDialog.this.attributes) {
                if (!attributeName.equals(attribute.getQualifiedName())) continue;
                return attribute;
            }
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            element.putString("attribute", item.toString());
        }
    }

    private class DetailsLabelProvider
    extends LabelProvider {
        private DetailsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Attribute) {
                Attribute attribute = (Attribute)element;
                Documentation documentation = attribute.getDocumentation();
                if (documentation == null) {
                    return attribute.getName();
                }
                return documentation.toString();
            }
            return element.toString();
        }
    }

    private class ForceRebuildAction
    extends Action {
        private static final String FORCE_REBUILD = "force.rebuild";

        public ForceRebuildAction() {
            super(Messages.force_complete_rebuild, 2);
            InvokeActionDialog.this.forceRebuild = InvokeActionDialog.this.getDialogSettings().getBoolean(FORCE_REBUILD);
            this.setChecked(InvokeActionDialog.this.forceRebuild);
        }

        public void run() {
            InvokeActionDialog.this.getDialogSettings().put(FORCE_REBUILD, this.isChecked());
            InvokeActionDialog.this.forceRebuild = this.isChecked();
        }
    }

    private class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider
    implements ILabelProvider {
        private Image privateGroup;
        private Image group;
        private Image privateAction;
        private Image action;

        private LabelProvider() {
        }

        public void dispose() {
            super.dispose();
            if (this.privateAction != null) {
                this.privateAction.dispose();
            }
            if (this.privateGroup != null) {
                this.privateGroup.dispose();
            }
            if (this.action != null) {
                this.action.dispose();
            }
            if (this.group != null) {
                this.group.dispose();
            }
        }

        public Image getImage(Object element) {
            if (element instanceof Attribute) {
                Attribute attribute = (Attribute)element;
                if (attribute.isPublic()) {
                    if (attribute instanceof Group) {
                        if (this.group == null) {
                            this.group = AbstractUIPlugin.imageDescriptorFromPlugin((String)UiPlugin.getID(), (String)"icons/group.gif").createImage();
                        }
                        return this.group;
                    }
                    if (this.action == null) {
                        this.action = AbstractUIPlugin.imageDescriptorFromPlugin((String)UiPlugin.getID(), (String)"icons/action.gif").createImage();
                    }
                    return this.action;
                }
                if (attribute instanceof Group) {
                    if (this.privateGroup == null) {
                        this.privateGroup = AbstractUIPlugin.imageDescriptorFromPlugin((String)UiPlugin.getID(), (String)"icons/private_group.gif").createImage();
                    }
                    return this.privateGroup;
                }
                if (this.privateAction == null) {
                    this.privateAction = AbstractUIPlugin.imageDescriptorFromPlugin((String)UiPlugin.getID(), (String)"icons/private_action.gif").createImage();
                }
                return this.privateAction;
            }
            return null;
        }

        public String getText(Object element) {
            if (element == null) {
                return "";
            }
            Attribute attribute = (Attribute)element;
            return attribute.getName();
        }

        /* synthetic */ LabelProvider(LabelProvider labelProvider, LabelProvider labelProvider2) {
            this();
        }
    }

    private class ShowPrivateAttributesAction
    extends Action {
        private static final String SHOW_PRIVATE = "show.private";

        public ShowPrivateAttributesAction() {
            super(Messages.show_private_attributes, 2);
            boolean showPrivate = InvokeActionDialog.this.getDialogSettings().getBoolean(SHOW_PRIVATE);
            InvokeActionDialog.this.onlyPublic = !showPrivate;
            this.setChecked(showPrivate);
        }

        public void run() {
            InvokeActionDialog.this.getDialogSettings().put(SHOW_PRIVATE, this.isChecked());
            InvokeActionDialog.this.onlyPublic = !this.isChecked();
            InvokeActionDialog.this.applyFilter();
        }
    }
}

