/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import org.eclipse.buckminster.download.DownloadManager;
import org.eclipse.buckminster.runtime.IOUtils;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.editor.ArtifactType;
import org.eclipse.buckminster.ui.editor.DerivedExternalFileEditorInput;
import org.eclipse.buckminster.ui.editor.ExternalFileEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IURIEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorUtils {
    private static Comparator<IPath> pathComparator = new PathComparator();

    public static Label createHeaderLabel(Composite parent, String headerText, int horizontalSpan) {
        Label label = UiUtils.createGridLabel(parent, headerText, horizontalSpan, 0, 0);
        label.setForeground(parent.getDisplay().getSystemColor(9));
        return label;
    }

    public static ExternalFileEditorInput getExternalFileEditorInput(IURIEditorInput input, ArtifactType artifactType) throws CoreException, IOException {
        URI uri = input.getURI();
        URL url = uri.toURL();
        String protocol = url.getProtocol();
        File cspecFile = null;
        if (protocol == null || "file".equals(protocol)) {
            cspecFile = new File(uri);
        }
        if (cspecFile == null || !cspecFile.canWrite()) {
            cspecFile = File.createTempFile(artifactType.getTempPrefix(), artifactType.getTempExtension());
            cspecFile.deleteOnExit();
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(cspecFile);
                DownloadManager.readInto((URL)url, null, (OutputStream)os, null);
            }
            catch (Throwable throwable) {
                IOUtils.close(os);
                throw throwable;
            }
            IOUtils.close((Closeable)os);
        }
        return new DerivedExternalFileEditorInput((IEditorInput)input, cspecFile, new Path(uri.getPath()).lastSegment(), url.toString());
    }

    public static Composite getNamedTabComposite(Composite parent, String header) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite tabComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)tabComposite);
        tabComposite.setLayout((Layout)new GridLayout(1, true));
        tabComposite.setBackground(parent.getDisplay().getSystemColor(1));
        tabComposite.setBackgroundMode(2);
        Label headerLabel = new Label(tabComposite, 1);
        headerLabel.setText(header);
        headerLabel.setForeground(parent.getDisplay().getSystemColor(9));
        FontData fontData = new FontData();
        fontData.setHeight(14);
        headerLabel.setFont(new Font((Device)tabComposite.getDisplay(), fontData));
        GridData gridData = new GridData(4, 4, false, false);
        gridData.heightHint = 30;
        headerLabel.setLayoutData((Object)gridData);
        return tabComposite;
    }

    public static Control getOptimizedControl(Composite composite) {
        if (composite.getParent() instanceof ScrolledComposite) {
            ScrolledComposite container = (ScrolledComposite)composite.getParent();
            container.setMinSize(composite.computeSize(-1, -1, true));
            return container;
        }
        return composite;
    }

    public static Comparator<IPath> getPathComparator() {
        return pathComparator;
    }

    private EditorUtils() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PathComparator
    implements Comparator<IPath> {
        PathComparator() {
        }

        @Override
        public int compare(IPath o1, IPath o2) {
            return o1.toOSString().compareTo(o2.toOSString());
        }
    }
}

