/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.editor.cspec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.buckminster.core.cspec.builder.ActionArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.ActionBuilder;
import org.eclipse.buckminster.core.cspec.builder.ArtifactBuilder;
import org.eclipse.buckminster.core.cspec.builder.GroupBuilder;
import org.eclipse.buckminster.core.cspec.builder.TopLevelAttributeBuilder;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditor;
import org.eclipse.buckminster.ui.editor.cspec.CSpecEditorUtils;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AllAttributesView
extends Composite {
    private static final String[] TABLE_TITLES = new String[]{Messages.name, Messages.type, Messages.public_label};
    private static final int[] TABLE_WEIGHTS = new int[]{60, 20, 20};
    private CSpecEditor cspecEditor;
    private TableViewer tableViewer;
    private List<TopLevelAttributeBuilder> table = new ArrayList<TopLevelAttributeBuilder>();
    private Map<ActionArtifactBuilder, ActionBuilder> aaMap = new HashMap<ActionArtifactBuilder, ActionBuilder>();
    private int lastSelectedRow = -1;

    public AllAttributesView(Composite parent, int style, CSpecEditor editor) {
        super(parent, style);
        this.cspecEditor = editor;
        this.initComposite();
    }

    public void refresh() {
        this.table.clear();
        this.table.addAll(this.cspecEditor.getActionBuilders());
        for (ActionBuilder actionBuilder : this.cspecEditor.getActionArtifactBuilders().keySet()) {
            for (ActionArtifactBuilder actionArtifactBuilder : this.cspecEditor.getActionArtifactBuilders().get(actionBuilder)) {
                this.table.add((TopLevelAttributeBuilder)actionArtifactBuilder);
                this.aaMap.put(actionArtifactBuilder, actionBuilder);
            }
        }
        this.table.addAll(this.cspecEditor.getArtifactBuilders());
        this.table.addAll(this.cspecEditor.getGroupBuilders());
        Collections.sort(this.table, CSpecEditorUtils.getAttributeComparator());
        this.tableViewer.setInput(this.table);
        if (this.getSelectionIndex() == -1 && this.table.size() > 0) {
            if (this.lastSelectedRow == -1) {
                this.tableViewer.getTable().setSelection(0);
            } else {
                if (this.lastSelectedRow >= this.table.size()) {
                    this.lastSelectedRow = this.table.size() - 1;
                }
                this.tableViewer.getTable().setSelection(this.lastSelectedRow);
            }
        }
        if (this.getSelectionIndex() != -1) {
            this.lastSelectedRow = this.getSelectionIndex();
        }
    }

    public boolean setFocus() {
        return this.tableViewer.getTable().setFocus();
    }

    protected void initComposite() {
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        this.setLayout((Layout)topLayout);
        this.setLayoutData(new GridData(4, 4, true, true));
        Table tbl = new Table((Composite)this, 68356);
        Button detailButton = new Button((Composite)this, 8);
        detailButton.setText(Messages.show_details);
        detailButton.setLayoutData((Object)new GridData(1, 1, false, false));
        detailButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AllAttributesView.this.show((TopLevelAttributeBuilder)AllAttributesView.this.table.get(AllAttributesView.this.tableViewer.getTable().getSelectionIndex()));
            }
        });
        tbl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AllAttributesView.this.refresh();
            }

            public void focusLost(FocusEvent e) {
                AllAttributesView.this.updateLastSelectedRow();
            }
        });
        tbl.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int tableIdx = 0;
        int idx = 0;
        while (idx < 3) {
            TableColumn tableColumn = new TableColumn(tbl, 16384, tableIdx);
            tableColumn.setText(TABLE_TITLES[idx]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(TABLE_WEIGHTS[idx], true));
            ++tableIdx;
            ++idx;
        }
        tbl.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        tbl.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(tbl);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setInput((Object)tbl);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (AllAttributesView.this.tableViewer.getTable().getSelectionIndex() >= 0) {
                    AllAttributesView.this.show((TopLevelAttributeBuilder)AllAttributesView.this.table.get(AllAttributesView.this.tableViewer.getTable().getSelectionIndex()));
                }
            }
        });
    }

    private int getSelectionIndex() {
        return this.tableViewer.getTable().getSelectionIndex();
    }

    private void show(TopLevelAttributeBuilder builder) {
        if (builder instanceof ActionBuilder) {
            if (this.cspecEditor.getActionsEditor().show((ActionBuilder)builder, Messages.general)) {
                this.cspecEditor.switchTab(CSpecEditor.CSpecEditorTab.ACTIONS);
            }
        } else if (builder instanceof ActionArtifactBuilder) {
            if (this.cspecEditor.getActionsEditor().show(this.aaMap.get(builder), Messages.products)) {
                this.cspecEditor.switchTab(CSpecEditor.CSpecEditorTab.ACTIONS);
                this.cspecEditor.getActionsTable().showProductArtifact((ArtifactBuilder)((ActionArtifactBuilder)builder));
            }
        } else if (builder instanceof ArtifactBuilder) {
            if (this.cspecEditor.getArtifactsEditor().show((ArtifactBuilder)builder, Messages.general)) {
                this.cspecEditor.switchTab(CSpecEditor.CSpecEditorTab.ARTIFACTS);
            }
        } else if (builder instanceof GroupBuilder && this.cspecEditor.getGroupsEditor().show((GroupBuilder)builder, Messages.general)) {
            this.cspecEditor.switchTab(CSpecEditor.CSpecEditorTab.GROUPS);
        }
    }

    private void updateLastSelectedRow() {
        if (this.getSelectionIndex() != -1) {
            this.lastSelectedRow = this.getSelectionIndex();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return AllAttributesView.this.table.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((TopLevelAttributeBuilder)element).getName();
                }
                case 1: {
                    return this.getAttributeType((TopLevelAttributeBuilder)element);
                }
                case 2: {
                    return Boolean.valueOf(((TopLevelAttributeBuilder)element).isPublic()).toString();
                }
            }
            return "";
        }

        private String getAttributeType(TopLevelAttributeBuilder builder) {
            if (builder instanceof ActionBuilder) {
                return Messages.action;
            }
            if (builder instanceof ActionArtifactBuilder) {
                return Messages.product_artifact;
            }
            if (builder instanceof ArtifactBuilder) {
                return Messages.artifact;
            }
            if (builder instanceof GroupBuilder) {
                return Messages.group;
            }
            return "";
        }
    }
}

