/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.general.editor.structured;

import org.eclipse.buckminster.ui.Messages;
import org.eclipse.buckminster.ui.UiUtils;
import org.eclipse.buckminster.ui.general.editor.ValidatorException;
import org.eclipse.buckminster.ui.general.editor.structured.IStructuredTable;
import org.eclipse.buckminster.ui.internal.DynamicTableLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructuredTableEditor<T>
extends Composite {
    private static final int DONT_SAVE = -99;
    private final IStructuredTable<T> table;
    private final boolean swapButtonsFlag;
    private TableViewer tableViewer;
    private int lastSelectedRow = -1;
    private int lastEditedRow = -1;
    private Composite stackButtonComposite;
    private StackLayout stackButtonLayout;
    private Composite editButtonBox;
    private Composite viewButtonBox;
    private Button newButton;
    private Button editButton;
    private Button viewButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Tree stackOptions;
    private StackLayout stackLayout;
    private Composite stackComposite;
    private boolean enabled = true;

    public StructuredTableEditor(Composite parent, IStructuredTable<T> table, boolean swapButtonsFlag, int style) {
        super(parent, style);
        this.table = table;
        this.swapButtonsFlag = swapButtonsFlag;
        this.initComposite();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public abstract void refresh();

    public boolean selectRow(T row) {
        int idx = this.table.getRows().indexOf(row);
        if (idx == -1) {
            return false;
        }
        this.tableViewer.getTable().setSelection(idx);
        this.updateLastRow();
        return true;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.enableDisableButtonGroup();
    }

    protected void createStack(Composite parent) {
        this.stackComposite = new Composite(parent, 0);
        this.stackComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackLayout.marginHeight = 0;
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.table.fillStackComposite(this.stackComposite);
    }

    protected void createStackOptions(Composite parent) {
        this.stackOptions = new Tree(parent, 2048);
        this.stackOptions.setLayoutData((Object)new GridData(4, 4, false, true));
        this.stackOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item != null) {
                    TreeItem item = (TreeItem)e.item;
                    ((StructuredTableEditor)StructuredTableEditor.this).stackLayout.topControl = StructuredTableEditor.this.table.getStackControl(item.getText());
                    StructuredTableEditor.this.stackComposite.layout();
                    StructuredTableEditor.this.focusStackComposite();
                }
            }
        });
    }

    protected void createTableButtons(Composite parent) {
        this.stackButtonComposite = new Composite(parent, 0);
        this.stackButtonComposite.setLayoutData((Object)new GridData(1, 1, false, false));
        this.stackButtonLayout = new StackLayout();
        this.stackButtonLayout.marginWidth = 0;
        this.stackButtonLayout.marginHeight = 0;
        this.stackButtonComposite.setLayout((Layout)this.stackButtonLayout);
        this.editButtonBox = new Composite(this.stackButtonComposite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.editButtonBox.setLayout((Layout)gridLayout);
        this.editButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.newButton = UiUtils.createPushButton(this.editButtonBox, Messages.new_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.newRow();
            }
        });
        this.newButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.editButton = UiUtils.createPushButton(this.editButtonBox, Messages.edit, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.editRow(false, false);
            }
        });
        this.editButton.setLayoutData((Object)new GridData(4, 1, true, false));
        this.removeButton = UiUtils.createPushButton(this.editButtonBox, Messages.remove, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.removeRow();
            }
        });
        this.removeButton.setLayoutData((Object)new GridData(4, 1, true, false));
        if (this.swapButtonsFlag) {
            this.moveUpButton = UiUtils.createPushButton(this.editButtonBox, Messages.move_up, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StructuredTableEditor.this.swapAndReselect(0, -1);
                }
            });
            this.moveUpButton.setLayoutData((Object)new GridData(4, 1, true, false));
            this.moveDownButton = UiUtils.createPushButton(this.editButtonBox, Messages.move_down, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StructuredTableEditor.this.swapAndReselect(1, 0);
                }
            });
            this.moveDownButton.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.viewButtonBox = new Composite(this.stackButtonComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.viewButtonBox.setLayout((Layout)gridLayout);
        this.viewButtonBox.setLayoutData((Object)new GridData(1, 1, false, false));
        this.viewButton = UiUtils.createPushButton(this.viewButtonBox, Messages.view, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredTableEditor.this.editRow(false, true);
            }
        });
        this.viewButton.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected void createTableGroup(Composite parent) {
        Composite componentTableGroup = this.createTableGroupComposite(parent);
        Table tbl = new Table(componentTableGroup, 68356);
        tbl.setHeaderVisible(true);
        DynamicTableLayout layout = new DynamicTableLayout(50);
        int tableIdx = 0;
        int idx = 0;
        while (idx < this.table.getTableViewerColumns()) {
            if (this.table.getTableViewerColumnWeights()[idx] > 0) {
                TableColumn tableColumn = new TableColumn(tbl, 16384, tableIdx);
                tableColumn.setText(this.table.getTableViewerColumnHeaders()[idx]);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.table.getTableViewerColumnWeights()[idx], true));
                ++tableIdx;
            }
            ++idx;
        }
        tbl.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        tbl.setLayoutData((Object)gridData);
        this.tableViewer = new TableViewer(tbl);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setInput(this.table);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredTableEditor.this.rowSelection();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (StructuredTableEditor.this.tableViewer.getTable().getSelectionIndex() >= 0) {
                    StructuredTableEditor.this.editRow(false, !StructuredTableEditor.this.enabled || StructuredTableEditor.this.table.isReadOnly());
                }
            }
        });
        this.createTableButtons(componentTableGroup);
    }

    protected abstract Composite createTableGroupComposite(Composite var1);

    protected abstract void editRow(boolean var1, boolean var2);

    protected void enableDisableButtonGroup() {
        Table tbl = this.getTableViewer().getTable();
        int top = tbl.getItemCount();
        int idx = this.getSelectionIndex();
        if (this.isEnabled() && !this.table.isReadOnly()) {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(idx >= 0);
            this.removeButton.setEnabled(idx >= 0);
            if (this.isSwapButtonAllowed()) {
                this.moveUpButton.setEnabled(idx > 0);
                this.moveDownButton.setEnabled(idx >= 0 && idx < top - 1);
            }
            this.stackButtonLayout.topControl = this.editButtonBox;
        } else {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            if (this.isSwapButtonAllowed()) {
                this.moveUpButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
            }
            this.stackButtonLayout.topControl = this.viewButtonBox;
        }
        this.viewButton.setEnabled(idx >= 0);
        this.stackButtonComposite.layout();
    }

    protected void enableFields(boolean flag) {
        this.table.enableFields(flag);
    }

    protected void fillStackOptions() {
        for (String stackKey : this.table.getStackKeys()) {
            TreeItem item = new TreeItem(this.stackOptions, 0);
            item.setText(stackKey);
        }
    }

    protected void focusStackComposite() {
        Control focusControl = (Control)this.stackLayout.topControl.getData("focusControl");
        if (focusControl != null) {
            focusControl.setFocus();
        }
    }

    protected Button getEditButton() {
        return this.editButton;
    }

    protected int getLastEditedRow() {
        return this.lastEditedRow;
    }

    protected int getLastSelectedRow() {
        return this.lastSelectedRow;
    }

    protected Button getMoveDownButton() {
        return this.moveDownButton;
    }

    protected Button getMoveUpButton() {
        return this.moveUpButton;
    }

    protected Button getNewButton() {
        return this.newButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected int getSelectionIndex() {
        return this.tableViewer.getTable().getSelectionIndex();
    }

    protected IStructuredTable<T> getTable() {
        return this.table;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    protected Button getViewButton() {
        return this.viewButton;
    }

    protected abstract void initComposite();

    protected boolean isSwapButtonAllowed() {
        return this.swapButtonsFlag;
    }

    protected abstract void newRow();

    protected void refreshRow() {
        this.table.refreshRow(this.getSelectionIndex());
        if (this.stackOptions.getSelectionCount() == 0) {
            this.setStackOption(0);
        }
    }

    protected void refreshTable() {
        this.table.refresh();
        this.tableViewer.setInput(this.table);
        if (this.getSelectionIndex() == -1 && this.table.getRows().size() > 0) {
            if (this.lastSelectedRow == -1) {
                this.tableViewer.getTable().setSelection(0);
            } else {
                if (this.lastSelectedRow >= this.table.getRows().size()) {
                    this.lastSelectedRow = this.table.getRows().size() - 1;
                }
                this.tableViewer.getTable().setSelection(this.lastSelectedRow);
            }
        }
        this.updateLastRow();
    }

    protected void removeRow() {
        int row = this.getSelectionIndex();
        if (row != -1) {
            this.table.removeRow(row);
            this.lastEditedRow = -99;
            this.refresh();
        }
    }

    protected abstract boolean rowSelectionEvent();

    protected void saveRow() throws ValidatorException {
        if (this.lastEditedRow == -99) {
            return;
        }
        this.table.save(this.lastEditedRow);
        this.refresh();
        this.enableDisableButtonGroup();
    }

    protected void setEditButton(Button editButton) {
        this.editButton = editButton;
    }

    protected void setMoveDownButton(Button moveDownButton) {
        this.moveDownButton = moveDownButton;
    }

    protected void setMoveUpButton(Button moveUpButton) {
        this.moveUpButton = moveUpButton;
    }

    protected void setNewButton(Button newButton) {
        this.newButton = newButton;
    }

    protected void setRemoveButton(Button removeButton) {
        this.removeButton = removeButton;
    }

    protected void setStackOption(int idx) {
        String stackKey = this.table.getStackKeys().get(idx);
        this.stackOptions.setSelection(this.stackOptions.getItem(idx));
        this.stackLayout.topControl = this.table.getStackControl(stackKey);
        this.stackComposite.layout();
    }

    protected void setViewButton(Button viewButton) {
        this.viewButton = viewButton;
    }

    protected void swapAndReselect(int idxOffset, int selectionOffset) {
        if (this.table.swapRows(this.getSelectionIndex(), idxOffset)) {
            this.refresh();
            Table tbl = this.tableViewer.getTable();
            int idx = tbl.getSelectionIndex() + idxOffset;
            tbl.select(idx + selectionOffset);
            this.enableDisableButtonGroup();
        }
    }

    protected void updateLastRow() {
        if (this.getSelectionIndex() != -1) {
            this.lastSelectedRow = this.getSelectionIndex();
        }
        this.lastEditedRow = this.getSelectionIndex();
    }

    private void rowSelection() {
        if (this.rowSelectionEvent()) {
            this.updateLastRow();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return StructuredTableEditor.this.table.getRows().toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object field = StructuredTableEditor.this.table.getTableViewerField(element, columnIndex);
            return field == null ? "" : field.toString();
        }
    }
}

