/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buckminster.ui.internal;

import java.util.ArrayList;
import org.eclipse.buckminster.ui.Messages;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class DynamicTableLayout
extends Layout {
    private static final int COLUMN_TRIM = "carbon".equals(SWT.getPlatform()) ? 24 : 3;
    private final ArrayList<ColumnLayoutData> columns = new ArrayList();
    private final int minimumHeight;

    public DynamicTableLayout(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public void addColumnData(ColumnLayoutData data) {
        if (!(data instanceof ColumnPixelData) && !(data instanceof ColumnWeightData)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.unknown_0_derivate, (Object)"ColumnLayoutData"));
        }
        this.columns.add(data);
    }

    public Point computeSize(Composite c, int wHint, int hHint, boolean flush) {
        Point result;
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Table table = (Table)c;
        table.setLayout(null);
        try {
            result = table.computeSize(wHint, hHint, flush);
        }
        finally {
            table.setLayout((Layout)this);
        }
        int width = 0;
        for (ColumnLayoutData layoutData : this.columns) {
            ColumnPixelData col;
            if (layoutData instanceof ColumnPixelData) {
                col = (ColumnPixelData)layoutData;
                width += col.width;
                if (!col.addTrim) continue;
                width += COLUMN_TRIM;
                continue;
            }
            col = (ColumnWeightData)layoutData;
            width += col.minimumWidth;
        }
        if (width > result.x) {
            result.x = width;
        }
        if (this.minimumHeight > result.y) {
            result.y = this.minimumHeight;
        }
        return result;
    }

    public void layout(Composite c, boolean flush) {
        Table table = (Table)c;
        int width = table.getClientArea().width;
        if (width <= 1) {
            return;
        }
        ScrollBar vScroll = table.getVerticalBar();
        if (vScroll != null && !vScroll.isEnabled()) {
            width += vScroll.getSize().x;
        }
        TableColumn[] tableColumns = table.getColumns();
        int size = Math.min(this.columns.size(), tableColumns.length);
        int[] widths = new int[size];
        int fixedWidth = 0;
        int numberOfWeightColumns = 0;
        int totalWeight = 0;
        int idx = 0;
        while (idx < size) {
            ColumnLayoutData col = this.columns.get(idx);
            if (col instanceof ColumnPixelData) {
                ColumnPixelData cpd = (ColumnPixelData)col;
                int pixels = cpd.width;
                if (cpd.addTrim) {
                    pixels += COLUMN_TRIM;
                }
                widths[idx] = pixels;
                fixedWidth += pixels;
            } else {
                ++numberOfWeightColumns;
                totalWeight += ((ColumnWeightData)col).weight;
            }
            ++idx;
        }
        if (numberOfWeightColumns > 0) {
            int rest = width - fixedWidth;
            int totalDistributed = 0;
            int idx2 = 0;
            while (idx2 < size) {
                ColumnLayoutData col = this.columns.get(idx2);
                if (col instanceof ColumnWeightData) {
                    int pixels;
                    ColumnWeightData cw = (ColumnWeightData)col;
                    int weight = cw.weight;
                    int n = pixels = totalWeight == 0 ? 0 : weight * rest / totalWeight;
                    if (pixels < cw.minimumWidth) {
                        pixels = cw.minimumWidth;
                    }
                    totalDistributed += pixels;
                    widths[idx2] = pixels;
                }
                ++idx2;
            }
            int diff = rest - totalDistributed;
            int idx3 = 0;
            while (diff > 0) {
                ColumnLayoutData col;
                if (idx3 == size) {
                    idx3 = 0;
                }
                if ((col = this.columns.get(idx3)) instanceof ColumnWeightData) {
                    int n = idx3;
                    widths[n] = widths[n] + 1;
                    --diff;
                }
                ++idx3;
            }
        }
        idx = 0;
        while (idx < size) {
            tableColumns[idx].setWidth(widths[idx]);
            ++idx;
        }
    }
}

