/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.ICProjectConverter;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.XmlUtil;
import org.eclipse.cdt.internal.core.envvar.ContributedEnvironment;
import org.eclipse.cdt.internal.core.settings.model.AbstractCProjectDescriptionStorage;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescription;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionManager;
import org.eclipse.cdt.internal.core.settings.model.CProjectDescriptionStorageManager;
import org.eclipse.cdt.internal.core.settings.model.ExceptionFactory;
import org.eclipse.cdt.internal.core.settings.model.ICProjectDescriptionStorageType;
import org.eclipse.cdt.internal.core.settings.model.SettingsContext;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.cdt.internal.core.settings.model.xml.InternalXmlStorageElement;
import org.eclipse.cdt.internal.core.settings.model.xml.XmlStorage;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlProjectDescriptionStorage
extends AbstractCProjectDescriptionStorage {
    public static final int INTERNAL_GET_IGNORE_CLOSE = Integer.MIN_VALUE;
    private static final String OLD_PROJECT_DESCRIPTION = "cdtproject";
    private static final String OLD_CDTPROJECT_FILE_NAME = ".cdtproject";
    private static final String OLD_PROJECT_OWNER_ID = "id";
    private static final String CONVERTED_CFG_NAME = "convertedConfig";
    private static final String CONVERTED_CFG_ID_PREFIX = "converted.config";
    public static final Version STORAGE_DESCRIPTION_VERSION = new Version("4.0");
    public static final String STORAGE_TYPE_ID = "org.eclipse.cdt.core.XmlProjectDescriptionStorage";
    static final String MODULE_ID = "org.eclipse.cdt.core.settings";
    static final String CONFIGURATION = "cconfiguration";
    private static final QualifiedName LOAD_FLAG = new QualifiedName("org.eclipse.cdt.core", "descriptionLoadded");
    private volatile Reference<ICProjectDescription> fProjectDescription = new SoftReference<Object>(null);
    private volatile long projectModificaitonStamp = -1L;
    private final ILock serializingLock = Job.getJobManager().newLock();

    public XmlProjectDescriptionStorage(ICProjectDescriptionStorageType.CProjectDescriptionStorageTypeProxy type, IProject project, Version version) {
        super(type, project, version);
    }

    public ICSettingsStorage getStorageForElement(ICStorageElement element) throws CoreException {
        return new XmlStorage((InternalXmlStorageElement)element);
    }

    public final ICProjectDescription getProjectDescription(int flags, IProgressMonitor monitor) throws CoreException {
        boolean creatingState;
        boolean create;
        boolean empty;
        boolean write;
        ICProjectDescription des;
        block18: {
            des = null;
            write = XmlProjectDescriptionStorage.checkFlags(flags, 4);
            boolean load = !XmlProjectDescriptionStorage.checkFlags(flags, 8);
            empty = XmlProjectDescriptionStorage.checkFlags(flags, 16);
            boolean ignoreClose = XmlProjectDescriptionStorage.checkFlags(flags, Integer.MIN_VALUE);
            create = XmlProjectDescriptionStorage.checkFlags(flags, 32);
            creatingState = XmlProjectDescriptionStorage.checkFlags(flags, 64);
            SettingsContext context = null;
            des = super.getProjectDescription(flags, monitor);
            if (des == null) {
                boolean released = false;
                try {
                    load |= this.checkExternalModification();
                    this.serializingLock.acquire();
                    if (ignoreClose || this.project.isOpen()) {
                        des = this.getLoadedDescription();
                    }
                    if (empty || des != null || !load || !this.project.isOpen()) break block18;
                    try {
                        des = this.loadProjectDescription(this.project);
                    }
                    catch (CoreException coreException) {}
                    if (des == null) {
                        try {
                            context = new SettingsContext(this.project);
                            des = this.getConvertedDescription(context);
                        }
                        catch (CoreException e) {
                            CCorePlugin.log(e);
                        }
                    }
                    if (des != null && this.setLoaddedDescriptionOnLoad(this.project, des)) {
                        this.serializingLock.release();
                        released = true;
                        if (context != null) {
                            this.saveConversion(this.project, context, (CProjectDescription)des, (IProgressMonitor)new NullProgressMonitor());
                        }
                        XmlProjectDescriptionStorage.fireLoadedEvent(des);
                        des = this.getLoadedDescription();
                    }
                }
                finally {
                    if (!released) {
                        this.serializingLock.release();
                    }
                }
            }
        }
        if (empty || des == null && create) {
            if (creatingState && des != null) {
                creatingState = des.isCdtProjectCreating();
            }
            try {
                InternalXmlStorageElement element = this.createStorage((IContainer)this.project, ".cproject", false, true, false);
                return new CProjectDescription(this.project, new XmlStorage(element), element, false, creatingState);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        if (des != null && write) {
            des = this.createWritableDescription((CProjectDescription)des);
        }
        return des;
    }

    protected synchronized boolean checkExternalModification() {
        long currentModificationStamp = this.getModificationStamp((IResource)this.project.getFile(".cproject"));
        if (this.projectModificaitonStamp != currentModificationStamp) {
            this.setCurrentDescription(null, true);
            this.projectModificaitonStamp = currentModificationStamp;
            return true;
        }
        return false;
    }

    protected long getModificationStamp(IResource resource) {
        return resource.getModificationStamp() + resource.getLocalTimeStamp();
    }

    private CProjectDescription createWritableDescription(CProjectDescription cache) {
        CProjectDescription des = null;
        try {
            InternalXmlStorageElement el = (InternalXmlStorageElement)cache.getRootStorageElement();
            el = this.copyElement(el, false);
            des = new CProjectDescription(cache, false, new XmlStorage(el), el, cache.isCdtProjectCreating());
            XmlProjectDescriptionStorage.fireCopyCreatedEvent(des, cache);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return des;
    }

    private boolean setLoaddedDescriptionOnLoad(IProject project, ICProjectDescription des) {
        des.setSessionProperty(LOAD_FLAG, Boolean.TRUE);
        ICProjectDescription oldDes = this.getLoadedDescription();
        this.setCurrentDescription(des, true);
        if (oldDes == null) {
            return true;
        }
        return oldDes.getSessionProperty(LOAD_FLAG) == null;
    }

    public boolean setCurrentDescription(ICProjectDescription des, boolean overwriteIfExists) {
        if (!overwriteIfExists && this.fProjectDescription.get() != null) {
            return false;
        }
        if (des != null) {
            if (this.project.exists() && this.project.isOpen()) {
                this.fProjectDescription = new SoftReference<ICProjectDescription>(des);
            } else {
                Status status = new Status(4, "org.eclipse.cdt.core", -1, SettingsModelMessages.getString("CProjectDescriptionManager.16"), null);
                CCorePlugin.log(new CoreException((IStatus)status));
            }
        } else {
            this.fProjectDescription = new SoftReference<Object>(null);
        }
        return true;
    }

    private Object[] loadProjectDescriptionFromOldstyleStorage() throws CoreException {
        ICStorageElement rootEl = this.readOldCDTProjectFile(this.project);
        if (rootEl != null) {
            String ownerId = rootEl.getAttribute(OLD_PROJECT_OWNER_ID);
            CProjectDescription des = (CProjectDescription)CProjectDescriptionManager.getInstance().createProjectDescription(this.project, false);
            String id = CDataUtil.genId(CONVERTED_CFG_ID_PREFIX);
            des.createConvertedConfiguration(id, CONVERTED_CFG_NAME, rootEl);
            return new Object[]{ownerId, des};
        }
        return null;
    }

    private ICProjectDescription getConvertedDescription(SettingsContext context) throws CoreException {
        CProjectDescription des;
        block8: {
            Object[] info = this.loadProjectDescriptionFromOldstyleStorage();
            des = null;
            String ownerId = null;
            try {
                CProjectDescription convertedDes;
                if (info != null) {
                    ownerId = (String)info[0];
                    des = (CProjectDescription)info[1];
                    this.setThreadLocalProjectDesc(des);
                    des.setLoading(true);
                }
                IProjectDescription eDes = context.getEclipseProjectDescription();
                ICProjectConverter converter = CProjectDescriptionManager.getInstance().getConverter(this.project, ownerId, des);
                if (converter != null && (convertedDes = (CProjectDescription)converter.convertProject(this.project, eDes, ownerId, des)) != null) {
                    CProjectDescriptionManager.getInstance().checkHandleActiveCfgChange(convertedDes, null, eDes, (IProgressMonitor)new NullProgressMonitor());
                    des = convertedDes;
                }
                if (des == null || !des.isValid()) break block8;
                InternalXmlStorageElement el = null;
                context.setEclipseProjectDescription(eDes);
                try {
                    el = this.copyElement(des.getRootStorageElement(), false);
                }
                catch (CoreException coreException) {}
                des = new CProjectDescription(des, true, new XmlStorage(el), el, des.isCdtProjectCreating());
                this.setThreadLocalProjectDesc(des);
                des.applyDatas(context);
                des.doneApplying();
            }
            finally {
                this.setThreadLocalProjectDesc(null);
                if (des != null) {
                    des.setLoading(false);
                }
            }
        }
        return des;
    }

    private void saveConversion(IProject proj, SettingsContext context, CProjectDescription des, IProgressMonitor monitor) {
        try {
            context.addWorkspaceRunnable(this.createDesSerializationRunnable());
        }
        catch (CoreException e1) {
            CCorePlugin.log(e1);
        }
        IWorkspaceRunnable toRun = context.createOperationRunnable();
        if (toRun != null) {
            CProjectDescriptionManager.runWspModification(toRun, monitor);
        }
    }

    public ICProjectDescription getLoadedDescription() {
        return this.fProjectDescription.get();
    }

    protected ICProjectDescription loadProjectDescription(IProject project) throws CoreException {
        try {
            this.serializingLock.acquire();
            if (!this.checkExternalModification() && this.getLoadedDescription() != null) {
                ICProjectDescription iCProjectDescription = this.getLoadedDescription();
                return iCProjectDescription;
            }
            InternalXmlStorageElement storage = this.createStorage((IContainer)project, ".cproject", true, false, false);
            try {
                this.projectModificaitonStamp = this.getModificationStamp((IResource)project.getFile(".cproject"));
                CProjectDescription des = new CProjectDescription(project, new XmlStorage(storage), storage, true, false);
                try {
                    this.setThreadLocalProjectDesc(des);
                    des.loadDatas();
                    des.doneLoading();
                }
                finally {
                    this.setThreadLocalProjectDesc(null);
                }
                CProjectDescription cProjectDescription = des;
                return cProjectDescription;
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                throw e;
            }
        }
        finally {
            this.serializingLock.release();
        }
    }

    public IWorkspaceRunnable createDesSerializationRunnable() throws CoreException {
        CProjectDescription des = (CProjectDescription)this.getLoadedDescription();
        if (des == null) {
            throw ExceptionFactory.createCoreException("No read-only Project Description found! Project: " + this.project.getName());
        }
        ICStorageElement element = des.getRootStorageElement();
        DesSerializationRunnable r = new DesSerializationRunnable(des, element);
        return r;
    }

    private ByteArrayOutputStream write(ICStorageElement element) throws CoreException {
        Document doc = ((InternalXmlStorageElement)element).fElement.getOwnerDocument();
        XmlUtil.prettyFormat(doc);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
            return stream;
        }
        catch (TransformerConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (TransformerException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    protected long serialize(IContainer container, String file, ICStorageElement element) throws CoreException {
        long l;
        String utfString;
        IFile projectFile = container.getFile((IPath)new Path(file));
        ISchedulingRule rule = MultiRule.combine((ISchedulingRule[])new ISchedulingRule[]{ResourcesPlugin.getWorkspace().getRuleFactory().modifyRule((IResource)projectFile), ResourcesPlugin.getWorkspace().getRuleFactory().createRule((IResource)projectFile), ResourcesPlugin.getWorkspace().getRuleFactory().deleteRule((IResource)projectFile)});
        ByteArrayOutputStream stream = null;
        try {
            stream = this.write(element);
            utfString = stream.toString("UTF-8");
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
        try {
            Job.getJobManager().beginRule(rule, null);
            CProjectDescriptionStorageManager.ensureWritable((IResource)projectFile);
            if (projectFile.exists()) {
                try {
                    projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    if (projectFile.getLocation().toFile().isHidden()) {
                        String os = System.getProperty("os.name");
                        if (os != null && os.startsWith("Win")) {
                            projectFile.delete(true, null);
                            projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                            CCorePlugin.log(String.valueOf(e.getLocalizedMessage()) + "\n** Error occured because of file status <hidden>." + "\n** This status is disabled now, to allow writing.");
                        }
                        throw e;
                    }
                    throw e;
                }
            } else {
                projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
            }
            l = this.getModificationStamp((IResource)projectFile);
        }
        catch (Throwable throwable) {
            try {
                Job.getJobManager().endRule(rule);
                throw throwable;
            }
            catch (IOException e) {
                throw ExceptionFactory.createCoreException(e);
            }
        }
        Job.getJobManager().endRule(rule);
        return l;
    }

    private ICStorageElement readOldCDTProjectFile(IProject project) throws CoreException {
        InternalXmlStorageElement storage = null;
        try {
            NodeList nodeList;
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = null;
            InputStream stream = this.getSharedProperty((IContainer)project, OLD_CDTPROJECT_FILE_NAME);
            if (stream != null && (nodeList = (doc = builder.parse(stream)).getElementsByTagName(OLD_PROJECT_DESCRIPTION)) != null && nodeList.getLength() > 0) {
                Node node = nodeList.item(0);
                storage = new InternalXmlStorageElement((Element)node, false);
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (SAXException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (IOException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        return storage;
    }

    /*
     * Unable to fully structure code
     */
    protected InternalXmlStorageElement createStorage(IContainer container, String fileName, boolean reCreate, boolean createEmptyIfNotFound, boolean readOnly) throws CoreException {
        try {
            block36: {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                doc = null;
                element = null;
                stream = null;
                if (reCreate) {
                    try {
                        stream = this.getSharedProperty(container, fileName);
                        if (stream != null) {
                            doc = builder.parse(stream);
                            rootElement = doc.getFirstChild();
                            if (rootElement.getNodeType() != 7) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.7"));
                            }
                            fileVersion = rootElement.getNodeValue();
                            version = new Version(fileVersion);
                            if (this.getVersion().compareTo((Object)version) < 0) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.8"));
                            }
                            nodes = doc.getElementsByTagName("cproject");
                            if (nodes.getLength() == 0) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.9"));
                            }
                            node = nodes.item(0);
                            if (node.getNodeType() != 1) {
                                throw ExceptionFactory.createCoreException(SettingsModelMessages.getString("CProjectDescriptionManager.10"));
                            }
                            element = (Element)node;
                        } else if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(String.valueOf(SettingsModelMessages.getString("CProjectDescriptionManager.11")) + fileName);
                        }
                    }
                    catch (FactoryConfigurationError e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e.getLocalizedMessage());
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException v0) {}
                        }
                        break block36;
                    }
                    catch (SAXException e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e);
                        }
                        ** if (stream == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block36;
                        }
                    }
                    catch (IOException e) {
                        if (!createEmptyIfNotFound) {
                            throw ExceptionFactory.createCoreException(e);
                        }
                        ** if (stream == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                stream.close();
                            }
                            catch (IOException v2) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block36;
                        }
                        {
                            catch (Throwable var13_17) {
                                if (stream != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (IOException v3) {}
                                }
                                throw var13_17;
                            }
                        }
                    }
                    if (stream == null) break block36;
                    try {
                        stream.close();
                    }
                    catch (IOException v4) {}
                }
            }
            if (element == null) {
                doc = builder.newDocument();
                instruction = doc.createProcessingInstruction("fileVersion", this.getVersion().toString());
                doc.appendChild(instruction);
                element = doc.createElement("cproject");
                element.setAttribute("storage_type_id", this.getStorageTypeId());
                doc.appendChild(element);
            }
            return new InternalXmlStorageElement(element, null, false, readOnly);
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    protected Version getVersion() {
        return STORAGE_DESCRIPTION_VERSION;
    }

    protected String getStorageTypeId() {
        return STORAGE_TYPE_ID;
    }

    public InputStream getSharedProperty(IContainer container, String key) throws CoreException {
        InputStream stream = null;
        final IFile rscFile = container.getFile((IPath)new Path(key));
        if (rscFile.exists()) {
            try {
                stream = rscFile.getContents(true);
            }
            catch (CoreException e) {
                final Throwable[] t = new Throwable[1];
                Job job = CProjectDescriptionManager.runWspModification(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            rscFile.refreshLocal(0, null);
                        }
                        catch (Exception e) {
                            t[0] = e;
                        }
                    }
                }, (ISchedulingRule)rscFile, (IProgressMonitor)new NullProgressMonitor());
                if (job == null) {
                    if (t[0] == null) {
                        stream = rscFile.getContents();
                    }
                    if (t[0] instanceof CoreException) {
                        throw (CoreException)t[0];
                    }
                    throw e;
                }
                throw e;
            }
        } else {
            URI location = rscFile.getLocationURI();
            if (location != null) {
                IFileStore file = EFS.getStore((URI)location);
                IFileInfo info = null;
                if (file != null && (info = file.fetchInfo()) != null && info.exists()) {
                    stream = file.openInputStream(0, null);
                }
            }
        }
        return stream;
    }

    public void projectCloseRemove() {
        super.projectCloseRemove();
        this.setCurrentDescription(null, true);
    }

    public void projectMove(IProject newProject) {
        super.projectMove(newProject);
        CProjectDescription desc = (CProjectDescription)this.fProjectDescription.get();
        if (desc != null) {
            desc.updateProject(newProject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element createXmlElementCopy(InternalXmlStorageElement el) throws CoreException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element newXmlEl = null;
            Document document = doc;
            synchronized (document) {
                Object object = el.fLock;
                synchronized (object) {
                    if (el.fElement.getParentNode().getNodeType() == 9) {
                        Document baseDoc = el.fElement.getOwnerDocument();
                        NodeList list = baseDoc.getChildNodes();
                        int i = 0;
                        while (i < list.getLength()) {
                            Node node = list.item(i);
                            if ((node = this.importAddNode(doc, node)).getNodeType() == 1 && newXmlEl == null) {
                                newXmlEl = (Element)node;
                            }
                            ++i;
                        }
                    } else {
                        newXmlEl = (Element)this.importAddNode(doc, el.fElement);
                    }
                    return newXmlEl;
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw ExceptionFactory.createCoreException(e);
        }
        catch (FactoryConfigurationError e) {
            throw ExceptionFactory.createCoreException(e);
        }
    }

    public InternalXmlStorageElement copyElement(ICStorageElement el, boolean readOnly) throws CoreException {
        InternalXmlStorageElement internalEl = (InternalXmlStorageElement)el;
        Element newXmlEl = this.createXmlElementCopy(internalEl);
        return new InternalXmlStorageElement(newXmlEl, internalEl.getParent(), internalEl.getAttributeFilters(), internalEl.getChildFilters(), readOnly);
    }

    private Node importAddNode(Document doc, Node node) {
        node = node.getOwnerDocument().equals(doc) ? node.cloneNode(true) : doc.importNode(node, true);
        return doc.appendChild(node);
    }

    private class DesSerializationRunnable
    implements IWorkspaceRunnable {
        private final ICProjectDescription fDes;
        private final ICStorageElement fElement;

        public DesSerializationRunnable(ICProjectDescription des, ICStorageElement el) {
            this.fDes = des;
            this.fElement = el;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            NotifyJobCanceller notifyJobCanceller = new NotifyJobCanceller();
            try {
                Job.getJobManager().addJobChangeListener((IJobChangeListener)notifyJobCanceller);
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                    }
                }, null, 1, null);
                XmlProjectDescriptionStorage.this.serializingLock.acquire();
                XmlProjectDescriptionStorage.this.projectModificaitonStamp = XmlProjectDescriptionStorage.this.serialize((IContainer)this.fDes.getProject(), ".cproject", this.fElement);
                ((ContributedEnvironment)CCorePlugin.getDefault().getBuildEnvironmentManager().getContributedEnvironment()).serialize(this.fDes);
            }
            finally {
                XmlProjectDescriptionStorage.this.serializingLock.release();
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)notifyJobCanceller);
            }
        }

        private class NotifyJobCanceller
        extends JobChangeAdapter {
            private NotifyJobCanceller() {
            }

            public void aboutToRun(IJobChangeEvent event) {
                Job job = event.getJob();
                if ("org.eclipse.core.internal.events.NotificationManager$NotifyJob".equals(job.getClass().getName())) {
                    job.cancel();
                }
            }
        }
    }
}

