/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.TracingConsole;
import org.eclipse.cdt.dsf.gdb.launching.ITracedLaunch;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class TracingConsoleManager
implements ILaunchesListener2,
IPropertyChangeListener {
    private boolean fTracingEnabled = false;

    public void startup() {
        GdbUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        this.fTracingEnabled = store.getBoolean("tracesEnable");
        if (this.fTracingEnabled) {
            this.toggleTracing(true);
        }
    }

    public void shutdown() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        GdbUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.removeAllConsoles();
    }

    protected void toggleTracing(boolean enabled) {
        if (enabled) {
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
            this.addAllConsoles();
        } else {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
            this.removeAllConsoles();
        }
    }

    protected void addAllConsoles() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.addConsole(launch);
            ++n2;
        }
    }

    protected void removeAllConsoles() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.removeConsole(launch);
            ++n2;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.addConsole(launch);
            ++n2;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.removeConsole(launch);
            ++n2;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            this.renameConsole(launch);
            ++n2;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("tracesEnable")) {
            this.fTracingEnabled = (Boolean)event.getNewValue();
            this.toggleTracing(this.fTracingEnabled);
        }
    }

    protected void addConsole(ILaunch launch) {
        if (launch instanceof ITracedLaunch && this.getConsole(launch) == null && !launch.isTerminated()) {
            TracingConsole console = new TracingConsole(launch, ConsoleMessages.ConsoleMessages_trace_console_name);
            console.setWaterMarks(400000, 500000);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        }
    }

    protected void removeConsole(ILaunch launch) {
        TracingConsole console;
        if (launch instanceof ITracedLaunch && (console = this.getConsole(launch)) != null) {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{console});
        }
    }

    protected void renameConsole(ILaunch launch) {
        TracingConsole console;
        if (launch instanceof ITracedLaunch && (console = this.getConsole(launch)) != null) {
            console.resetName();
        }
    }

    private TracingConsole getConsole(ILaunch launch) {
        IConsole[] consoles;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = consoles = manager.getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            TracingConsole tracingConsole;
            IConsole console = iConsoleArray[n2];
            if (console instanceof TracingConsole && (tracingConsole = (TracingConsole)console).getLaunch().equals(launch)) {
                return tracingConsole;
            }
            ++n2;
        }
        return null;
    }
}

