/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.launching;

import java.io.File;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.debug.ui.AbstractCDebuggerPage;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.GDBSolibBlock;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.IMILaunchConfigurationComponent;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.SolibSearchPathBlock;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GdbDebuggerPage
extends AbstractCDebuggerPage
implements Observer {
    protected TabFolder fTabFolder;
    protected Text fGDBCommandText;
    protected Text fGDBInitText;
    protected Button fNonStopCheckBox;
    protected Button fReverseCheckBox;
    protected Button fUpdateThreadlistOnSuspend;
    private IMILaunchConfigurationComponent fSolibBlock;
    private boolean fIsInitializing = false;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTabFolder = new TabFolder(comp, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(1808));
        this.createTabs(this.fTabFolder);
        this.fTabFolder.setSelection(0);
        this.setControl((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "gdb");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", ".gdbinit");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", false);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", false);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.setDefaults(configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean valid;
        boolean bl = valid = this.fGDBCommandText.getText().length() != 0;
        if (valid) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(LaunchUIMessages.getString("GDBDebuggerPage.gdb_executable_not_specified"));
            this.setMessage(null);
        }
        return valid;
    }

    private String getStringAttr(ILaunchConfiguration config, String attributeName, String defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    private boolean getBooleanAttr(ILaunchConfiguration config, String attributeName, boolean defaultValue) {
        try {
            return config.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.setInitializing(true);
        String gdbCommand = this.getStringAttr(configuration, "org.eclipse.cdt.dsf.gdb.DEBUG_NAME", "gdb");
        String gdbInit = this.getStringAttr(configuration, "org.eclipse.cdt.dsf.gdb.GDB_INIT", ".gdbinit");
        boolean nonStopMode = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.NON_STOP", false);
        boolean reverseEnabled = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.REVERSE", false);
        boolean updateThreadsOnSuspend = this.getBooleanAttr(configuration, "org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        if (this.fSolibBlock != null) {
            this.fSolibBlock.initializeFrom(configuration);
        }
        this.fGDBCommandText.setText(gdbCommand);
        this.fGDBInitText.setText(gdbInit);
        this.fNonStopCheckBox.setSelection(nonStopMode);
        this.fReverseCheckBox.setSelection(reverseEnabled);
        this.fUpdateThreadlistOnSuspend.setSelection(updateThreadsOnSuspend);
        this.setInitializing(false);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.fGDBCommandText.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", this.fGDBInitText.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", this.fNonStopCheckBox.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.REVERSE", this.fReverseCheckBox.getSelection());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        if (this.fSolibBlock != null) {
            this.fSolibBlock.performApply(configuration);
        }
    }

    public String getName() {
        return LaunchUIMessages.getString("GDBDebuggerPage.tab_name");
    }

    protected Shell getShell() {
        return super.getShell();
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void update(Observable o, Object arg) {
        if (!this.isInitializing()) {
            this.updateLaunchConfigurationDialog();
        }
    }

    public IMILaunchConfigurationComponent createSolibBlock(Composite parent) {
        GDBSolibBlock block = new GDBSolibBlock(new SolibSearchPathBlock(), true, true);
        block.createControl(parent);
        return block;
    }

    public void createTabs(TabFolder tabFolder) {
        this.createMainTab(tabFolder);
        this.createSolibTab(tabFolder);
    }

    public void createMainTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString("GDBDebuggerPage.main_tab_name"));
        Composite comp = ControlFactory.createCompositeEx((Composite)tabFolder, (int)1, (int)1808);
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        Composite subComp = ControlFactory.createCompositeEx((Composite)comp, (int)3, (int)768);
        ((GridLayout)subComp.getLayout()).makeColumnsEqualWidth = false;
        subComp.setFont(tabFolder.getFont());
        Label label = ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString("GDBDebuggerPage.gdb_debugger"));
        GridData gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBCommandText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        this.fGDBCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GdbDebuggerPage.this.isInitializing()) {
                    GdbDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        Button button = this.createPushButton(subComp, LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBButtonSelected();
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GdbDebuggerPage.this.getShell(), 0);
                dialog.setText(LaunchUIMessages.getString("GDBDebuggerPage.gdb_browse_dlg_title"));
                String gdbCommand = GdbDebuggerPage.this.fGDBCommandText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GdbDebuggerPage.this.fGDBCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString("GDBDebuggerPage.gdb_command_file"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.fGDBInitText = ControlFactory.createTextField((Composite)subComp, (int)2052);
        gd = new GridData(768);
        this.fGDBInitText.setLayoutData((Object)gd);
        this.fGDBInitText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                if (!GdbDebuggerPage.this.isInitializing()) {
                    GdbDebuggerPage.this.updateLaunchConfigurationDialog();
                }
            }
        });
        button = this.createPushButton(subComp, LaunchUIMessages.getString("GDBDebuggerPage.gdb_cmdfile_browse"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleGDBInitButtonSelected();
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }

            private void handleGDBInitButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(GdbDebuggerPage.this.getShell(), 0);
                dialog.setText(LaunchUIMessages.getString("GDBDebuggerPage.gdb_cmdfile_dlg_title"));
                String gdbCommand = GdbDebuggerPage.this.fGDBInitText.getText().trim();
                int lastSeparatorIndex = gdbCommand.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(gdbCommand.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                GdbDebuggerPage.this.fGDBInitText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)subComp, (String)LaunchUIMessages.getString("GDBDebuggerPage.cmdfile_warning"), (int)200, (int)-1, (int)64);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.widthHint = 200;
        label.setLayoutData((Object)gd);
        this.fNonStopCheckBox = this.addCheckbox(subComp, LaunchUIMessages.getString("GDBDebuggerPage.nonstop_mode"));
        this.fReverseCheckBox = this.addCheckbox(subComp, LaunchUIMessages.getString("GDBDebuggerPage.reverse_Debugging"));
        this.fUpdateThreadlistOnSuspend = this.addCheckbox(subComp, LaunchUIMessages.getString("GDBDebuggerPage.update_thread_list_on_suspend"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpdateThreadlistOnSuspend, "org.eclipse.cdt.dsf.gdb.ui.update_threadlist_button_context");
    }

    public void createSolibTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(LaunchUIMessages.getString("GDBDebuggerPage.shared_libraries"));
        Composite comp = ControlFactory.createCompositeEx((Composite)this.fTabFolder, (int)1, (int)1808);
        comp.setFont(tabFolder.getFont());
        tabItem.setControl((Control)comp);
        this.fSolibBlock = this.createSolibBlock(comp);
        if (this.fSolibBlock instanceof Observable) {
            ((Observable)((Object)this.fSolibBlock)).addObserver(this);
        }
    }

    private Button addCheckbox(Composite parent, String label) {
        Button button = ControlFactory.createCheckBox((Composite)parent, (String)label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GdbDebuggerPage.this.updateLaunchConfigurationDialog();
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        button.setLayoutData((Object)gd);
        return button;
    }

    public void dispose() {
        if (this.fSolibBlock != null) {
            if (this.fSolibBlock instanceof Observable) {
                ((Observable)((Object)this.fSolibBlock)).deleteObserver(this);
            }
            this.fSolibBlock.dispose();
        }
        super.dispose();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    protected boolean isInitializing() {
        return this.fIsInitializing;
    }

    private void setInitializing(boolean isInitializing) {
        this.fIsInitializing = isInitializing;
    }
}

