/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupDirector;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.dsf.gdb.launching.ServicesLaunchSequence;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.service.GdbDebugServicesFactoryNS;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.gdb.service.macos.MacOSGdbDebugServicesFactory;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate2;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

@ThreadSafe
public class GdbLaunchDelegate
extends AbstractCLaunchDelegate2 {
    public static final String GDB_DEBUG_MODEL_ID = "org.eclipse.cdt.dsf.gdb";
    private static final String NON_STOP_FIRST_VERSION = "6.8.50";
    private boolean isNonStopSession = false;
    private static final String TRACING_FIRST_VERSION = "7.1.50";
    private boolean fIsPostMortemTracingSession;

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        org.eclipse.cdt.launch.LaunchUtils.enableActivity((String)"org.eclipse.cdt.debug.dsfgdbActivity", (boolean)true);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (mode.equals("debug")) {
            this.launchDebugger(config, launch, monitor);
        }
    }

    private void launchDebugger(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(LaunchMessages.getString("GdbLaunchDelegate.0"), 10);
        if (monitor.isCanceled()) {
            return;
        }
        try {
            this.launchDebugSession(config, launch, monitor);
        }
        finally {
            monitor.done();
        }
    }

    private void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        SessionType sessionType = LaunchUtils.getSessionType(config);
        boolean attach = LaunchUtils.getIsAttach(config);
        GdbLaunch launch = (GdbLaunch)l;
        if (sessionType == SessionType.REMOTE) {
            monitor.subTask(LaunchMessages.getString("GdbLaunchDelegate.1"));
        } else if (sessionType == SessionType.CORE) {
            monitor.subTask(LaunchMessages.getString("GdbLaunchDelegate.2"));
        } else {
            assert (sessionType == SessionType.LOCAL) : "Unexpected session type: " + sessionType.toString();
            monitor.subTask(LaunchMessages.getString("GdbLaunchDelegate.3"));
        }
        Path exePath = new Path("");
        if (!attach) {
            exePath = this.checkBinaryDetails(config);
        }
        monitor.worked(1);
        String gdbVersion = this.getGDBVersion(config);
        if (this.isNonStopSession && !this.isNonStopSupported(gdbVersion)) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Non-stop mode is only supported starting with GDB 6.8.50", null));
        }
        if (this.fIsPostMortemTracingSession && !this.isPostMortemTracingSupported(gdbVersion)) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Post-mortem tracing is only supported starting with GDB 7.1.50", null));
        }
        launch.setServiceFactory(this.newServiceFactory(gdbVersion));
        SubProgressMonitor subMon1 = new SubProgressMonitor(monitor, 4, 4);
        ServicesLaunchSequence servicesLaunchSequence = new ServicesLaunchSequence(launch.getSession(), launch, (IProgressMonitor)subMon1);
        launch.getSession().getExecutor().execute((Runnable)((Object)servicesLaunchSequence));
        try {
            servicesLaunchSequence.get();
        }
        catch (InterruptedException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
        }
        catch (ExecutionException e1) {
            throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in services launch sequence", e1.getCause()));
        }
        catch (CancellationException cancellationException) {
            return;
        }
        if (monitor.isCanceled()) {
            return;
        }
        launch.initializeControl();
        launch.addCLIProcess("gdb");
        if (!attach && sessionType != SessionType.CORE) {
            launch.addInferiorProcess(exePath.lastSegment());
        }
        monitor.worked(1);
        SubProgressMonitor subMon2 = new SubProgressMonitor(monitor, 4, 4);
        Sequence finalLaunchSequence = this.getFinalLaunchSequence(launch.getSession().getExecutor(), launch, sessionType, attach, (IProgressMonitor)subMon2);
        launch.getSession().getExecutor().execute((Runnable)finalLaunchSequence);
        boolean succeed = false;
        try {
            try {
                finalLaunchSequence.get();
                succeed = true;
            }
            catch (InterruptedException e1) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "Interrupted Exception in dispatch thread", (Throwable)e1));
            }
            catch (ExecutionException e1) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in final launch sequence", e1.getCause()));
            }
            catch (CancellationException cancellationException) {
                if (!succeed) {
                    Query<Object> launchShutdownQuery = new Query<Object>(launch){
                        private final /* synthetic */ GdbLaunch val$launch;
                        {
                            this.val$launch = gdbLaunch;
                        }

                        protected void execute(DataRequestMonitor<Object> rm) {
                            this.val$launch.shutdownSession((RequestMonitor)rm);
                        }
                    };
                    launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                    try {
                        launchShutdownQuery.get();
                    }
                    catch (InterruptedException e) {
                        throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                    }
                    catch (ExecutionException e) {
                        throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                    }
                }
                return;
            }
        }
        catch (Throwable throwable) {
            if (!succeed) {
                Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
                launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
                try {
                    launchShutdownQuery.get();
                }
                catch (InterruptedException e) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
                }
                catch (ExecutionException e) {
                    throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
                }
            }
            throw throwable;
        }
        if (!succeed) {
            Query<Object> launchShutdownQuery = new /* invalid duplicate definition of identical inner class */;
            launch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
            try {
                launchShutdownQuery.get();
            }
            catch (InterruptedException e) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
            }
            catch (ExecutionException e) {
                throw new DebugException((IStatus)new Status(4, GDB_DEBUG_MODEL_ID, 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
            }
        }
    }

    protected IPath checkBinaryDetails(ILaunchConfiguration config) throws CoreException {
        ICProject project = this.verifyCProject(config);
        IPath exePath = LaunchUtils.verifyProgramPath(config, project);
        LaunchUtils.verifyBinary(config, exePath);
        return exePath;
    }

    protected String getGDBVersion(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.getGDBVersion(config);
    }

    protected Sequence getFinalLaunchSequence(DsfExecutor executor, GdbLaunch launch, SessionType type, boolean attach, IProgressMonitor pm) {
        return new FinalLaunchSequence(executor, launch, type, attach, pm);
    }

    private boolean isNonStopSession(ILaunchConfiguration config) {
        try {
            boolean nonStopMode = config.getAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", false);
            return nonStopMode;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean isPostMortemTracingSession(ILaunchConfiguration config) {
        SessionType sessionType = LaunchUtils.getSessionType(config);
        if (sessionType == SessionType.CORE) {
            try {
                String coreType = config.getAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", "CORE_FILE");
                return coreType.equals("TRACE_FILE");
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public boolean preLaunchCheck(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        if (mode.equals("debug") && LaunchUtils.getSessionType(config) == SessionType.CORE) {
            return true;
        }
        return super.preLaunchCheck(config, mode, monitor);
    }

    public ILaunch getLaunch(ILaunchConfiguration configuration, String mode) throws CoreException {
        this.isNonStopSession = this.isNonStopSession(configuration);
        this.fIsPostMortemTracingSession = this.isPostMortemTracingSession(configuration);
        GdbLaunch launch = new GdbLaunch(configuration, mode, null);
        launch.initialize();
        launch.setSourceLocator(this.getSourceLocator(configuration, launch.getSession()));
        return launch;
    }

    private ISourceLocator getSourceLocator(ILaunchConfiguration configuration, DsfSession session) throws CoreException {
        DsfSourceLookupDirector locator = new DsfSourceLookupDirector(session);
        String memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        if (memento == null) {
            locator.initializeDefaults(configuration);
        } else {
            locator.initializeFromMemento(memento, configuration);
        }
        return locator;
    }

    private boolean isNonStopSupported(String version) {
        if (version.contains("APPLE")) {
            return false;
        }
        return NON_STOP_FIRST_VERSION.compareTo(version) <= 0;
    }

    private boolean isPostMortemTracingSupported(String version) {
        if (version.contains("APPLE")) {
            return false;
        }
        return TRACING_FIRST_VERSION.compareTo(version) <= 0 || "6.8.50.20090414".equals(version);
    }

    protected IDsfDebugServicesFactory newServiceFactory(String version) {
        String[] versions;
        if (this.isNonStopSession && this.isNonStopSupported(version)) {
            return new GdbDebugServicesFactoryNS(version);
        }
        if (version.contains("APPLE") && (versions = version.split("APPLE")).length == 2) {
            return new MacOSGdbDebugServicesFactory(versions[0], versions[1]);
        }
        return new GdbDebugServicesFactory(version);
    }

    protected String getPluginID() {
        return GDB_DEBUG_MODEL_ID;
    }

    protected ICProject verifyCProject(ILaunchConfiguration config) throws CoreException {
        return LaunchUtils.verifyCProject(config);
    }
}

