/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.utils;

import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.refactoring.utils.NamespaceHelper;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class NameHelper {
    private static final String localVariableRegexp = "[a-z_A-Z]\\w*";

    public static boolean isValidLocalVariableName(String name) {
        boolean valid = Pattern.compile(localVariableRegexp).matcher(name).matches();
        return valid;
    }

    public static boolean isKeyword(String name) {
        CharArrayIntMap keywords = new CharArrayIntMap(0, -1);
        Keywords.addKeywordsC((CharArrayIntMap)keywords);
        Keywords.addKeywordsCpp((CharArrayIntMap)keywords);
        Keywords.addKeywordsPreprocessor((CharArrayIntMap)keywords);
        return keywords.containsKey(name.toCharArray());
    }

    public static ICPPASTQualifiedName createQualifiedNameFor(IASTName declaratorName, IFile declarationFile, int selectionOffset, IFile insertFile, int insertLocation) throws CoreException {
        CPPASTQualifiedName qname = new CPPASTQualifiedName();
        IASTName[] declarationNames = NamespaceHelper.getSurroundingNamespace(declarationFile, selectionOffset).getNames();
        IASTName[] implementationNames = NamespaceHelper.getSurroundingNamespace(insertFile, insertLocation).getNames();
        int i = 0;
        while (i < declarationNames.length) {
            if (i >= implementationNames.length) {
                qname.addName(declarationNames[i]);
            } else if (!String.valueOf(declarationNames[i].toCharArray()).equals(String.valueOf(implementationNames[i].toCharArray()))) {
                qname.addName(declarationNames[i]);
            }
            ++i;
        }
        qname.addName(declaratorName.copy());
        return qname;
    }

    public static String trimFieldName(String fieldName) {
        char[] letters = fieldName.toCharArray();
        int start = 0;
        int end = letters.length - 1;
        try {
            while (!Character.isLetterOrDigit(letters[start]) && start < end) {
                ++start;
            }
            if (start + 1 <= end && !Character.isLetterOrDigit(letters[start + 1])) {
                int lookAhead = 1;
                while (start + lookAhead <= end) {
                    if (Character.isLetterOrDigit(letters[start + lookAhead])) {
                        start += lookAhead;
                        break;
                    }
                    ++lookAhead;
                }
            } else if (!Character.isUpperCase(letters[start]) && start + 1 <= end && Character.isUpperCase(letters[start + 1])) {
                ++start;
            }
            while (!Character.isLetter(letters[end]) && !Character.isDigit(letters[end]) && start < end) {
                --end;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return new String(letters, start, end - start + 1);
    }

    public static String makeFirstCharUpper(String name) {
        if (Character.isLowerCase(name.charAt(0))) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        return name;
    }

    public static String getTypeName(IASTParameterDeclaration parameter) {
        IASTName name = parameter.getDeclarator().getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariable) {
            try {
                IType type = ((IVariable)binding).getType();
                if (type != null) {
                    return ASTTypeUtil.getType((IType)type);
                }
            }
            catch (DOMException e) {
                CUIPlugin.log(e);
            }
        }
        return "";
    }
}

