/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.internal.ui.preferences.ProposalFilterPreferencesUtil;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.CParameterListValidator;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposalComparator;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.ContentAssistProcessor;
import org.eclipse.cdt.internal.ui.text.contentassist.DefaultProposalFilter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.IProposalFilter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CContentAssistProcessor
extends ContentAssistProcessor {
    private ActivationSet fReplacementAutoActivationCharacters;
    private ActivationSet fCContentAutoActivationCharacters;
    private IContextInformationValidator fValidator;
    private final IEditorPart fEditor;

    public CContentAssistProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(assistant, partition);
        this.fEditor = editor;
    }

    @Override
    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new CParameterListValidator();
        }
        return this.fValidator;
    }

    @Override
    protected List<ICompletionProposal> filterAndSortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        List<ICompletionProposal> filteredList;
        IProposalFilter filter = this.getCompletionFilter();
        ICCompletionProposal[] proposalsInput = new ICCompletionProposal[proposals.size()];
        boolean wrapped = false;
        int i = 0;
        for (ICompletionProposal proposal : proposals) {
            if (proposal instanceof ICCompletionProposal) {
                proposalsInput[i++] = (ICCompletionProposal)proposal;
                continue;
            }
            wrapped = true;
            proposalsInput[i++] = new CCompletionProposalWrapper(proposal);
        }
        ICCompletionProposal[] proposalsFiltered = filter.filterProposals(proposalsInput);
        boolean sortByAlphabet = CUIPlugin.getDefault().getPreferenceStore().getBoolean("content_assist_order_proposals");
        if (!sortByAlphabet) {
            CCompletionProposalComparator propsComp = new CCompletionProposalComparator();
            propsComp.setOrderAlphabetically(sortByAlphabet);
            Arrays.sort(proposalsFiltered, propsComp);
        }
        if (wrapped) {
            filteredList = new ArrayList<ICCompletionProposal>(proposalsFiltered.length);
            ICCompletionProposal[] iCCompletionProposalArray = proposalsFiltered;
            int n = proposalsFiltered.length;
            int n2 = 0;
            while (n2 < n) {
                ICCompletionProposal proposal = iCCompletionProposalArray[n2];
                if (proposal instanceof CCompletionProposalWrapper) {
                    filteredList.add(((CCompletionProposalWrapper)proposal).unwrap());
                } else {
                    filteredList.add(proposal);
                }
                ++n2;
            }
        } else {
            ICCompletionProposal[] tmp = proposalsFiltered;
            filteredList = Arrays.asList(tmp);
        }
        return filteredList;
    }

    private IProposalFilter getCompletionFilter() {
        IProposalFilter filter = null;
        try {
            Object contribObject;
            IConfigurationElement filterElement = ProposalFilterPreferencesUtil.getPreferredFilterElement();
            if (filterElement != null && (contribObject = filterElement.createExecutableExtension("class")) instanceof IProposalFilter) {
                filter = (IProposalFilter)contribObject;
            }
        }
        catch (InvalidRegistryObjectException e) {
            CUIPlugin.log(e);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
        }
        if (filter == null) {
            filter = new DefaultProposalFilter();
        }
        return filter;
    }

    @Override
    protected List<IContextInformation> filterAndSortContextInformation(List<IContextInformation> contexts, IProgressMonitor monitor) {
        return contexts;
    }

    public void setReplacementAutoActivationCharacters(String activationSet) {
        this.fReplacementAutoActivationCharacters = new ActivationSet(activationSet);
    }

    public void setCContentAutoActivationCharacters(String activationSet) {
        this.fCContentAutoActivationCharacters = new ActivationSet(activationSet);
    }

    @Override
    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset, boolean isCompletion) {
        IASTFieldReference ref;
        IASTExpression ownerExpr;
        IASTName[] names;
        IASTCompletionNode node;
        char activationChar = this.getActivationChar(viewer, offset);
        CContentAssistInvocationContext context = new CContentAssistInvocationContext(viewer, offset, this.fEditor, isCompletion, this.isAutoActivated());
        if (isCompletion && activationChar == '.' && this.fReplacementAutoActivationCharacters != null && this.fReplacementAutoActivationCharacters.contains('.') && (node = context.getCompletionNode()) != null && (names = node.getNames()).length > 0 && names[0].getParent() instanceof IASTFieldReference && (ownerExpr = (ref = (IASTFieldReference)names[0].getParent()).getFieldOwner()).getExpressionType() instanceof IPointerType) {
            context = this.replaceDotWithArrow(viewer, offset, isCompletion, context, activationChar);
        }
        return context;
    }

    private CContentAssistInvocationContext replaceDotWithArrow(ITextViewer viewer, int offset, boolean isCompletion, CContentAssistInvocationContext context, char activationChar) {
        block2: {
            IDocument doc = viewer.getDocument();
            try {
                doc.replace(offset - 1, 1, "->");
                context.dispose();
                context = !this.isAutoActivated() || this.fCContentAutoActivationCharacters.contains(activationChar) ? new CContentAssistInvocationContext(viewer, offset + 1, this.fEditor, isCompletion, this.isAutoActivated()) : null;
            }
            catch (BadLocationException badLocationException) {
                if (!this.isAutoActivated() || this.fCContentAutoActivationCharacters.contains(activationChar) || context == null) break block2;
                context.dispose();
                context = null;
            }
        }
        return context;
    }

    private char getActivationChar(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        if (doc == null) {
            return '\u0000';
        }
        if (offset <= 0) {
            return '\u0000';
        }
        try {
            return doc.getChar(offset - 1);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    @Override
    protected boolean verifyAutoActivation(ITextViewer viewer, int offset) {
        IDocument doc = viewer.getDocument();
        if (doc == null) {
            return false;
        }
        if (offset <= 0) {
            return false;
        }
        try {
            char activationChar = doc.getChar(--offset);
            switch (activationChar) {
                case ':': {
                    return offset > 0 && doc.getChar(--offset) == ':';
                }
                case '>': {
                    return offset > 0 && doc.getChar(--offset) == '-';
                }
                case '.': {
                    CHeuristicScanner scanner = new CHeuristicScanner(doc);
                    int token = scanner.previousToken(--offset, Math.max(0, offset - 200));
                    return token != 2000 || Character.isJavaIdentifierStart(doc.getChar(scanner.getPosition() + 1));
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private static class ActivationSet {
        private final String theSet;

        ActivationSet(String s) {
            this.theSet = s;
        }

        boolean contains(char c) {
            return -1 != this.theSet.indexOf(c);
        }
    }

    private static class CCompletionProposalWrapper
    implements ICCompletionProposal {
        private ICompletionProposal fWrappedProposal;

        public CCompletionProposalWrapper(ICompletionProposal proposal) {
            this.fWrappedProposal = proposal;
        }

        public String getIdString() {
            return this.fWrappedProposal.getDisplayString();
        }

        public int getRelevance() {
            return 1010;
        }

        public void apply(IDocument document) {
            throw new UnsupportedOperationException();
        }

        public String getAdditionalProposalInfo() {
            return this.fWrappedProposal.getAdditionalProposalInfo();
        }

        public IContextInformation getContextInformation() {
            return this.fWrappedProposal.getContextInformation();
        }

        public String getDisplayString() {
            return this.fWrappedProposal.getDisplayString();
        }

        public Image getImage() {
            return this.fWrappedProposal.getImage();
        }

        public Point getSelection(IDocument document) {
            return this.fWrappedProposal.getSelection(document);
        }

        public ICompletionProposal unwrap() {
            return this.fWrappedProposal;
        }
    }
}

