/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.hello.host;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.ecf.examples.remoteservices.hello.IHello;
import org.eclipse.ecf.examples.remoteservices.hello.impl.Hello;
import org.eclipse.ecf.internal.examples.remoteservices.hello.host.Activator;
import org.eclipse.ecf.internal.examples.remoteservices.hello.host.HelloCommandProvider;
import org.eclipse.ecf.osgi.services.discovery.IHostDiscoveryListener;
import org.eclipse.ecf.osgi.services.discovery.LoggingHostDiscoveryListener;
import org.eclipse.ecf.osgi.services.distribution.IDistributionConstants;
import org.eclipse.ecf.osgi.services.distribution.IHostDistributionListener;
import org.eclipse.ecf.osgi.services.distribution.LoggingHostDistributionListener;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class HelloHostApplication
implements IApplication,
IDistributionConstants {
    private static final String DEFAULT_CONTAINER_TYPE = "ecf.r_osgi.peer";
    public static final String DEFAULT_CONTAINER_ID = "r-osgi://localhost:9278";
    private BundleContext bundleContext;
    private String containerType = "ecf.r_osgi.peer";
    private String containerId = "r-osgi://localhost:9278";
    private final Object appLock = new Object();
    private boolean done = false;
    private ServiceRegistration helloRegistration;
    private ServiceRegistration discoveryListenerRegistration;
    private ServiceRegistration distributionListenerRegistration;

    public Object start(IApplicationContext appContext) throws Exception {
        this.bundleContext = Activator.getContext();
        this.processArgs(appContext);
        this.registerRemoteServiceListeners();
        this.registerHelloRemoteService();
        this.registerConsoleProvider();
        this.waitForDone();
        return IApplication.EXIT_OK;
    }

    void registerHelloRemoteService() {
        Properties props = new Properties();
        props.put("service.exported.interfaces", "*");
        props.put("service.exported.configs", this.containerType);
        props.put("org.eclipse.ecf.containerFactoryArgs", this.containerId);
        this.helloRegistration = this.bundleContext.registerService(IHello.class.getName(), (Object)new Hello(), (Dictionary)props);
        System.out.println("Host: Hello Service Registered");
    }

    void unregisterHelloRemoteService() {
        if (this.helloRegistration != null) {
            this.helloRegistration.unregister();
            this.helloRegistration = null;
        }
        System.out.println("Host: Hello Remote Service Unregistered");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.unregisterHelloRemoteService();
        if (this.discoveryListenerRegistration != null) {
            this.discoveryListenerRegistration.unregister();
            this.discoveryListenerRegistration = null;
        }
        if (this.distributionListenerRegistration != null) {
            this.distributionListenerRegistration.unregister();
            this.distributionListenerRegistration = null;
        }
        this.bundleContext = null;
        Object object = this.appLock;
        synchronized (object) {
            this.done = true;
            this.appLock.notifyAll();
        }
    }

    private void registerConsoleProvider() {
        HelloCommandProvider helloCommandProvider = new HelloCommandProvider(this);
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        ((Dictionary)props).put("service.ranking", new Integer(2147483547));
        this.bundleContext.registerService(CommandProvider.class.getName(), (Object)helloCommandProvider, props);
    }

    private void registerRemoteServiceListeners() {
        this.discoveryListenerRegistration = this.bundleContext.registerService(IHostDiscoveryListener.class.getName(), (Object)new LoggingHostDiscoveryListener(), null);
        this.distributionListenerRegistration = this.bundleContext.registerService(IHostDistributionListener.class.getName(), (Object)new LoggingHostDistributionListener(), null);
    }

    private void processArgs(IApplicationContext appContext) {
        String[] originalArgs = (String[])appContext.getArguments().get("application.args");
        if (originalArgs == null) {
            return;
        }
        int i = 0;
        while (i < originalArgs.length) {
            if (originalArgs[i].equals("-containerType")) {
                this.containerType = originalArgs[i + 1];
                ++i;
            } else if (originalArgs[i].equals("-containerId")) {
                this.containerId = originalArgs[i + 1];
                ++i;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForDone() {
        Object object = this.appLock;
        synchronized (object) {
            while (true) {
                if (this.done) {
                    return;
                }
                try {
                    this.appLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

