/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.discovery;

import java.util.Enumeration;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.internal.osgi.services.discovery.Activator;
import org.osgi.framework.ServiceReference;

public abstract class AbstractDiscoveryListener {
    protected int logLevel = 3;

    public AbstractDiscoveryListener(int logLevel) {
        this.logLevel = logLevel;
    }

    public AbstractDiscoveryListener() {
    }

    protected int getLogLevel() {
        return this.logLevel;
    }

    protected void log(ServiceReference serviceReference, String message, Throwable t) {
        Activator a = Activator.getDefault();
        if (a == null) {
            return;
        }
        a.log(serviceReference, this.getLogLevel(), message, t);
    }

    protected String printServiceInfo(int tabLevel, IServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("");
        sb.append(this.createTabs(tabLevel));
        sb.append("serviceInfo").append("\n");
        this.printServicePropertyString(tabLevel + 1, "location", serviceInfo.getLocation().toString(), sb, true);
        this.printServicePropertyString(tabLevel + 1, "serviceID", serviceInfo.getServiceID().toExternalForm(), sb, true);
        this.printServicePropertyString(tabLevel + 1, "serviceName", serviceInfo.getServiceName(), sb, true);
        this.printServicePropertyString(tabLevel + 1, "priority", String.valueOf(serviceInfo.getPriority()), sb, true);
        this.printServicePropertyString(tabLevel + 1, "weight", String.valueOf(serviceInfo.getWeight()), sb, true);
        sb.append(this.createTabs(tabLevel + 1)).append("discoveryServiceProperties").append("\n").append(this.printServiceProperties(tabLevel + 2, serviceInfo.getServiceProperties()));
        IServiceProperties serviceProperties = serviceInfo.getServiceProperties();
        if (serviceProperties != null) {
            sb.append(this.createTabs(tabLevel + 1));
            sb.append("osgiServiceProperties");
            sb.append("\n");
            sb.append(this.printServicePropertyString(tabLevel + 2, serviceProperties, "osgi.remote.service.interfaces", "osgiServiceInterfaces"));
            sb.append(this.printServicePropertyString(tabLevel + 2, serviceProperties, "ecf.sp.ect", "endpointSupportedConfigs"));
            sb.append(this.printServicePropertyString(tabLevel + 2, serviceProperties, "ecf.sp.esi", "endpointServiceIntents"));
            sb.append(this.printServicePropertyBytes(tabLevel + 2, serviceProperties, "ecf.sp.cid", "endpointContainerID"));
            sb.append(this.printServicePropertyString(tabLevel + 2, serviceProperties, "ecf.sp.cns", "endpointContainerIDNamespace"));
            sb.append(this.printServicePropertyBytes(tabLevel + 2, serviceProperties, "ecf.rsvc.id", "remoteServiceID"));
            sb.append(this.printServicePropertyString(tabLevel + 2, serviceProperties, "ecf.rsvc.ns", "remoteServiceIDNamespace"));
        }
        return sb.toString();
    }

    private void printServicePropertyString(int tabLevel, String propertyName, String propertyValue, StringBuffer sb, boolean newline) {
        if (propertyValue != null) {
            sb.append(this.createTabs(tabLevel)).append(propertyName);
            sb.append("=");
            sb.append(propertyValue);
            if (newline) {
                sb.append("\n");
            }
        }
    }

    protected String printServicePropertyString(int tabLevel, IServiceProperties serviceProperties, String propertyName, String outputName) {
        StringBuffer sb = new StringBuffer();
        String propertyValue = serviceProperties.getPropertyString(propertyName);
        if (propertyValue != null) {
            this.printServicePropertyString(tabLevel, outputName, propertyValue, sb, true);
        }
        return sb.toString();
    }

    protected String printServicePropertyBytes(int tabLevel, IServiceProperties serviceProperties, String propertyName, String outputName) {
        byte[] propertyValue = serviceProperties.getPropertyBytes(propertyName);
        StringBuffer sb = new StringBuffer();
        if (propertyValue != null) {
            this.printServicePropertyString(tabLevel, outputName, new String(propertyValue), sb, true);
        }
        return sb.toString();
    }

    protected String printServiceID(IServiceID serviceID) {
        if (serviceID == null) {
            return "null";
        }
        return serviceID.toExternalForm();
    }

    protected String createTabs(int tabLevel) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < tabLevel) {
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    protected String printServiceProperties(int tabLevel, IServiceProperties serviceProperties) {
        if (serviceProperties == null) {
            return "null";
        }
        Enumeration enumeration = serviceProperties.getPropertyNames();
        StringBuffer sb = new StringBuffer("");
        if (enumeration != null) {
            Enumeration e = enumeration;
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sb.append(this.createTabs(tabLevel));
                sb.append("name=").append(key).append(";");
                String stringValue = serviceProperties.getPropertyString(key);
                byte[] bytesValue = serviceProperties.getPropertyBytes(key);
                Object objectValue = serviceProperties.getProperty(key);
                if (stringValue != null) {
                    sb.append("value[String]=").append(stringValue);
                }
                if (bytesValue != null) {
                    sb.append("value[bytes]=").append(this.printBytes(bytesValue));
                }
                if (objectValue != null && stringValue == null) {
                    if (bytesValue != null) {
                        sb.append(",");
                    }
                    sb.append("value[Object]=").append(objectValue);
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected String printBytes(byte[] bytesValue) {
        if (bytesValue == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("[");
        int i = 0;
        while (i < bytesValue.length) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(bytesValue[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

