/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.osgi.services.distribution.DiscoveredServiceTrackerImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.DistributionProviderImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.EventHookImpl;
import org.eclipse.ecf.osgi.services.distribution.DefaultHostContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.DefaultProxyContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IHostDistributionListener;
import org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder;
import org.eclipse.ecf.osgi.services.distribution.IProxyDistributionListener;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    public static final boolean autoCreateProxyContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.autoCreateProxyContainer", "true"));
    public static final boolean autoCreateHostContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.autoCreateHostContainer", "true"));
    public static final String defaultHostConfigType = System.getProperty("org.eclipse.ecf.osgi.services.distribution.defaultConfigType", "ecf.generic.server");
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker containerManagerTracker;
    private DistributionProviderImpl distributionProvider;
    private ServiceRegistration eventHookRegistration;
    private ServiceRegistration discoveredServiceTrackerRegistration;
    private ServiceRegistration proxyrsContainerFinderRegistration;
    private ServiceRegistration hostrsContainerFinderRegistration;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private ServiceTracker adapterManagerTracker;
    private ServiceTracker proxyrsContainerFinder;
    private ServiceTracker hostrsContainerFinder;
    private ServiceTracker hostRegistrationListenerServiceTracker;
    private ServiceTracker proxyDistributionListenerServiceTracker;
    private ServiceTracker idFactoryTracker;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected synchronized LogService getLogService() {
        if (this.context == null) {
            return null;
        }
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        String[] stringArray;
        plugin = this;
        this.context = ctxt;
        this.distributionProvider = new DistributionProviderImpl();
        DiscoveredServiceTrackerImpl dstImpl = new DiscoveredServiceTrackerImpl(this.distributionProvider);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.osgi.services.discovery.DiscoveredServiceTracker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.discoveredServiceTrackerRegistration = this.context.registerService(clazz.getName(), (Object)dstImpl, null);
        Properties proxyContainerFinderProps = new Properties();
        proxyContainerFinderProps.put("service.ranking", new Integer(Integer.MIN_VALUE));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.proxyrsContainerFinderRegistration = this.context.registerService(clazz2.getName(), (Object)new DefaultProxyContainerFinder(autoCreateProxyContainer), (Dictionary)proxyContainerFinderProps);
        EventHookImpl hook = new EventHookImpl(this.distributionProvider);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.osgi.framework.hooks.service.EventHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHookRegistration = this.context.registerService(clazz3.getName(), (Object)hook, null);
        Properties hostContainerFinderProps = new Properties();
        hostContainerFinderProps.put("service.ranking", new Integer(Integer.MIN_VALUE));
        if ("".equals(defaultHostConfigType) || "null".equals(defaultHostConfigType)) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = defaultHostConfigType;
        }
        String[] defaultHostConfigTypes = stringArray;
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.hostrsContainerFinderRegistration = this.context.registerService(clazz4.getName(), (Object)new DefaultHostContainerFinder(autoCreateHostContainer, defaultHostConfigTypes), (Dictionary)hostContainerFinderProps);
        try {
            ServiceReference[] refs = this.context.getServiceReferences(null, "(service.exported.interfaces=*)");
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    hook.handleRegisteredServiceEvent(refs[i], null);
                    ++i;
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext ctxt) throws Exception {
        if (this.discoveredServiceTrackerRegistration != null) {
            this.discoveredServiceTrackerRegistration.unregister();
            this.discoveredServiceTrackerRegistration = null;
        }
        if (this.proxyrsContainerFinderRegistration != null) {
            this.proxyrsContainerFinderRegistration.unregister();
            this.proxyrsContainerFinderRegistration = null;
        }
        if (this.eventHookRegistration != null) {
            this.eventHookRegistration.unregister();
            this.eventHookRegistration = null;
        }
        if (this.hostrsContainerFinderRegistration != null) {
            this.hostrsContainerFinderRegistration.unregister();
            this.hostrsContainerFinderRegistration = null;
        }
        if (this.containerManagerTracker != null) {
            this.containerManagerTracker.close();
            this.containerManagerTracker = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        if (this.distributionProvider != null) {
            this.distributionProvider.dispose();
            this.distributionProvider = null;
        }
        if (this.proxyrsContainerFinder != null) {
            this.proxyrsContainerFinder.close();
            this.proxyrsContainerFinder = null;
        }
        if (this.hostRegistrationListenerServiceTracker != null) {
            this.hostRegistrationListenerServiceTracker.close();
            this.hostRegistrationListenerServiceTracker = null;
        }
        if (this.proxyDistributionListenerServiceTracker != null) {
            this.proxyDistributionListenerServiceTracker.close();
            this.proxyDistributionListenerServiceTracker = null;
        }
        if (this.idFactoryTracker != null) {
            this.idFactoryTracker.close();
            this.idFactoryTracker = null;
        }
        Activator activator = this;
        synchronized (activator) {
            this.context = null;
        }
        plugin = null;
    }

    public synchronized IContainerManager getContainerManager() {
        if (this.context == null) {
            return null;
        }
        if (this.containerManagerTracker == null) {
            Class<?> clazz = class$5;
            if (clazz == null) {
                try {
                    clazz = class$5 = Class.forName("org.eclipse.ecf.core.IContainerManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.containerManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.containerManagerTracker.open();
        }
        return (IContainerManager)this.containerManagerTracker.getService();
    }

    public synchronized IProxyContainerFinder getProxyRemoteServiceContainerFinder() {
        if (this.context == null) {
            return null;
        }
        if (this.proxyrsContainerFinder == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IProxyContainerFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.proxyrsContainerFinder = new ServiceTracker(this.context, clazz.getName(), null);
            this.proxyrsContainerFinder.open();
        }
        return (IProxyContainerFinder)this.proxyrsContainerFinder.getService();
    }

    public synchronized IHostContainerFinder getHostRemoteServiceContainerFinder() {
        if (this.context == null) {
            return null;
        }
        if (this.hostrsContainerFinder == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IHostContainerFinder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.hostrsContainerFinder = new ServiceTracker(this.context, clazz.getName(), null);
            this.hostrsContainerFinder.open();
        }
        return (IHostContainerFinder)this.hostrsContainerFinder.getService();
    }

    public synchronized IHostDistributionListener[] getHostRegistrationListeners() {
        Object[] objs;
        if (this.context == null) {
            return null;
        }
        if (this.hostRegistrationListenerServiceTracker == null) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IHostDistributionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.hostRegistrationListenerServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.hostRegistrationListenerServiceTracker.open();
        }
        if ((objs = this.hostRegistrationListenerServiceTracker.getServices()) == null) {
            return null;
        }
        return Arrays.asList(objs).toArray(new IHostDistributionListener[0]);
    }

    public synchronized IProxyDistributionListener[] getProxyDistributionListeners() {
        Object[] objs;
        if (this.context == null) {
            return null;
        }
        if (this.proxyDistributionListenerServiceTracker == null) {
            Class<?> clazz = class$7;
            if (clazz == null) {
                try {
                    clazz = class$7 = Class.forName("org.eclipse.ecf.osgi.services.distribution.IProxyDistributionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.proxyDistributionListenerServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.proxyDistributionListenerServiceTracker.open();
        }
        if ((objs = this.proxyDistributionListenerServiceTracker.getServices()) == null) {
            return null;
        }
        return Arrays.asList(objs).toArray(new IProxyDistributionListener[0]);
    }

    public synchronized IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.context == null) {
            return null;
        }
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$8;
            if (clazz == null) {
                try {
                    clazz = class$8 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        return adapterManager;
    }

    public IIDFactory getIDFactory() {
        if (this.context == null) {
            return null;
        }
        if (this.idFactoryTracker == null) {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("org.eclipse.ecf.core.identity.IIDFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.idFactoryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.idFactoryTracker.open();
        }
        return (IIDFactory)this.idFactoryTracker.getService();
    }
}

