/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.osgi.services.discovery.RemoteServiceEndpointDescription;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.osgi.framework.ServiceRegistration;

public class RemoteServiceRegistration {
    private IRemoteServiceContainer rsContainer;
    private IRemoteServiceListener listener;
    private Map serviceRegistrations = new HashMap();

    public RemoteServiceRegistration(IRemoteServiceContainer rsContainer, IRemoteServiceListener l) {
        Assert.isNotNull((Object)rsContainer);
        Assert.isNotNull((Object)l);
        this.rsContainer = rsContainer;
        this.listener = l;
        this.getContainerAdapter().addRemoteServiceListener(this.listener);
    }

    IContainer getContainer() {
        return this.rsContainer.getContainer();
    }

    IRemoteServiceContainerAdapter getContainerAdapter() {
        return this.rsContainer.getContainerAdapter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        Map map = this.serviceRegistrations;
        synchronized (map) {
            if (this.listener != null) {
                this.getContainerAdapter().removeRemoteServiceListener(this.listener);
                this.listener = null;
            }
            if (this.rsContainer != null) {
                this.rsContainer = null;
            }
            this.serviceRegistrations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addServiceRegistration(IRemoteServiceReference ref, RemoteServiceEndpointDescription rsed, ServiceRegistration registration) {
        Map map = this.serviceRegistrations;
        synchronized (map) {
            ArrayList<RSEDAndSRAssoc> l = (ArrayList<RSEDAndSRAssoc>)this.serviceRegistrations.get(ref.getID());
            if (l == null) {
                l = new ArrayList<RSEDAndSRAssoc>();
                this.serviceRegistrations.put(ref.getID(), l);
            }
            l.add(new RSEDAndSRAssoc(rsed, registration));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RSEDAndSRAssoc[] removeServiceRegistration(IRemoteServiceReference reference) {
        this.getContainerAdapter().ungetRemoteService(reference);
        Map map = this.serviceRegistrations;
        synchronized (map) {
            List l = (List)this.serviceRegistrations.remove(reference.getID());
            if (l != null) {
                return l.toArray(new RSEDAndSRAssoc[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceRegistration removeServiceRegistration(RemoteServiceEndpointDescription rsed) {
        if (rsed == null) {
            return null;
        }
        ServiceRegistration reg = null;
        Map map = this.serviceRegistrations;
        synchronized (map) {
            IRemoteServiceID remoteServiceID = null;
            Iterator i = this.serviceRegistrations.keySet().iterator();
            while (i.hasNext()) {
                remoteServiceID = (IRemoteServiceID)i.next();
                List assocs = (List)this.serviceRegistrations.get(remoteServiceID);
                Iterator j = assocs.iterator();
                while (j.hasNext()) {
                    RSEDAndSRAssoc assoc = (RSEDAndSRAssoc)j.next();
                    if (!rsed.equals(assoc.getRSED())) continue;
                    j.remove();
                    reg = assoc.getSR();
                }
            }
            if (reg != null && remoteServiceID != null) {
                this.serviceRegistrations.remove(remoteServiceID);
            }
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean hasRSED(RemoteServiceEndpointDescription rsed) {
        if (rsed == null) {
            return false;
        }
        Map map = this.serviceRegistrations;
        synchronized (map) {
            Iterator i = this.serviceRegistrations.keySet().iterator();
            block3: while (true) {
                RSEDAndSRAssoc assoc;
                if (!i.hasNext()) {
                    return false;
                }
                List assocs = (List)this.serviceRegistrations.get(i.next());
                Iterator j = assocs.iterator();
                do {
                    if (!j.hasNext()) continue block3;
                } while (!rsed.equals(assoc = (RSEDAndSRAssoc)j.next()));
                break;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEmpty() {
        Map map = this.serviceRegistrations;
        synchronized (map) {
            return this.serviceRegistrations.size() == 0;
        }
    }

    class RSEDAndSRAssoc {
        RemoteServiceEndpointDescription rsed;
        ServiceRegistration sr;

        public RSEDAndSRAssoc(RemoteServiceEndpointDescription rsed, ServiceRegistration sr) {
            this.rsed = rsed;
            this.sr = sr;
        }

        public RemoteServiceEndpointDescription getRSED() {
            return this.rsed;
        }

        public ServiceRegistration getSR() {
            return this.sr;
        }
    }
}

