/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.Arrays;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.osgi.services.distribution.Activator;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;
import org.osgi.framework.ServiceReference;

public abstract class AbstractDistributionListener {
    protected int logLevel = 3;

    public AbstractDistributionListener(int logLevel) {
        this.logLevel = logLevel;
    }

    public AbstractDistributionListener() {
    }

    protected int getLogLevel() {
        return this.logLevel;
    }

    protected void log(ServiceReference serviceReference, String message, Throwable t) {
        Activator a = Activator.getDefault();
        if (a == null) {
            return;
        }
        a.log(serviceReference, this.getLogLevel(), message, t);
    }

    protected String createTabs(int tabLevel) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < tabLevel) {
            sb.append("\t");
            ++i;
        }
        return sb.toString();
    }

    protected String printID(int tabLevel, String label, ID id) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.createTabs(tabLevel)).append(label).append("=");
        sb.append(id == null ? "null" : id.toExternalForm());
        return sb.toString();
    }

    protected String printRemoteServiceRegistration(int tabLevel, IRemoteServiceRegistration remoteRegistration) {
        StringBuffer sb = new StringBuffer();
        if (remoteRegistration != null) {
            sb.append(this.printID(tabLevel, "remoteServiceID", (ID)remoteRegistration.getID()));
            sb.append("\n");
            sb.append(this.createTabs(tabLevel)).append("properties").append("\n").append(this.printRemoteServiceReferenceProperties(tabLevel + 1, remoteRegistration.getReference())).append("\n");
        }
        return sb.toString();
    }

    protected String printRemoteServiceReference(int tabLevel, IRemoteServiceReference remoteReference) {
        StringBuffer sb = new StringBuffer();
        if (remoteReference != null) {
            sb.append(this.printID(tabLevel, "remoteServiceID", (ID)remoteReference.getID()));
            sb.append("\n");
            sb.append(this.createTabs(tabLevel)).append("properties").append("\n").append(this.printRemoteServiceReferenceProperties(tabLevel + 1, remoteReference)).append("\n");
        }
        return sb.toString();
    }

    protected String printRemoteServiceReferenceProperties(int tabLevel, IRemoteServiceReference remoteReference) {
        StringBuffer sb = new StringBuffer();
        if (remoteReference != null) {
            String[] propKeys = remoteReference.getPropertyKeys();
            int i = 0;
            while (i < propKeys.length) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(this.createTabs(tabLevel)).append("name=").append(propKeys[i]);
                Object value = remoteReference.getProperty(propKeys[i]);
                sb.append(";value[");
                Class<?> valueClass = value.getClass();
                String classStr = "";
                String valueStr = "";
                if (valueClass.isArray()) {
                    classStr = String.valueOf(valueClass.getComponentType().getName()) + "[]";
                    valueStr = Arrays.asList((Object[])value).toString();
                } else {
                    classStr = valueClass.getName();
                    valueStr = value.toString();
                }
                sb.append(classStr).append("]").append("=").append(valueStr);
                ++i;
            }
        }
        return sb.toString();
    }

    protected String printRemoteServiceContainer(int tabLevel, IRemoteServiceContainer remoteServiceContainer) {
        StringBuffer sb = new StringBuffer();
        IContainer container = remoteServiceContainer.getContainer();
        if (container != null) {
            sb.append(this.printID(tabLevel, "ID", container.getID()));
            sb.append("\n");
            sb.append(this.printID(tabLevel, "connectedID", container.getConnectedID()));
        }
        return sb.toString();
    }
}

