/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.osgi.services.distribution.AbstractContainerFinder;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

public abstract class AbstractHostContainerFinder
extends AbstractContainerFinder {
    private static final String NODEFAULT = "<<nodefault>>";
    protected String[] defaultConfigTypes;
    static /* synthetic */ Class class$0;

    public AbstractHostContainerFinder(String[] defaultConfigTypes) {
        this.defaultConfigTypes = defaultConfigTypes;
    }

    protected Collection findExistingHostContainers(ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = this.getContainers();
        if (containers == null || containers.length == 0) {
            return results;
        }
        int i = 0;
        while (i < containers.length) {
            ContainerTypeDescription description;
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter != null && (description = this.getContainerTypeDescription(containers[i])) != null) {
                if (this.matchExistingHostContainer(serviceReference, containers[i], adapter, description, serviceExportedConfigs, serviceIntents)) {
                    this.trace("findExistingContainers", "INCLUDING containerID=" + containers[i].getID() + "configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + "intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("findExistingContainers", "EXCLUDING containerID=" + containers[i].getID() + "configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + "intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                }
            }
            ++i;
        }
        return results;
    }

    protected boolean matchHostContainerToConnectTarget(ServiceReference serviceReference, IContainer container) {
        Object target = serviceReference.getProperty("org.eclipse.ecf.containerConnectTarget");
        if (target == null) {
            return true;
        }
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            try {
                this.connectHostContainer(serviceReference, container, target);
            }
            catch (Exception e) {
                this.logException("doConnectContainer containerID=" + container.getID() + " target=" + target, e);
                return false;
            }
            return true;
        }
        ID targetID = this.createTargetID(container, target);
        return connectedID.equals((Object)targetID);
    }

    protected boolean matchExistingHostContainer(ServiceReference serviceReference, IContainer container, IRemoteServiceContainerAdapter adapter, ContainerTypeDescription description, String[] requiredConfigTypes, String[] requiredServiceIntents) {
        return this.matchHostSupportedConfigTypes(requiredConfigTypes, description) && this.matchHostSupportedIntents(requiredServiceIntents, description) && this.matchHostContainerID(serviceReference, container) && this.matchHostContainerToConnectTarget(serviceReference, container);
    }

    protected boolean matchHostContainerID(ServiceReference serviceReference, IContainer container) {
        ID containerID = container.getID();
        if (containerID == null) {
            return false;
        }
        ID requiredContainerID = (ID)serviceReference.getProperty("org.eclipse.ecf.containerID");
        if (requiredContainerID != null) {
            return requiredContainerID.equals((Object)containerID);
        }
        Namespace ns = containerID.getNamespace();
        Object cid = serviceReference.getProperty("org.eclipse.ecf.containerFactoryArgs");
        if (cid == null) {
            return true;
        }
        ID cID = null;
        if (cid instanceof ID) {
            cID = (ID)cid;
        } else if (cid instanceof String) {
            cID = this.getIDFactory().createID(ns, (String)cid);
        } else if (cid instanceof Object[]) {
            Object cido = ((Object[])cid)[0];
            cID = this.getIDFactory().createID(ns, new Object[]{cido});
        }
        if (cID == null) {
            return true;
        }
        return containerID.equals((Object)cID);
    }

    protected boolean matchHostSupportedConfigTypes(String[] requiredConfigTypes, ContainerTypeDescription containerTypeDescription) {
        if (requiredConfigTypes == null) {
            return false;
        }
        String[] supportedConfigTypes = this.getSupportedConfigTypes(containerTypeDescription);
        if (supportedConfigTypes == null || supportedConfigTypes.length == 0) {
            return false;
        }
        List<String> supportedConfigTypesList = Arrays.asList(supportedConfigTypes);
        List<String> requiredConfigTypesList = Arrays.asList(requiredConfigTypes);
        boolean result = true;
        Iterator<String> i = requiredConfigTypesList.iterator();
        while (i.hasNext()) {
            result &= supportedConfigTypesList.contains(i.next());
        }
        return result;
    }

    protected Collection createAndConfigureHostContainers(ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] requiredIntents) {
        List<String> requiredConfigsList;
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        ContainerTypeDescription[] descriptions = this.getContainerTypeDescriptions();
        if (descriptions == null) {
            return results;
        }
        if (requiredConfigs == null || requiredConfigs.length == 0) {
            this.createDefaultRSContainers(serviceReference, descriptions, results);
        } else {
            int i = 0;
            while (i < descriptions.length) {
                IRemoteServiceContainer rsContainer = this.createMatchingContainer(descriptions[i], serviceReference, serviceExportedInterfaces, requiredConfigs, requiredIntents);
                if (rsContainer != null) {
                    results.add(rsContainer);
                }
                ++i;
            }
        }
        if (results.size() == 0 && requiredConfigs != null && requiredConfigs.length > 0 && !(requiredConfigsList = Arrays.asList(requiredConfigs)).contains(NODEFAULT)) {
            this.createDefaultRSContainers(serviceReference, descriptions, results);
        }
        return results;
    }

    private void createDefaultRSContainers(ServiceReference serviceReference, ContainerTypeDescription[] descriptions, List results) {
        ContainerTypeDescription[] ctds = this.getContainerTypeDescriptionsForDefaultConfigTypes(descriptions);
        if (ctds != null) {
            int i = 0;
            while (i < ctds.length) {
                IRemoteServiceContainer rsContainer = this.createRSContainer(serviceReference, ctds[i]);
                if (rsContainer != null) {
                    results.add(rsContainer);
                }
                ++i;
            }
        }
    }

    protected ContainerTypeDescription[] getContainerTypeDescriptionsForDefaultConfigTypes(ContainerTypeDescription[] descriptions) {
        String[] defaultConfigTypes = this.getDefaultConfigTypes();
        if (defaultConfigTypes == null || defaultConfigTypes.length == 0) {
            return null;
        }
        ArrayList<ContainerTypeDescription> results = new ArrayList<ContainerTypeDescription>();
        int i = 0;
        while (i < descriptions.length) {
            String[] supportedConfigTypes = descriptions[i].getSupportedConfigs();
            if (supportedConfigTypes != null && this.matchDefaultConfigTypes(defaultConfigTypes, supportedConfigTypes)) {
                results.add(descriptions[i]);
            }
            ++i;
        }
        return results.toArray(new ContainerTypeDescription[0]);
    }

    protected boolean matchDefaultConfigTypes(String[] defaultConfigTypes, String[] supportedConfigTypes) {
        List<String> supportedConfigTypesList = Arrays.asList(supportedConfigTypes);
        int i = 0;
        while (i < defaultConfigTypes.length) {
            if (supportedConfigTypesList.contains(defaultConfigTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] getDefaultConfigTypes() {
        return this.defaultConfigTypes;
    }

    protected IRemoteServiceContainer createMatchingContainer(ContainerTypeDescription containerTypeDescription, ServiceReference serviceReference, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] requiredIntents) {
        if (this.matchHostSupportedConfigTypes(requiredConfigs, containerTypeDescription) && this.matchHostSupportedIntents(requiredIntents, containerTypeDescription)) {
            return this.createRSContainer(serviceReference, containerTypeDescription);
        }
        return null;
    }

    protected IRemoteServiceContainer createRSContainer(ServiceReference serviceReference, ContainerTypeDescription containerTypeDescription) {
        try {
            IRemoteServiceContainerAdapter adapter;
            IContainer container = this.createContainer(serviceReference, containerTypeDescription);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteServiceContainerAdapter)container.getAdapter((Class)clazz)) == null) {
                throw new ContainerCreateException("Container does not implement IRemoteServiceContainerAdapter");
            }
            return new RemoteServiceContainer(container, adapter);
        }
        catch (Exception e) {
            this.logException("Exception creating container from ContainerTypeDescription=" + containerTypeDescription, e);
            return null;
        }
    }

    protected void connectHostContainer(ServiceReference serviceReference, IContainer container, Object target) throws ContainerConnectException, IDCreateException {
        ID targetID = this.createTargetID(container, target);
        Object context = serviceReference.getProperty("org.eclipse.ecf.containerConnectContext");
        IConnectContext connectContext = null;
        if (context != null) {
            connectContext = this.createConnectContext(serviceReference, container, context);
        }
        container.connect(targetID, connectContext);
    }

    protected boolean matchHostSupportedIntents(String[] serviceRequiredIntents, ContainerTypeDescription containerTypeDescription) {
        if (serviceRequiredIntents == null) {
            return true;
        }
        String[] supportedIntents = this.getSupportedIntents(containerTypeDescription);
        if (supportedIntents == null) {
            return false;
        }
        List<String> supportedIntentsList = Arrays.asList(supportedIntents);
        boolean result = true;
        int i = 0;
        while (i < serviceRequiredIntents.length) {
            result = result && supportedIntentsList.contains(serviceRequiredIntents[i]);
            ++i;
        }
        return result;
    }
}

