/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.internal.BundleStoppingListener;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class DiscoveryActivator
implements BundleActivator {
    private static BundleContext context;
    private ServiceRegistration discoveryRegistration;
    private static Set<BundleStoppingListener> stopListeners;
    private ServiceTracker confTracker;
    private ServiceTracker logServiceTraker;

    static {
        stopListeners = new HashSet<BundleStoppingListener>();
    }

    public void start(BundleContext ctxt) {
        context = ctxt;
        Properties props = new Properties();
        props.put("org.eclipse.ecf.discovery.containerName", "ecf.discovery.zoodiscovery");
        props.put("org.eclipse.ecf.discovery.containerName", "ecf.discovery.zoodiscovery");
        this.discoveryRegistration = ctxt.registerService(new String[]{IDiscoveryLocator.class.getName(), IDiscoveryAdvertiser.class.getName()}, (Object)ZooDiscoveryContainer.getSingleton(), (Dictionary)props);
        ZooDiscoveryContainer.getSingleton().setDiscoveryProperties(props);
        this.logServiceTraker = new ServiceTracker(ctxt, LogService.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                Logger.bindLogService((LogService)this.context.getService(reference));
                return super.addingService(reference);
            }

            public void removedService(ServiceReference reference, Object service) {
                Logger.unbindLogService((LogService)service);
                this.removedService(reference, service);
                super.removedService(reference, service);
            }
        };
        this.logServiceTraker.open(true);
    }

    public void stop(BundleContext c) throws Exception {
        this.dispose();
        PrettyPrinter.prompt(4, null);
    }

    private void dispose() {
        for (BundleStoppingListener l : stopListeners) {
            l.bundleStopping();
        }
        stopListeners.clear();
        ZooDiscoveryContainer.getSingleton().shutdown();
        if (this.discoveryRegistration != null) {
            this.discoveryRegistration.unregister();
        }
        if (this.confTracker != null) {
            this.confTracker.close();
        }
        ZooDiscoveryContainer.CACHED_THREAD_POOL.shutdown();
    }

    public static BundleContext getContext() {
        return context;
    }

    public static void registerBundleStoppingListner(BundleStoppingListener l) {
        stopListeners.add(l);
    }
}

