/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryNamespace;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceID;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceTypeID;
import org.eclipse.ecf.provider.zookeeper.core.internal.Configurator;
import org.eclipse.ecf.provider.zookeeper.core.internal.IService;
import org.eclipse.ecf.provider.zookeeper.node.internal.INode;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdvertisedService
extends ServiceInfo
implements INode,
IService {
    private static final long serialVersionUID = 1001026250299416572L;
    private String uuid;
    private Properties internalProperties = new Properties();
    private static Map<String, IServiceInfo> publishedServices = new HashMap<String, IServiceInfo>();
    private ServiceReference serviceReference;

    public AdvertisedService(ServiceReference ref) {
        Assert.isNotNull((Object)ref);
        this.serviceReference = ref;
        this.uuid = UUID.randomUUID().toString();
        String[] services = (String[])this.serviceReference.getProperty("objectClass");
        String[] stringArray = this.serviceReference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String k = stringArray[n2];
            Object value = this.serviceReference.getProperty(k);
            if (value instanceof String && ((String)value).contains("localhost")) {
                this.internalProperties.put(k, ((String)value).replace("localhost", Geo.getHost()));
            } else {
                this.internalProperties.put(k, this.serviceReference.getProperty(k));
            }
            ++n2;
        }
        Object serviceTypeID = ServiceIDFactory.getDefault().createServiceTypeID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), services, IServiceTypeID.DEFAULT_PROTO);
        serviceTypeID = new ZooDiscoveryServiceTypeID((ZooDiscoveryNamespace)ZooDiscoveryContainer.getSingleton().getConnectNamespace(), (IServiceTypeID)serviceTypeID, this.serviceReference.getProperty("service.id").toString());
        this.serviceID = new ZooDiscoveryServiceID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), (IServiceTypeID)serviceTypeID, Geo.getLocation());
        this.properties = new ServiceProperties(this.internalProperties);
        this.internalProperties.put("objectClass", this.arrayToString(services));
        this.internalProperties.put("discovery.service.location", Geo.getLocation());
        this.internalProperties.put("discovery.service.weight", (Object)this.getWeight());
        this.internalProperties.put("discovery.service.priority", (Object)this.getPriority());
        this.internalProperties.put("node.property.name.protocols", this.arrayToString(IServiceTypeID.DEFAULT_PROTO));
        this.internalProperties.put("node.property.name.scope", this.arrayToString(IServiceTypeID.DEFAULT_SCOPE));
        this.internalProperties.put("node.property.name.na", "iana");
        publishedServices.put(serviceTypeID.getInternal(), this);
    }

    public AdvertisedService(IServiceInfo serviceInfo) {
        super(serviceInfo.getLocation(), serviceInfo.getServiceName(), serviceInfo.getServiceID().getServiceTypeID(), serviceInfo.getPriority(), serviceInfo.getWeight(), serviceInfo.getServiceProperties());
        this.uuid = UUID.randomUUID().toString();
        Enumeration enumm = serviceInfo.getServiceProperties().getPropertyNames();
        while (enumm.hasMoreElements()) {
            String k = (String)enumm.nextElement();
            Object value = serviceInfo.getServiceProperties().getProperty(k);
            byte[] bytes = serviceInfo.getServiceProperties().getPropertyBytes(k);
            if (value instanceof String && ((String)value).contains("localhost")) {
                this.internalProperties.put(k, ((String)value).replace("localhost", Geo.getHost()));
                continue;
            }
            if (bytes != null) {
                this.internalProperties.put("_bytes_" + k, new String(bytes));
                continue;
            }
            this.internalProperties.put(k, value);
        }
        this.internalProperties.put("node.property.name.protocols", this.arrayToString(this.getServiceID().getServiceTypeID().getProtocols()));
        this.internalProperties.put("node.property.name.scope", this.arrayToString(this.getServiceID().getServiceTypeID().getScopes()));
        this.internalProperties.put("node.property.name.services", this.arrayToString(this.getServiceID().getServiceTypeID().getServices()));
        this.internalProperties.put("node.property.name.na", this.getServiceID().getServiceTypeID().getNamingAuthority());
        this.internalProperties.put("discovery.service.location", Geo.getLocation());
        this.internalProperties.put("discovery.service.weight", (Object)this.getWeight());
        this.internalProperties.put("discovery.service.priority", (Object)this.getPriority());
        publishedServices.put(serviceInfo.getServiceID().getServiceTypeID().getInternal(), this);
    }

    public static Map<String, IServiceInfo> getPublishedServices() {
        return Collections.unmodifiableMap(publishedServices);
    }

    public static synchronized IServiceInfo removePublished(String id) {
        return publishedServices.remove(id);
    }

    @Override
    public Properties getProperties() {
        return this.internalProperties;
    }

    public String getNodeId() {
        return this.uuid;
    }

    @Override
    public void regenerateNodeId() {
        this.uuid = UUID.randomUUID().toString();
    }

    public URI getLocation() {
        return this.serviceID.getLocation();
    }

    public IServiceID getServiceID() {
        return this.serviceID;
    }

    public int compareTo(Object o) {
        Assert.isTrue((o != null && o instanceof IServiceInfo ? 1 : 0) != 0, (String)"incompatible types for compare");
        return this.getServiceID().getName().compareTo(((IServiceInfo)o).getServiceID().getName());
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    @Override
    public byte[] getPropertiesAsBytes() {
        return this.getPropertiesAsString().getBytes();
    }

    @Override
    public String getPropertiesAsString() {
        String props = "";
        for (Object k : this.getProperties().keySet()) {
            props = String.valueOf(props) + k + "=" + this.getProperties().get(k) + "\n";
        }
        return props;
    }

    @Override
    public String getPath() {
        return String.valueOf(this.getNodeId()) + "_uri_" + Geo.getHost() + "_zdid_" + Configurator.INSTANCE.getID().getName();
    }

    @Override
    public String getAbsolutePath() {
        return "/zoodiscovery_root/" + this.getPath();
    }

    @Override
    public boolean isLocalNode() {
        return Geo.isLocal(this.getAbsolutePath());
    }

    @Override
    public IService getWrappedService() {
        return this;
    }

    private String arrayToString(String[] arr) {
        String s = "";
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            s = String.valueOf(s) + c + " ";
            ++n2;
        }
        return s;
    }
}

