/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.net.URI;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceID;
import org.eclipse.ecf.provider.zookeeper.core.internal.IService;
import org.eclipse.ecf.provider.zookeeper.core.internal.Localizer;
import org.eclipse.ecf.provider.zookeeper.core.internal.Notification;
import org.eclipse.ecf.provider.zookeeper.node.internal.INode;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;

public class DiscoverdService
extends ServiceInfo
implements IService,
INode {
    private static final long serialVersionUID = 3072424087109599612L;
    private String uuid;
    private URI location;
    private IServiceTypeID serviceTypeID;
    private Properties props;

    public DiscoverdService(String path, Properties propMap) {
        Assert.isNotNull((Object)propMap);
        this.uuid = path.split("_uri_")[0];
        this.location = URI.create((String)propMap.remove("discovery.service.location"));
        this.priority = Integer.parseInt((String)propMap.remove("discovery.service.priority"));
        this.weight = Integer.parseInt((String)propMap.remove("discovery.service.weight"));
        String[] services = (String[])propMap.remove("objectClass");
        if (services == null) {
            services = (String[])propMap.remove("node.property.name.services");
        }
        String na = (String)propMap.remove("node.property.name.na");
        String[] protocols = (String[])propMap.remove("node.property.name.protocols");
        String[] scopes = (String[])propMap.remove("node.property.name.scope");
        this.properties = this.createServiceProperties(propMap);
        this.serviceTypeID = ServiceIDFactory.getDefault().createServiceTypeID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), services, scopes, protocols, na);
        this.serviceID = new ZooDiscoveryServiceID(ZooDiscoveryContainer.getSingleton().getConnectNamespace(), this.serviceTypeID, this.location);
    }

    private ServiceProperties createServiceProperties(Properties props) {
        ServiceProperties result = new ServiceProperties();
        for (Object k : props.keySet()) {
            String value = (String)props.get(k);
            if (((String)k).startsWith("_bytes_")) {
                result.setPropertyBytes(((String)k).split("_bytes_")[1], value.getBytes());
                continue;
            }
            result.setProperty((String)k, (Object)value);
        }
        this.props = result.asProperties();
        return result;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void dispose() {
        PrettyPrinter.prompt(6, this);
        Localizer.getSingleton().localize(new Notification(this, 2));
    }

    public String getNodeId() {
        return this.uuid;
    }

    public void regenerateNodeId() {
        this.uuid = UUID.randomUUID().toString();
    }

    public String getName() {
        return this.uuid;
    }

    public Namespace getNamespace() {
        return ZooDiscoveryContainer.getSingleton().getConnectNamespace();
    }

    public String toExternalForm() {
        return this.uuid;
    }

    public int compareTo(Object o) {
        Assert.isTrue((o != null && o instanceof DiscoverdService ? 1 : 0) != 0, (String)"incompatible types for compare");
        return this.getServiceID().getName().compareTo(((DiscoverdService)o).getServiceID().getName());
    }

    public byte[] getPropertiesAsBytes() {
        return this.getPropertiesAsString().getBytes();
    }

    public String getPropertiesAsString() {
        String props = "";
        for (Object k : this.getProperties().keySet()) {
            props = String.valueOf(props) + k + "=" + this.getProperties().get(k) + "\n";
        }
        return props;
    }

    public String getPath() {
        return String.valueOf(this.getServiceID().getName()) + "_uri_" + this.getLocation();
    }

    public String getAbsolutePath() {
        return "/zoodiscovery_root/" + this.getPath();
    }

    public boolean isLocalNode() {
        return Geo.isLocal(this.getAbsolutePath());
    }

    public IService getWrappedService() {
        return this;
    }
}

