/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.node.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.provider.zookeeper.core.DiscoverdService;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.eclipse.ecf.provider.zookeeper.node.internal.NodeReader;
import org.eclipse.ecf.provider.zookeeper.node.internal.WatchManager;
import org.eclipse.ecf.provider.zookeeper.util.Geo;
import org.eclipse.ecf.provider.zookeeper.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadRoot
implements Watcher,
AsyncCallback.ChildrenCallback {
    ZooKeeper readKeeper;
    String ip;
    private WatchManager watchManager;
    private boolean isConnected;
    private Map<String, NodeReader> nodeReaders = Collections.synchronizedMap(new HashMap());
    private Map<String, DiscoverdService> discoverdServices;
    private Map<String, List<DiscoverdService>> perTypeDiscoverdServices;

    ReadRoot(String ip, WatchManager watchManager) {
        Assert.isNotNull((Object)ip);
        Assert.isNotNull((Object)watchManager);
        this.ip = ip;
        this.watchManager = watchManager;
        this.discoverdServices = Collections.synchronizedMap(new HashMap());
        this.perTypeDiscoverdServices = Collections.synchronizedMap(new HashMap());
        this.connect();
    }

    public synchronized void process(final WatchedEvent event) {
        if (this.watchManager.isDisposed()) {
            return;
        }
        ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

            public void run() {
                switch (event.getState()) {
                    case Disconnected: {
                        ReadRoot.this.isConnected = false;
                        ReadRoot.this.connect();
                        break;
                    }
                    case Expired: {
                        ReadRoot.this.isConnected = false;
                        ReadRoot.this.connect();
                        break;
                    }
                    case SyncConnected: {
                        if (ReadRoot.this.isConnected) break;
                        ReadRoot.this.isConnected = true;
                        ReadRoot.this.watchManager.addZooKeeper(ReadRoot.this.readKeeper);
                        ReadRoot.this.readKeeper.exists("/zoodiscovery_root", (Watcher)ReadRoot.this, null, null);
                        ReadRoot.this.readKeeper.getChildren("/zoodiscovery_root", (Watcher)ReadRoot.this, (AsyncCallback.ChildrenCallback)ReadRoot.this, null);
                    }
                }
                switch (event.getType()) {
                    case NodeDeleted: {
                        if (event.getPath() == null || event.getPath().equals("/zoodiscovery_root")) break;
                        ReadRoot.this.nodeReaders.remove(event.getPath());
                        break;
                    }
                    case NodeChildrenChanged: {
                        if (!ReadRoot.this.isConnected) break;
                        ReadRoot.this.readKeeper.exists("/zoodiscovery_root", (Watcher)ReadRoot.this, null, null);
                        ReadRoot.this.readKeeper.getChildren("/zoodiscovery_root", (Watcher)ReadRoot.this, (AsyncCallback.ChildrenCallback)ReadRoot.this, null);
                    }
                }
            }
        });
    }

    private synchronized void connect() {
        if (this.isConnected || this.watchManager.isDisposed()) {
            return;
        }
        try {
            this.nodeReaders.clear();
            if (this.readKeeper != null) {
                this.readKeeper.close();
                this.readKeeper = null;
                this.watchManager.removeZooKeeper(this.readKeeper);
            }
            this.readKeeper = new ZooKeeper(this.ip, 3000, (Watcher)this);
        }
        catch (Exception e) {
            Logger.log(4, e.getMessage(), e);
        }
    }

    public synchronized void processResult(int rc, final String path, Object ctx, final List<String> children) {
        if (this.watchManager.isDisposed()) {
            return;
        }
        ZooDiscoveryContainer.CACHED_THREAD_POOL.execute(new Runnable(){

            public void run() {
                if (path == null || children == null || children.size() == 0) {
                    ReadRoot.this.readKeeper.getChildren("/zoodiscovery_root", (Watcher)ReadRoot.this, (AsyncCallback.ChildrenCallback)ReadRoot.this, null);
                    return;
                }
                for (String p : children) {
                    if (Geo.isOwnPublication(p) || ReadRoot.this.nodeReaders.containsKey(p)) continue;
                    NodeReader nr = new NodeReader(p, ReadRoot.this);
                    ReadRoot.this.readKeeper.exists(nr.getAbsolutePath(), (Watcher)ReadRoot.this, null, null);
                    ReadRoot.this.nodeReaders.put(nr.getPath(), nr);
                }
            }
        });
    }

    public ZooKeeper getReadKeeper() {
        return this.readKeeper;
    }

    public String getIp() {
        return this.ip;
    }

    public Map<String, DiscoverdService> getDiscoverdServices() {
        return this.discoverdServices;
    }

    public Map<String, List<DiscoverdService>> getPerTypeDiscoverdServices() {
        return this.perTypeDiscoverdServices;
    }
}

