/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.node.internal;

import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.provider.zookeeper.node.internal.WatchManager;
import org.eclipse.ecf.provider.zookeeper.util.Logger;
import org.eclipse.ecf.provider.zookeeper.util.PrettyPrinter;

class WriteRoot
implements Watcher {
    private ZooKeeper writeKeeper;
    private String ip;
    private WatchManager watchManager;
    private boolean isConnected;

    WriteRoot(String ip, WatchManager watchManager) {
        Assert.isNotNull((Object)ip);
        Assert.isNotNull((Object)watchManager);
        this.ip = ip;
        this.watchManager = watchManager;
        this.initWriteKeeper();
    }

    public void process(WatchedEvent event) {
        switch (event.getState()) {
            case Disconnected: {
                this.isConnected = false;
                this.watchManager.unpublishAll();
                this.connect();
                break;
            }
            case Expired: {
                this.isConnected = false;
                this.watchManager.unpublishAll();
                this.connect();
                break;
            }
            case SyncConnected: {
                if (this.isConnected) break;
                this.isConnected = true;
                this.watchManager.republishAll();
            }
        }
    }

    private void connect() {
        if (this.isConnected || this.watchManager.isDisposed()) {
            return;
        }
        try {
            if (this.writeKeeper != null) {
                this.writeKeeper.close();
                this.writeKeeper = null;
                this.watchManager.removeZooKeeper(this.writeKeeper);
            }
            this.writeKeeper = new ZooKeeper(this.ip, 3000, (Watcher)this);
        }
        catch (Exception e) {
            Logger.log(4, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initWriteKeeper() {
        try {
            if (this.watchManager.getConfig().isQuorum() || this.watchManager.getConfig().isStandAlone()) {
                int port = this.watchManager.getConfig().getClientPort();
                if (port != 0) {
                    this.ip = String.valueOf(this.ip) + ":" + port;
                }
            } else if (this.watchManager.getConfig().isCentralized()) {
                this.ip = this.watchManager.getConfig().getServerIps();
            }
            this.writeKeeper = new ZooKeeper(this.ip, 3000, (Watcher)this);
            while (!this.isConnected) {
                if (this.watchManager.isDisposed()) {
                    try {
                        this.writeKeeper.close();
                    }
                    catch (Throwable port) {}
                    break;
                }
                try {
                    Stat s = this.writeKeeper.exists("/zoodiscovery_root", (Watcher)this);
                    this.isConnected = true;
                    if (s != null) continue;
                    this.writeKeeper.create("/zoodiscovery_root", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException e) {
                    if (e.code().equals((Object)KeeperException.Code.CONNECTIONLOSS)) {
                        this.isConnected = false;
                        PrettyPrinter.attemptingConnectionTo(this.ip);
                        continue;
                    }
                    Logger.log(1, "Error while trying to connect to " + this.ip, (Exception)((Object)e));
                }
            }
            WriteRoot e = this;
            synchronized (e) {
                this.notifyAll();
            }
            this.watchManager.addZooKeeper(this.writeKeeper);
        }
        catch (Exception e) {
            Logger.log(4, e.getMessage(), e);
        }
    }

    public ZooKeeper getWriteKeeper() {
        return this.writeKeeper;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public WatchManager getWatchManager() {
        return this.watchManager;
    }
}

