/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ecf.provider.zookeeper.DiscoveryActivator;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.osgi.service.log.LogService;

public class Logger {
    private static Set<LogService> logServices = new HashSet<LogService>();

    public static void bindLogService(LogService ls) {
        logServices.add(ls);
    }

    public static void unbindLogService(LogService ls) {
        logServices.remove(ls);
    }

    public static void log(int level, String message, Exception e) {
        if (logServices.isEmpty()) {
            if (e == null) {
                System.err.println(message);
            } else {
                e.printStackTrace();
            }
            return;
        }
        for (LogService ls : logServices) {
            ls.log(DiscoveryActivator.getContext().getServiceReference(ZooDiscoveryContainer.class.getName()), level, message, (Throwable)e);
        }
    }

    public static void log(int level, String message, Throwable t) {
        if (logServices.isEmpty()) {
            t.printStackTrace();
            return;
        }
        for (LogService ls : logServices) {
            ls.log(DiscoveryActivator.getContext().getServiceReference(ZooDiscoveryContainer.class.getName()), level, message, t);
        }
    }
}

