/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.CallbackRemoteCallListener;
import org.eclipse.ecf.remoteservice.IAsyncCallback;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;

public abstract class AbstractRemoteService
implements IRemoteService,
InvocationHandler {
    protected static final Object[] EMPTY_ARGS = new Object[0];

    protected abstract String[] getInterfaceClassNames();

    protected abstract IRemoteServiceID getRemoteServiceID();

    protected abstract IRemoteServiceReference getRemoteServiceReference();

    protected Class loadInterfaceClass(String className) throws ClassNotFoundException {
        return Class.forName(className);
    }

    protected IRemoteService getRemoteService() {
        return this;
    }

    protected long getDefaultTimeout() {
        return IRemoteCall.DEFAULT_TIMEOUT;
    }

    public IFuture callAsync(final IRemoteCall call) {
        JobsExecutor executor = new JobsExecutor(NLS.bind((String)"callAsynch({0}", (Object)call.getMethod()));
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractRemoteService.this.callSync(call);
            }
        }, null);
    }

    public Object getProxy() throws ECFException {
        try {
            Class<?> clazz;
            String[] clazzes = this.getInterfaceClassNames();
            ArrayList classes = new ArrayList();
            int i = 0;
            while (i < clazzes.length) {
                Class c = this.loadInterfaceClass(clazzes[i]);
                classes.add(c);
                Class asyncRemoteServiceProxyClass = this.findAsyncRemoteServiceProxyClass(c);
                if (asyncRemoteServiceProxyClass != null && asyncRemoteServiceProxyClass.isInterface()) {
                    classes.add(asyncRemoteServiceProxyClass);
                }
                ++i;
            }
            try {
                clazz = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classes.add(clazz);
            return this.createProxy(classes.toArray(new Class[0]));
        }
        catch (Exception e) {
            ECFException except = new ECFException("Failed to create proxy", (Throwable)e);
            this.logWarning("Exception in remote service getProxy", (Throwable)except);
            throw except;
        }
        catch (NoClassDefFoundError e) {
            ECFException except = new ECFException("Failed to load proxy interface class", (Throwable)e);
            this.logWarning("Could not load class for getProxy", (Throwable)except);
            throw except;
        }
    }

    protected Object createProxy(Class[] classes) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), classes, (InvocationHandler)this);
    }

    protected Class findAsyncRemoteServiceProxyClass(Class c) {
        String proxyClassName = this.convertInterfaceNameToAsyncInterfaceName(c.getName());
        try {
            return Class.forName(proxyClassName);
        }
        catch (Exception e) {
            this.logWarning("No async remote service interface found with name=" + proxyClassName + " for proxy service class=" + c.getName(), e);
            return null;
        }
        catch (NoClassDefFoundError e) {
            this.logWarning("Async remote service interface with name=" + proxyClassName + " could not be loaded for proxy service class=" + c.getName(), e);
            return null;
        }
    }

    protected String convertInterfaceNameToAsyncInterfaceName(String interfaceName) {
        return String.valueOf(interfaceName) + "Async";
    }

    protected Object[] getCallParametersForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return args == null ? EMPTY_ARGS : args;
    }

    protected long getCallTimeoutForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return IRemoteCall.DEFAULT_TIMEOUT;
    }

    protected String getCallMethodNameForProxyInvoke(Method method, Object[] args) {
        return method.getName();
    }

    protected Object invokeObject(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("toString")) {
            String[] clazzes = this.getInterfaceClassNames();
            String proxyClass = clazzes.length == 1 ? clazzes[0] : Arrays.asList(clazzes).toString();
            return String.valueOf(proxyClass) + ".proxy@" + this.getRemoteServiceID();
        }
        if (method.getName().equals("hashCode")) {
            return new Integer(this.hashCode());
        }
        if (method.getName().equals("equals")) {
            if (args == null || args.length == 0) {
                return Boolean.FALSE;
            }
            try {
                return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
            }
            catch (IllegalArgumentException e) {
                return Boolean.FALSE;
            }
        }
        if (method.getName().equals("getRemoteService")) {
            return this.getRemoteService();
        }
        if (method.getName().equals("getRemoteServiceReference")) {
            return this.getRemoteServiceReference();
        }
        return null;
    }

    protected Object invokeSync(IRemoteCall call) throws ECFException {
        return this.callSync(call);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Class<?> clazz;
            Object resultObject = this.invokeObject(proxy, method, args);
            if (resultObject != null) {
                return resultObject;
            }
            try {
                clazz = Class.forName("org.eclipse.ecf.remoteservice.IAsyncRemoteServiceProxy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (Arrays.asList(method.getDeclaringClass().getInterfaces()).contains(clazz)) {
                return this.invokeAsync(method, args);
            }
            final String callMethod = this.getCallMethodNameForProxyInvoke(method, args);
            final Object[] callParameters = this.getCallParametersForProxyInvoke(callMethod, method, args);
            final long callTimeout = this.getCallTimeoutForProxyInvoke(callMethod, method, args);
            IRemoteCall remoteCall = new IRemoteCall(){

                public String getMethod() {
                    return callMethod;
                }

                public Object[] getParameters() {
                    return callParameters;
                }

                public long getTimeout() {
                    return callTimeout;
                }
            };
            return this.invokeSync(remoteCall);
        }
        catch (Throwable t) {
            if (t instanceof ServiceException) {
                throw t;
            }
            throw new ServiceException("Service exception on remote service proxy rsid=" + this.getRemoteServiceID(), 5, t);
        }
    }

    protected Object invokeAsync(Method method, Object[] args) throws Throwable {
        final String invokeMethodName = this.getAsyncInvokeMethodName(method);
        final AsyncArgs asyncArgs = this.getAsyncArgs(method, args);
        IRemoteCallListener listener = asyncArgs.getListener();
        IRemoteCall call = new IRemoteCall(){

            public String getMethod() {
                return invokeMethodName;
            }

            public Object[] getParameters() {
                return asyncArgs.getArgs();
            }

            public long getTimeout() {
                return DEFAULT_TIMEOUT;
            }
        };
        if (listener == null) {
            return this.callAsync(call);
        }
        this.callAsync(call, listener);
        return null;
    }

    protected AsyncArgs getAsyncArgs(Method method, Object[] args) {
        Class<?> clazz;
        IRemoteCallListener listener = null;
        Class<?> returnType = method.getReturnType();
        try {
            clazz = Class.forName("org.eclipse.equinox.concurrent.future.IFuture");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (!returnType.equals(clazz)) {
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("Async calls must include a IRemoteCallListener instance as the last argument");
            }
            Object lastArg = args[args.length - 1];
            if (lastArg instanceof IRemoteCallListener) {
                listener = (IRemoteCallListener)lastArg;
            }
            if (lastArg instanceof IAsyncCallback) {
                listener = new CallbackRemoteCallListener((IAsyncCallback)lastArg);
            }
            if (listener == null) {
                throw new IllegalArgumentException("Last argument must be an instance of IRemoteCallListener");
            }
        }
        return new AsyncArgs(listener, args);
    }

    protected String getAsyncInvokeMethodName(Method method) {
        String methodName = method.getName();
        return methodName.endsWith("Async") ? methodName.substring(0, methodName.length() - "Async".length()) : methodName;
    }

    protected void logWarning(String string, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, "org.eclipse.ecf.remoteservice", string));
        }
    }

    protected class AsyncArgs {
        private IRemoteCallListener listener;
        private Object[] args;

        public AsyncArgs(IRemoteCallListener listener, Object[] originalArgs) {
            this.listener = listener;
            if (this.listener != null) {
                int asynchArgsLength = originalArgs.length - 1;
                this.args = new Object[asynchArgsLength];
                System.arraycopy(originalArgs, 0, this.args, 0, asynchArgsLength);
            } else {
                this.args = originalArgs;
            }
        }

        public IRemoteCallListener getListener() {
            return this.listener;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }
}

