/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.eclipse.ecf.internal.remoteservice.Messages;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.RemoteCall;

public class RemoteCallMethod
extends RemoteCall
implements IRemoteCall {
    protected static final Object[] EMPTY_PARAMETERS = new Object[0];

    public static void checkSerializable(Object[] parameters) throws NotSerializableException {
        if (parameters == null) {
            return;
        }
        int i = 0;
        while (i < parameters.length) {
            if (!(parameters instanceof Serializable)) {
                throw new NotSerializableException(Messages.RemoteCallMethod_EXCEPTION_PARAMETER_NOT_SERIALIZABLE);
            }
            ++i;
        }
    }

    public static void checkForTypeMatch(Method method, Object[] parameters) {
        if (parameters == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != parameters.length) {
            throw new IllegalArgumentException(Messages.RemoteCallMethod_EXCEPTION_ARGS_NOT_RIGHT_LENGTH);
        }
        int i = 0;
        while (i < parameterTypes.length) {
            if (!parameterTypes[i].isInstance(parameters[i])) {
                throw new IllegalArgumentException(Messages.RemoteCallMethod_EXCEPTION_ARG_WRONG_TYPE);
            }
            ++i;
        }
    }

    public void setParameters(Method method, Object[] parameters) throws NotSerializableException {
        RemoteCallMethod.checkSerializable(parameters);
        RemoteCallMethod.checkForTypeMatch(method, parameters);
        this.parameters = parameters;
    }

    public RemoteCallMethod(Method method, Object[] parameters, long timeout) throws NotSerializableException {
        super(method.getName(), null, timeout);
        this.setParameters(method, parameters);
    }

    public RemoteCallMethod(Method method, Object[] parameters) throws NotSerializableException {
        this(method, parameters, DEFAULT_TIMEOUT);
    }

    public RemoteCallMethod(Method method, long timeout) {
        super(method.getName(), null, timeout);
    }

    public RemoteCallMethod(Method method) {
        this(method, DEFAULT_TIMEOUT);
    }
}

