/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.server.generic.app;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.server.generic.app.NamedGroup;

public class Connector {
    public static final int DEFAULT_PORT = 3282;
    public static final int DEFAULT_TIMEOUT = 30000;
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_SERVERNAME = "/server";
    public static final String DEFAULT_PROTOCOL = "ecftcp";
    int port = 3282;
    int timeout = 30000;
    String protocol = "ecftcp";
    String hostname = "localhost";
    boolean discovery = false;
    List groups = new ArrayList();

    public Connector(String protocol, String host, int port, int timeout, boolean discovery) {
        if (protocol != null && !protocol.equals("")) {
            this.protocol = protocol;
        }
        if (host != null && !host.equals("")) {
            this.hostname = host;
        } else {
            try {
                InetAddress addr = InetAddress.getLocalHost();
                this.hostname = this.getHostNameForAddressWithoutLookup(addr);
            }
            catch (Exception e) {
                this.hostname = DEFAULT_HOSTNAME;
            }
        }
        this.port = port;
        this.timeout = timeout;
        this.discovery = discovery;
    }

    private String getHostNameForAddressWithoutLookup(InetAddress inetAddress) {
        String inetAddressStr = inetAddress.toString();
        int slashPos = inetAddressStr.indexOf(47);
        if (slashPos == 0) {
            return inetAddressStr.substring(1);
        }
        return inetAddressStr.substring(0, slashPos);
    }

    public Connector(String protocol, String host, int port, int timeout) {
        this(protocol, host, port, timeout, false);
    }

    public boolean shouldRegisterForDiscovery() {
        return this.discovery;
    }

    public boolean addGroup(NamedGroup grp) {
        if (grp == null) {
            return false;
        }
        Iterator i = this.groups.iterator();
        while (i.hasNext()) {
            NamedGroup namedGroup = (NamedGroup)i.next();
            if (!namedGroup.getName().equals(grp.getName())) continue;
            return false;
        }
        this.groups.add(grp);
        grp.setParent(this);
        return true;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List getGroups() {
        return this.groups;
    }

    public String getID() {
        return String.valueOf(this.getProtocol()) + "://" + this.getHostname() + ":" + this.getPort();
    }
}

