/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.trace.GitTraceLocation;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.securestorage.EGitSecureStore;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin
implements DebugOptionsListener {
    private static Activator plugin;
    private RepositoryCache repositoryCache;
    private RepositoryUtil repositoryUtil;
    private EGitSecureStore secureStore;

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static IStatus error(String message, Throwable thr) {
        return new Status(4, Activator.getPluginId(), 0, message, thr);
    }

    public static void logError(String message, Throwable thr) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getPluginId(), 0, message, thr));
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", context.getBundle().getSymbolicName());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.repositoryCache = new RepositoryCache();
        try {
            GitProjectData.reconfigureWindowCache();
        }
        catch (RuntimeException e) {
            Activator.logError(CoreText.Activator_ReconfigureWindowCacheError, e);
        }
        GitProjectData.attachToWorkspace(true);
        this.repositoryUtil = new RepositoryUtil();
        this.secureStore = new EGitSecureStore(SecurePreferencesFactory.getDefault());
    }

    public void optionsChanged(DebugOptions options) {
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }

    public RepositoryUtil getRepositoryUtil() {
        return this.repositoryUtil;
    }

    public EGitSecureStore getSecureStore() {
        return this.secureStore;
    }

    public void stop(BundleContext context) throws Exception {
        GitProjectData.detachFromWorkspace();
        this.repositoryCache = null;
        this.repositoryUtil.dispose();
        this.repositoryUtil = null;
        this.secureStore = null;
        super.stop(context);
        plugin = null;
    }
}

