/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.egit.core.ContainerTreeIterator;
import org.eclipse.egit.core.IteratorService;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;

public class AdaptableFileTreeIterator
extends FileTreeIterator {
    IWorkspaceRoot root;

    public AdaptableFileTreeIterator(Repository repository, IWorkspaceRoot workspaceRoot) {
        super(repository.getWorkTree(), FS.DETECTED, (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY));
        this.root = workspaceRoot;
    }

    protected AdaptableFileTreeIterator(AdaptableFileTreeIterator parent, File path, IWorkspaceRoot workspaceRoot) {
        super((FileTreeIterator)parent, path, FS.DETECTED);
        this.root = workspaceRoot;
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader repo) throws IncorrectObjectTypeException, IOException {
        File currentFile = ((FileTreeIterator.FileEntry)this.current()).getFile();
        IContainer container = IteratorService.findContainer(this.root, currentFile);
        if (container != null) {
            return new ContainerTreeIterator((WorkingTreeIterator)this, container);
        }
        return new AdaptableFileTreeIterator(this, currentFile, this.root);
    }
}

