/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.FS;
import org.eclipse.team.core.Team;

public class ContainerTreeIterator
extends WorkingTreeIterator {
    private static final QualifiedName FILE_LENGTH_KEY = new QualifiedName(Activator.getPluginId(), "fileLength");
    private final IContainer node;
    private static final IResourceChangeListener rcl = new RCL();

    private static String computePrefix(IContainer base) {
        RepositoryMapping rm = RepositoryMapping.getMapping((IResource)base);
        if (rm == null) {
            throw new IllegalArgumentException("Not in a Git project: " + base);
        }
        return rm.getRepoRelativePath((IResource)base);
    }

    public ContainerTreeIterator(Repository repository, IContainer base) {
        super(ContainerTreeIterator.computePrefix(base), (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY));
        ContainerTreeIterator.registerRCL();
        this.node = base;
        this.init(this.entries());
    }

    public ContainerTreeIterator(Repository repository, IWorkspaceRoot root) {
        super("", (WorkingTreeOptions)repository.getConfig().get(WorkingTreeOptions.KEY));
        ContainerTreeIterator.registerRCL();
        this.node = root;
        this.init(this.entries());
    }

    public ContainerTreeIterator(WorkingTreeIterator p, IContainer base) {
        super(p);
        ContainerTreeIterator.registerRCL();
        this.node = base;
        this.init(this.entries());
    }

    public AbstractTreeIterator createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        if (FileMode.TREE.equals(this.mode)) {
            return new ContainerTreeIterator(this, (IContainer)((ResourceEntry)this.current()).rsrc);
        }
        throw new IncorrectObjectTypeException(ObjectId.zeroId(), "tree");
    }

    public ResourceEntry getResourceEntry() {
        return (ResourceEntry)this.current();
    }

    private WorkingTreeIterator.Entry[] entries() {
        IResource[] all;
        try {
            all = this.node.members(8);
        }
        catch (CoreException coreException) {
            return EOF;
        }
        WorkingTreeIterator.Entry[] r = new WorkingTreeIterator.Entry[all.length];
        int i = 0;
        while (i < r.length) {
            r[i] = new ResourceEntry(all[i]);
            ++i;
        }
        return r;
    }

    public boolean isEntryIgnored() throws IOException {
        return super.isEntryIgnored() || this.isEntryIgnoredByTeamProvider(this.getResourceEntry().getResource());
    }

    private boolean isEntryIgnoredByTeamProvider(IResource resource) {
        if (resource.getType() == 8) {
            return false;
        }
        if (Team.isIgnoredHint((IResource)resource)) {
            return true;
        }
        return this.isEntryIgnoredByTeamProvider((IResource)resource.getParent());
    }

    private static void registerRCL() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(rcl, 1);
    }

    private static class RCL
    implements IResourceChangeListener {
        private RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        IResource resource = delta.getResource();
                        if (resource != null && resource.getType() == 1) {
                            try {
                                resource.setSessionProperty(FILE_LENGTH_KEY, null);
                            }
                            catch (CoreException coreException) {}
                        }
                        return true;
                    }
                }, true);
            }
            catch (CoreException coreException) {}
        }
    }

    public static class ResourceEntry
    extends WorkingTreeIterator.Entry {
        final IResource rsrc;
        private final FileMode mode;
        private long length = -1L;

        ResourceEntry(IResource f) {
            this.rsrc = f;
            switch (f.getType()) {
                case 1: {
                    if (FS.DETECTED.supportsExecute() && FS.DETECTED.canExecute(this.asFile())) {
                        this.mode = FileMode.EXECUTABLE_FILE;
                        break;
                    }
                    this.mode = FileMode.REGULAR_FILE;
                    break;
                }
                case 2: 
                case 4: {
                    IContainer c = (IContainer)f;
                    if (c.findMember(".git") != null) {
                        this.mode = FileMode.GITLINK;
                        break;
                    }
                    this.mode = FileMode.TREE;
                    break;
                }
                default: {
                    this.mode = FileMode.MISSING;
                }
            }
        }

        public FileMode getMode() {
            return this.mode;
        }

        public String getName() {
            if (this.rsrc.getType() == 4) {
                return this.rsrc.getLocation().lastSegment();
            }
            return this.rsrc.getName();
        }

        public long getLength() {
            if (this.length < 0L) {
                if (this.rsrc.getType() == 1) {
                    Long fileLength = null;
                    try {
                        fileLength = (Long)this.rsrc.getSessionProperty(FILE_LENGTH_KEY);
                    }
                    catch (CoreException coreException) {}
                    if (fileLength != null) {
                        this.length = fileLength;
                    } else {
                        this.length = this.asFile().length();
                        try {
                            this.rsrc.setSessionProperty(FILE_LENGTH_KEY, (Object)this.length);
                        }
                        catch (CoreException coreException) {}
                    }
                } else {
                    this.length = 0L;
                }
            }
            return this.length;
        }

        public long getLastModified() {
            return this.rsrc.getLocalTimeStamp();
        }

        public InputStream openInputStream() throws IOException {
            if (this.rsrc.getType() == 1) {
                try {
                    return ((IFile)this.rsrc).getContents(true);
                }
                catch (CoreException err) {
                    IOException ioe = new IOException(err.getMessage());
                    ioe.initCause(err);
                    throw ioe;
                }
            }
            throw new IOException("Not a regular file: " + this.rsrc);
        }

        public IResource getResource() {
            return this.rsrc;
        }

        private File asFile() {
            return ((IFile)this.rsrc).getLocation().toFile();
        }
    }
}

