/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import java.io.IOException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.CoreText;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.storage.IndexBlobStorage;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileRevision;

class IndexFileRevision
extends GitFileRevision
implements IFileRevision {
    private final Repository db;
    private final String path;
    private ObjectId blobId;

    IndexFileRevision(Repository repo, String fileName) {
        super(fileName);
        this.db = repo;
        this.path = fileName;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        if (this.blobId == null) {
            this.blobId = this.locateBlobObjectId();
        }
        return new IndexBlobStorage(this.db, this.path, this.blobId);
    }

    public boolean isPropertyMissing() {
        return false;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return null;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return null;
    }

    public String getContentIdentifier() {
        return "Index";
    }

    private ObjectId locateBlobObjectId() throws CoreException {
        try {
            DirCacheEntry entry = this.db.readDirCache().getEntry(this.path);
            if (entry == null) {
                throw new CoreException(Activator.error(NLS.bind((String)CoreText.IndexFileRevision_indexEntryNotFound, (Object)this.path), null));
            }
            return entry.getObjectId();
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(NLS.bind((String)CoreText.IndexFileRevision_errorLookingUpPath, (Object)this.path), e));
        }
    }
}

